/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.source.gcs;

import com.google.cloud.storage.Blob;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.Metadata;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class GcsSource
implements DocumentSource {
    private final InputStream inputStream;
    private final Metadata metadata;

    public GcsSource(Blob blob) {
        this.inputStream = Channels.newInputStream((ReadableByteChannel)blob.reader(new Blob.BlobSourceOption[0]));
        this.metadata = GcsSource.getMetadataForBlob(blob);
    }

    public InputStream inputStream() {
        return this.inputStream;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    private static Metadata getMetadataForBlob(Blob blob) {
        Metadata metadata = new Metadata();
        metadata.put("source", "gs://" + blob.getBucket() + "/" + blob.getName());
        metadata.put("bucket", blob.getBucket());
        metadata.put("name", blob.getName());
        metadata.put("contentType", blob.getContentType());
        metadata.put("size", blob.getSize().longValue());
        metadata.put("createTime", blob.getCreateTimeOffsetDateTime().toString());
        metadata.put("updateTime", blob.getUpdateTimeOffsetDateTime().toString());
        return metadata;
    }
}

