/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.source.azure.storage.blob;

import com.azure.storage.blob.models.BlobProperties;
import dev.langchain4j.data.document.DocumentSource;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.internal.ValidationUtils;
import java.io.InputStream;

public class AzureBlobStorageSource
implements DocumentSource {
    public static final String SOURCE = "source";
    private final InputStream inputStream;
    private final String accountName;
    private final String containerName;
    private final String blobName;
    private final BlobProperties properties;

    public AzureBlobStorageSource(InputStream inputStream, String containerName, String accountName, String blobName, BlobProperties properties) {
        this.inputStream = (InputStream)ValidationUtils.ensureNotNull((Object)inputStream, (String)"inputStream");
        this.accountName = ValidationUtils.ensureNotBlank((String)accountName, (String)"accountName");
        this.containerName = ValidationUtils.ensureNotBlank((String)containerName, (String)"containerName");
        this.blobName = ValidationUtils.ensureNotBlank((String)blobName, (String)"blobName");
        this.properties = (BlobProperties)ValidationUtils.ensureNotNull((Object)properties, (String)"properties");
    }

    public InputStream inputStream() {
        return this.inputStream;
    }

    public Metadata metadata() {
        Metadata metadata = new Metadata();
        metadata.put(SOURCE, String.format("https://%s.blob.core.windows.net/%s/%s", this.accountName, this.containerName, this.blobName));
        metadata.add("azure_storage_blob_creation_time", (Object)this.properties.getCreationTime());
        metadata.add("azure_storage_blob_last_modified", (Object)this.properties.getLastModified());
        metadata.put("azure_storage_blob_content_length", String.valueOf(this.properties.getBlobSize()));
        return metadata;
    }
}

