/**
 * Contains interfaces and classes for model catalog functionality.
 *
 * <p>The model catalog API allows customers to programmatically discover available models
 * from different LLM providers without needing to visit individual provider websites.
 *
 * <p>Key interfaces and classes:
 * <ul>
 *   <li>{@link dev.langchain4j.model.catalog.ModelCatalog} - Main interface for listing models</li>
 *   <li>{@link dev.langchain4j.model.catalog.ModelDescription} - Represents metadata about a model</li>
 *   <li>{@link dev.langchain4j.model.catalog.ModelType} - Enum of model types</li>
 * </ul>
 */
package dev.langchain4j.model.catalog;
