/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.internal.TypeUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonAnyOfSchema;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNullSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonReferenceSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import dev.langchain4j.model.output.structured.Description;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public class JsonSchemaElementHelper {
    private static final String DEFAULT_UUID_DESCRIPTION = "String in a UUID format";

    public static JsonSchemaElement jsonSchemaElementFrom(Class<?> clazz) {
        return JsonSchemaElementHelper.jsonSchemaElementFrom(clazz, clazz, null, false, new LinkedHashMap());
    }

    public static JsonSchemaElement jsonSchemaElementFrom(Class<?> clazz, Type type, String fieldDescription, boolean areSubFieldsRequiredByDefault, Map<Class<?>, VisitedClassMetadata> visited) {
        if (TypeUtils.isJsonString(clazz)) {
            return JsonStringSchema.builder().description(Optional.ofNullable(fieldDescription).orElse(JsonSchemaElementHelper.descriptionFrom(clazz))).build();
        }
        if (TypeUtils.isJsonInteger(clazz)) {
            return JsonIntegerSchema.builder().description(fieldDescription).build();
        }
        if (TypeUtils.isJsonNumber(clazz)) {
            return JsonNumberSchema.builder().description(fieldDescription).build();
        }
        if (TypeUtils.isJsonBoolean(clazz)) {
            return JsonBooleanSchema.builder().description(fieldDescription).build();
        }
        if (clazz.isEnum()) {
            return JsonEnumSchema.builder().enumValues(Arrays.stream(clazz.getEnumConstants()).map(Object::toString).collect(Collectors.toList())).description(Optional.ofNullable(fieldDescription).orElse(JsonSchemaElementHelper.descriptionFrom(clazz))).build();
        }
        if (clazz.isArray()) {
            return JsonArraySchema.builder().items(JsonSchemaElementHelper.jsonSchemaElementFrom(clazz.getComponentType(), null, null, areSubFieldsRequiredByDefault, visited)).description(fieldDescription).build();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return JsonArraySchema.builder().items(JsonSchemaElementHelper.jsonSchemaElementFrom(JsonSchemaElementHelper.getActualType(type), null, null, areSubFieldsRequiredByDefault, visited)).description(fieldDescription).build();
        }
        return JsonSchemaElementHelper.jsonObjectOrReferenceSchemaFrom(clazz, fieldDescription, areSubFieldsRequiredByDefault, visited, false);
    }

    public static JsonSchemaElement jsonObjectOrReferenceSchemaFrom(Class<?> type, String description, boolean areSubFieldsRequiredByDefault, Map<Class<?>, VisitedClassMetadata> visited, boolean setDefinitions) {
        if (visited.containsKey(type) && JsonSchemaElementHelper.isCustomClass(type)) {
            VisitedClassMetadata visitedClassMetadata2 = visited.get(type);
            JsonSchemaElement jsonSchemaElement = visitedClassMetadata2.jsonSchemaElement;
            if (jsonSchemaElement instanceof JsonReferenceSchema) {
                visitedClassMetadata2.recursionDetected = true;
            }
            return jsonSchemaElement;
        }
        String reference = Utils.generateUUIDFrom(type.getName());
        JsonReferenceSchema jsonReferenceSchema = JsonReferenceSchema.builder().reference(reference).build();
        visited.put(type, new VisitedClassMetadata(jsonReferenceSchema, reference, false));
        LinkedHashMap<String, JsonSchemaElement> properties = new LinkedHashMap<String, JsonSchemaElement>();
        ArrayList<String> required = new ArrayList<String>();
        for (Field field : type.getDeclaredFields()) {
            String fieldName = field.getName();
            if (Modifier.isStatic(field.getModifiers()) || fieldName.equals("__$hits$__") || fieldName.startsWith("this$")) continue;
            if (JsonSchemaElementHelper.isRequired(field, areSubFieldsRequiredByDefault)) {
                required.add(fieldName);
            }
            String fieldDescription = JsonSchemaElementHelper.descriptionFrom(field);
            JsonSchemaElement jsonSchemaElement = JsonSchemaElementHelper.jsonSchemaElementFrom(field.getType(), field.getGenericType(), fieldDescription, areSubFieldsRequiredByDefault, visited);
            properties.put(fieldName, jsonSchemaElement);
        }
        JsonObjectSchema.Builder builder = JsonObjectSchema.builder().description(Optional.ofNullable(description).orElse(JsonSchemaElementHelper.descriptionFrom(type))).addProperties(properties).required(required);
        visited.get(type).jsonSchemaElement = builder.build();
        if (setDefinitions) {
            LinkedHashMap<String, JsonSchemaElement> definitions = new LinkedHashMap<String, JsonSchemaElement>();
            visited.forEach((clazz, visitedClassMetadata) -> {
                if (visitedClassMetadata.recursionDetected) {
                    definitions.put(visitedClassMetadata.reference, visitedClassMetadata.jsonSchemaElement);
                }
            });
            if (!definitions.isEmpty()) {
                builder.definitions(definitions);
            }
        }
        return builder.build();
    }

    private static boolean isRequired(Field field, boolean defaultValue) {
        JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.required();
        }
        return defaultValue;
    }

    private static String descriptionFrom(Field field) {
        return JsonSchemaElementHelper.descriptionFrom(field.getAnnotation(Description.class));
    }

    private static String descriptionFrom(Class<?> type) {
        if (type == UUID.class) {
            return DEFAULT_UUID_DESCRIPTION;
        }
        return JsonSchemaElementHelper.descriptionFrom(type.getAnnotation(Description.class));
    }

    private static String descriptionFrom(Description description) {
        if (description == null) {
            return null;
        }
        return String.join((CharSequence)" ", description.value());
    }

    private static Class<?> getActualType(Type type) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return (Class)actualTypeArguments[0];
        }
        return null;
    }

    static boolean isCustomClass(Class<?> clazz) {
        String packageName;
        return clazz.getPackage() == null || !(packageName = clazz.getPackage().getName()).startsWith("java.") && !packageName.startsWith("javax.") && !packageName.startsWith("jdk.") && !packageName.startsWith("sun.") && !packageName.startsWith("com.sun.");
    }

    public static Map<String, Map<String, Object>> toMap(Map<String, JsonSchemaElement> properties) {
        return JsonSchemaElementHelper.toMap(properties, false);
    }

    public static Map<String, Map<String, Object>> toMap(Map<String, JsonSchemaElement> properties, boolean strict) {
        LinkedHashMap<String, Map<String, Object>> map = new LinkedHashMap<String, Map<String, Object>>();
        properties.forEach((property, value) -> map.put((String)property, JsonSchemaElementHelper.toMap(value, strict)));
        return map;
    }

    public static Map<String, Object> toMap(JsonSchemaElement jsonSchemaElement) {
        return JsonSchemaElementHelper.toMap(jsonSchemaElement, false);
    }

    public static Map<String, Object> toMap(JsonSchemaElement jsonSchemaElement, boolean strict) {
        return JsonSchemaElementHelper.toMap(jsonSchemaElement, strict, true);
    }

    public static Map<String, Object> toMap(JsonSchemaElement jsonSchemaElement, boolean strict, boolean required) {
        if (jsonSchemaElement instanceof JsonObjectSchema) {
            JsonObjectSchema jsonObjectSchema = (JsonObjectSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", JsonSchemaElementHelper.type("object", strict, required));
            if (jsonObjectSchema.description() != null) {
                map.put("description", jsonObjectSchema.description());
            }
            LinkedHashMap properties = new LinkedHashMap();
            jsonObjectSchema.properties().forEach((property, value) -> properties.put(property, JsonSchemaElementHelper.toMap(value, strict, jsonObjectSchema.required().contains(property))));
            map.put("properties", properties);
            if (strict) {
                map.put("required", jsonObjectSchema.properties().keySet().stream().toList());
            } else if (jsonObjectSchema.required() != null) {
                map.put("required", jsonObjectSchema.required());
            }
            if (strict) {
                map.put("additionalProperties", false);
            }
            if (jsonObjectSchema.definitions() != null) {
                map.put("$defs", JsonSchemaElementHelper.toMap(jsonObjectSchema.definitions(), strict));
            }
            return map;
        }
        if (jsonSchemaElement instanceof JsonArraySchema) {
            JsonArraySchema jsonArraySchema = (JsonArraySchema)jsonSchemaElement;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", JsonSchemaElementHelper.type("array", strict, required));
            if (jsonArraySchema.description() != null) {
                map.put("description", jsonArraySchema.description());
            }
            map.put("items", JsonSchemaElementHelper.toMap(jsonArraySchema.items(), strict));
            return map;
        }
        if (jsonSchemaElement instanceof JsonEnumSchema) {
            JsonEnumSchema jsonEnumSchema = (JsonEnumSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", JsonSchemaElementHelper.type("string", strict, required));
            if (jsonEnumSchema.description() != null) {
                map.put("description", jsonEnumSchema.description());
            }
            map.put("enum", jsonEnumSchema.enumValues());
            return map;
        }
        if (jsonSchemaElement instanceof JsonStringSchema) {
            JsonStringSchema jsonStringSchema = (JsonStringSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", JsonSchemaElementHelper.type("string", strict, required));
            if (jsonStringSchema.description() != null) {
                map.put("description", jsonStringSchema.description());
            }
            return map;
        }
        if (jsonSchemaElement instanceof JsonIntegerSchema) {
            JsonIntegerSchema jsonIntegerSchema = (JsonIntegerSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", JsonSchemaElementHelper.type("integer", strict, required));
            if (jsonIntegerSchema.description() != null) {
                map.put("description", jsonIntegerSchema.description());
            }
            return map;
        }
        if (jsonSchemaElement instanceof JsonNumberSchema) {
            JsonNumberSchema jsonNumberSchema = (JsonNumberSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", JsonSchemaElementHelper.type("number", strict, required));
            if (jsonNumberSchema.description() != null) {
                map.put("description", jsonNumberSchema.description());
            }
            return map;
        }
        if (jsonSchemaElement instanceof JsonBooleanSchema) {
            JsonBooleanSchema jsonBooleanSchema = (JsonBooleanSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("type", JsonSchemaElementHelper.type("boolean", strict, required));
            if (jsonBooleanSchema.description() != null) {
                map.put("description", jsonBooleanSchema.description());
            }
            return map;
        }
        if (jsonSchemaElement instanceof JsonReferenceSchema) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            String reference = ((JsonReferenceSchema)jsonSchemaElement).reference();
            if (reference != null) {
                map.put("$ref", "#/$defs/" + reference);
            }
            return map;
        }
        if (jsonSchemaElement instanceof JsonAnyOfSchema) {
            JsonAnyOfSchema jsonAnyOfSchema = (JsonAnyOfSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (jsonAnyOfSchema.description() != null) {
                map.put("description", jsonAnyOfSchema.description());
            }
            List anyOf = jsonAnyOfSchema.anyOf().stream().map(element -> JsonSchemaElementHelper.toMap(element, strict)).collect(Collectors.toList());
            map.put("anyOf", anyOf);
            return map;
        }
        if (jsonSchemaElement instanceof JsonNullSchema) {
            return Map.of("type", "null");
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(jsonSchemaElement.getClass()));
    }

    private static Object type(String type, boolean strict, boolean required) {
        if (strict && !required) {
            return new String[]{type, "null"};
        }
        return type;
    }

    public static class VisitedClassMetadata {
        public JsonSchemaElement jsonSchemaElement;
        public String reference;
        public boolean recursionDetected;

        public VisitedClassMetadata(JsonSchemaElement jsonSchemaElement, String reference, boolean recursionDetected) {
            this.jsonSchemaElement = jsonSchemaElement;
            this.reference = reference;
            this.recursionDetected = recursionDetected;
        }
    }
}

