/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import java.util.Collections;
import java.util.List;

public interface StreamingChatLanguageModel {
    default public void sendUserMessage(String userMessage, StreamingResponseHandler handler) {
        this.sendUserMessage(UserMessage.userMessage(userMessage), handler);
    }

    default public void sendUserMessage(UserMessage userMessage, StreamingResponseHandler handler) {
        this.sendMessages(Collections.singletonList(userMessage), handler);
    }

    default public void sendUserMessage(Object structuredPrompt, StreamingResponseHandler handler) {
        Prompt prompt = StructuredPromptProcessor.toPrompt(structuredPrompt);
        this.sendUserMessage(prompt.toUserMessage(), handler);
    }

    public void sendMessages(List<ChatMessage> var1, StreamingResponseHandler var2);

    public void sendMessages(List<ChatMessage> var1, List<ToolSpecification> var2, StreamingResponseHandler var3);

    public void sendMessages(List<ChatMessage> var1, ToolSpecification var2, StreamingResponseHandler var3);
}

