/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Objects;

public class ToolExecutionResultMessage
implements ChatMessage {
    private final String id;
    private final String toolName;
    private final String text;

    public ToolExecutionResultMessage(String id, String toolName, String text) {
        this.id = id;
        this.toolName = toolName;
        this.text = ValidationUtils.ensureNotBlank(text, "text");
    }

    public String id() {
        return this.id;
    }

    public String toolName() {
        return this.toolName;
    }

    public String text() {
        return this.text;
    }

    @Override
    public ChatMessageType type() {
        return ChatMessageType.TOOL_EXECUTION_RESULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolExecutionResultMessage that = (ToolExecutionResultMessage)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.toolName, that.toolName) && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.toolName, this.text);
    }

    public String toString() {
        return "ToolExecutionResultMessage { id = " + Utils.quoted(this.id) + " toolName = " + Utils.quoted(this.toolName) + " text = " + Utils.quoted(this.text) + " }";
    }

    public static ToolExecutionResultMessage from(ToolExecutionRequest request, String toolExecutionResult) {
        return new ToolExecutionResultMessage(request.id(), request.name(), toolExecutionResult);
    }

    public static ToolExecutionResultMessage from(String id, String toolName, String toolExecutionResult) {
        return new ToolExecutionResultMessage(id, toolName, toolExecutionResult);
    }

    public static ToolExecutionResultMessage toolExecutionResultMessage(ToolExecutionRequest request, String toolExecutionResult) {
        return ToolExecutionResultMessage.from(request, toolExecutionResult);
    }

    public static ToolExecutionResultMessage toolExecutionResultMessage(String id, String toolName, String toolExecutionResult) {
        return ToolExecutionResultMessage.from(id, toolName, toolExecutionResult);
    }
}

