/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.tokenizers.Tokenization;
import com.alibaba.dashscope.tokenizers.TokenizationResult;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.community.model.dashscope.QwenHelper;
import dev.langchain4j.community.model.dashscope.spi.QwenTokenizerBuilderFactory;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Collections;
import java.util.Iterator;

public class QwenTokenizer
implements Tokenizer {
    private final String apiKey;
    private final String modelName;
    private final Tokenization tokenizer;

    public QwenTokenizer(String apiKey, String modelName) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
        }
        this.apiKey = apiKey;
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)"qwen-plus");
        this.tokenizer = new Tokenization();
    }

    public int estimateTokenCountInText(String text) {
        Object prompt = QwenTokenizer.isBlank(text) ? text + "_" : text;
        try {
            GenerationParam param = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().apiKey(this.apiKey)).model(this.modelName)).prompt((String)prompt)).build();
            TokenizationResult result = this.tokenizer.call((HalfDuplexServiceParam)param);
            int tokenCount = result.getUsage().getInputTokens();
            return prompt == text ? tokenCount : tokenCount - 1;
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public int estimateTokenCountInMessage(ChatMessage message) {
        return this.estimateTokenCountInMessages(Collections.singleton(message));
    }

    public int estimateTokenCountInMessages(Iterable<ChatMessage> messages) {
        if (Utils.isNullOrEmpty(messages)) {
            return 0;
        }
        try {
            GenerationParam param = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().apiKey(this.apiKey)).model(this.modelName)).messages(QwenHelper.toQwenMessages(messages)).build();
            TokenizationResult result = this.tokenizer.call((HalfDuplexServiceParam)param);
            return result.getUsage().getInputTokens();
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public int estimateTokenCountInToolSpecifications(Iterable<ToolSpecification> toolSpecifications) {
        throw new IllegalArgumentException("Tools are currently not supported by this tokenizer");
    }

    public int estimateTokenCountInToolExecutionRequests(Iterable<ToolExecutionRequest> toolExecutionRequests) {
        throw new IllegalArgumentException("Tools are currently not supported by this tokenizer");
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = cs == null ? 0 : cs.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static QwenTokenizerBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QwenTokenizerBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QwenTokenizerBuilderFactory factory = (QwenTokenizerBuilderFactory)iterator.next();
            return (QwenTokenizerBuilder)factory.get();
        }
        return new QwenTokenizerBuilder();
    }

    public static class QwenTokenizerBuilder {
        private String apiKey;
        private String modelName;

        public QwenTokenizerBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QwenTokenizerBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QwenTokenizer build() {
            return new QwenTokenizer(this.apiKey, this.modelName);
        }
    }
}

