/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.conversation.ConversationParam;
import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversation;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.protocol.Protocol;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.community.model.dashscope.QwenHelper;
import dev.langchain4j.community.model.dashscope.QwenStreamingResponseBuilder;
import dev.langchain4j.community.model.dashscope.spi.QwenStreamingChatModelBuilderFactory;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QwenStreamingChatModel
implements StreamingChatLanguageModel {
    private static final Logger log = LoggerFactory.getLogger(QwenStreamingChatModel.class);
    private final String apiKey;
    private final String modelName;
    private final Double topP;
    private final Integer topK;
    private final Boolean enableSearch;
    private final Integer seed;
    private final Float repetitionPenalty;
    private final Float temperature;
    private final List<String> stops;
    private final Integer maxTokens;
    private final Generation generation;
    private final MultiModalConversation conv;
    private final boolean isMultimodalModel;
    private final List<ChatModelListener> listeners;

    public QwenStreamingChatModel(String baseUrl, String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed, Float repetitionPenalty, Float temperature, List<String> stops, Integer maxTokens, List<ChatModelListener> listeners) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
        }
        this.modelName = Utils.isNullOrBlank((String)modelName) ? "qwen-plus" : modelName;
        this.enableSearch = enableSearch != null && enableSearch != false;
        this.apiKey = apiKey;
        this.topP = topP;
        this.topK = topK;
        this.seed = seed;
        this.repetitionPenalty = repetitionPenalty;
        this.temperature = temperature;
        this.stops = stops;
        this.maxTokens = maxTokens;
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
        this.isMultimodalModel = QwenHelper.isMultimodalModel(this.modelName);
        if (Utils.isNullOrBlank((String)baseUrl)) {
            this.conv = this.isMultimodalModel ? new MultiModalConversation() : null;
            this.generation = this.isMultimodalModel ? null : new Generation();
        } else if (baseUrl.startsWith("wss://")) {
            this.conv = this.isMultimodalModel ? new MultiModalConversation(Protocol.WEBSOCKET.getValue(), baseUrl) : null;
            this.generation = this.isMultimodalModel ? null : new Generation(Protocol.WEBSOCKET.getValue(), baseUrl);
        } else {
            this.conv = this.isMultimodalModel ? new MultiModalConversation(Protocol.HTTP.getValue(), baseUrl) : null;
            this.generation = this.isMultimodalModel ? null : new Generation(Protocol.HTTP.getValue(), baseUrl);
        }
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        if (this.isMultimodalModel) {
            this.generateByMultimodalModel(messages, handler);
        } else {
            this.generateByNonMultimodalModel(messages, null, null, handler);
        }
    }

    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        if (this.isMultimodalModel) {
            throw new IllegalArgumentException("Tools are currently not supported by this model");
        }
        this.generateByNonMultimodalModel(messages, toolSpecifications, null, handler);
    }

    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        if (this.isMultimodalModel) {
            throw new IllegalArgumentException("Tools are currently not supported by this model");
        }
        this.generateByNonMultimodalModel(messages, null, toolSpecification, handler);
    }

    private void generateByNonMultimodalModel(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted, final StreamingResponseHandler<AiMessage> handler) {
        GenerationParam.GenerationParamBuilder builder = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).repetitionPenalty(this.repetitionPenalty).temperature(this.temperature).maxTokens(this.maxTokens).incrementalOutput(Boolean.valueOf(true)).messages(QwenHelper.toQwenMessages(messages)).resultFormat(ConversationParam.ResultFormat.MESSAGE);
        if (this.stops != null) {
            builder.stopStrings(this.stops);
        }
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            builder.tools(QwenHelper.toToolFunctions(toolSpecifications));
        } else if (toolThatMustBeExecuted != null) {
            builder.tools(QwenHelper.toToolFunctions(Collections.singleton(toolThatMustBeExecuted)));
            builder.toolChoice((Object)QwenHelper.toToolFunction(toolThatMustBeExecuted));
        }
        GenerationParam param = builder.build();
        final ChatModelRequest modelListenerRequest = QwenHelper.createModelListenerRequest(param, messages, toolSpecifications);
        final ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        QwenHelper.onListenRequest(this.listeners, modelListenerRequest, attributes);
        final QwenStreamingResponseBuilder responseBuilder = new QwenStreamingResponseBuilder();
        final AtomicReference responseId = new AtomicReference();
        try {
            this.generation.streamCall((HalfDuplexServiceParam)param, (ResultCallback)new ResultCallback<GenerationResult>(){

                public void onEvent(GenerationResult result) {
                    String delta = responseBuilder.append(result);
                    if (Utils.isNotNullOrBlank((String)result.getRequestId())) {
                        responseId.set(result.getRequestId());
                    }
                    if (Utils.isNotNullOrBlank((String)delta)) {
                        handler.onNext(delta);
                    }
                }

                public void onComplete() {
                    Response<AiMessage> response = responseBuilder.build();
                    QwenHelper.onListenResponse(QwenStreamingChatModel.this.listeners, (String)responseId.get(), response, modelListenerRequest, attributes);
                    handler.onComplete(response);
                }

                public void onError(Exception e) {
                    QwenHelper.onListenError(QwenStreamingChatModel.this.listeners, (String)responseId.get(), e, modelListenerRequest, responseBuilder.build(), attributes);
                    handler.onError((Throwable)e);
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException | RuntimeException e) {
            QwenHelper.onListenError(this.listeners, null, e, modelListenerRequest, null, attributes);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    private void generateByMultimodalModel(List<ChatMessage> messages, final StreamingResponseHandler<AiMessage> handler) {
        MultiModalConversationParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).temperature(this.temperature).maxLength(this.maxTokens).incrementalOutput(Boolean.valueOf(true)).messages(QwenHelper.toQwenMultiModalMessages(messages)).build();
        final ChatModelRequest modelListenerRequest = QwenHelper.createModelListenerRequest(param, messages, null);
        final ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        QwenHelper.onListenRequest(this.listeners, modelListenerRequest, attributes);
        final QwenStreamingResponseBuilder responseBuilder = new QwenStreamingResponseBuilder();
        final AtomicReference responseId = new AtomicReference();
        try {
            this.conv.streamCall(param, (ResultCallback)new ResultCallback<MultiModalConversationResult>(){

                public void onEvent(MultiModalConversationResult result) {
                    String delta = responseBuilder.append(result);
                    if (Utils.isNotNullOrBlank((String)result.getRequestId())) {
                        responseId.set(result.getRequestId());
                    }
                    if (Utils.isNotNullOrBlank((String)delta)) {
                        handler.onNext(delta);
                    }
                }

                public void onComplete() {
                    Response<AiMessage> response = responseBuilder.build();
                    QwenHelper.onListenResponse(QwenStreamingChatModel.this.listeners, (String)responseId.get(), response, modelListenerRequest, attributes);
                    handler.onComplete(response);
                }

                public void onError(Exception e) {
                    QwenHelper.onListenError(QwenStreamingChatModel.this.listeners, (String)responseId.get(), e, modelListenerRequest, responseBuilder.build(), attributes);
                    handler.onError((Throwable)e);
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException | UploadFileException | RuntimeException e) {
            QwenHelper.onListenError(this.listeners, null, e, modelListenerRequest, null, attributes);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public static QwenStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QwenStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QwenStreamingChatModelBuilderFactory factory = (QwenStreamingChatModelBuilderFactory)iterator.next();
            return (QwenStreamingChatModelBuilder)factory.get();
        }
        return new QwenStreamingChatModelBuilder();
    }

    public static class QwenStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double topP;
        private Integer topK;
        private Boolean enableSearch;
        private Integer seed;
        private Float repetitionPenalty;
        private Float temperature;
        private List<String> stops;
        private Integer maxTokens;
        private List<ChatModelListener> listeners;

        public QwenStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QwenStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QwenStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QwenStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QwenStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public QwenStreamingChatModelBuilder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public QwenStreamingChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public QwenStreamingChatModelBuilder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public QwenStreamingChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public QwenStreamingChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public QwenStreamingChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public QwenStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public QwenStreamingChatModel build() {
            return new QwenStreamingChatModel(this.baseUrl, this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed, this.repetitionPenalty, this.temperature, this.stops, this.maxTokens, this.listeners);
        }
    }
}

