/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.conversation.ConversationParam;
import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversation;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import com.alibaba.dashscope.exception.UploadFileException;
import com.alibaba.dashscope.protocol.Protocol;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.community.model.dashscope.QwenHelper;
import dev.langchain4j.community.model.dashscope.spi.QwenChatModelBuilderFactory;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QwenChatModel
implements ChatLanguageModel {
    private static final Logger log = LoggerFactory.getLogger(QwenChatModel.class);
    private final String apiKey;
    private final String modelName;
    private final Double topP;
    private final Integer topK;
    private final Boolean enableSearch;
    private final Integer seed;
    private final Float repetitionPenalty;
    private final Float temperature;
    private final List<String> stops;
    private final Integer maxTokens;
    private final Generation generation;
    private final MultiModalConversation conv;
    private final boolean isMultimodalModel;
    private final List<ChatModelListener> listeners;

    protected QwenChatModel(String baseUrl, String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed, Float repetitionPenalty, Float temperature, List<String> stops, Integer maxTokens, List<ChatModelListener> listeners) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
        }
        this.modelName = Utils.isNullOrBlank((String)modelName) ? "qwen-plus" : modelName;
        this.enableSearch = enableSearch != null && enableSearch != false;
        this.apiKey = apiKey;
        this.topP = topP;
        this.topK = topK;
        this.seed = seed;
        this.repetitionPenalty = repetitionPenalty;
        this.temperature = temperature;
        this.stops = stops;
        this.maxTokens = maxTokens;
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
        this.isMultimodalModel = QwenHelper.isMultimodalModel(this.modelName);
        if (Utils.isNullOrBlank((String)baseUrl)) {
            this.conv = this.isMultimodalModel ? new MultiModalConversation() : null;
            this.generation = this.isMultimodalModel ? null : new Generation();
        } else if (baseUrl.startsWith("wss://")) {
            this.conv = this.isMultimodalModel ? new MultiModalConversation(Protocol.WEBSOCKET.getValue(), baseUrl) : null;
            this.generation = this.isMultimodalModel ? null : new Generation(Protocol.WEBSOCKET.getValue(), baseUrl);
        } else {
            this.conv = this.isMultimodalModel ? new MultiModalConversation(Protocol.HTTP.getValue(), baseUrl) : null;
            this.generation = this.isMultimodalModel ? null : new Generation(Protocol.HTTP.getValue(), baseUrl);
        }
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.isMultimodalModel ? this.generateByMultimodalModel(messages, null, null) : this.generateByNonMultimodalModel(messages, null, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return this.isMultimodalModel ? this.generateByMultimodalModel(messages, toolSpecifications, null) : this.generateByNonMultimodalModel(messages, toolSpecifications, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.isMultimodalModel ? this.generateByMultimodalModel(messages, null, toolSpecification) : this.generateByNonMultimodalModel(messages, null, toolSpecification);
    }

    private Response<AiMessage> generateByNonMultimodalModel(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted) {
        GenerationParam.GenerationParamBuilder builder = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).repetitionPenalty(this.repetitionPenalty).temperature(this.temperature).maxTokens(this.maxTokens).messages(QwenHelper.toQwenMessages(messages)).resultFormat(ConversationParam.ResultFormat.MESSAGE);
        if (this.stops != null) {
            builder.stopStrings(this.stops);
        }
        if (!Utils.isNullOrEmpty(toolSpecifications)) {
            builder.tools(QwenHelper.toToolFunctions(toolSpecifications));
        } else if (toolThatMustBeExecuted != null) {
            builder.tools(QwenHelper.toToolFunctions(Collections.singleton(toolThatMustBeExecuted)));
            builder.toolChoice((Object)QwenHelper.toToolFunction(toolThatMustBeExecuted));
        }
        GenerationParam param = builder.build();
        ChatModelRequest modelListenerRequest = QwenHelper.createModelListenerRequest(param, messages, toolSpecifications);
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        QwenHelper.onListenRequest(this.listeners, modelListenerRequest, attributes);
        try {
            GenerationResult result = this.generation.call((HalfDuplexServiceParam)param);
            Response response = Response.from((Object)QwenHelper.aiMessageFrom(result), (TokenUsage)QwenHelper.tokenUsageFrom(result), (FinishReason)QwenHelper.finishReasonFrom(result));
            QwenHelper.onListenResponse(this.listeners, result.getRequestId(), (Response<AiMessage>)response, modelListenerRequest, attributes);
            return response;
        }
        catch (InputRequiredException | NoApiKeyException | RuntimeException e) {
            QwenHelper.onListenError(this.listeners, null, e, modelListenerRequest, null, attributes);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    private Response<AiMessage> generateByMultimodalModel(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted) {
        if (toolThatMustBeExecuted != null || !Utils.isNullOrEmpty(toolSpecifications)) {
            throw new IllegalArgumentException("Tools are currently not supported by this model");
        }
        MultiModalConversationParam param = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).temperature(this.temperature).maxLength(this.maxTokens).messages(QwenHelper.toQwenMultiModalMessages(messages)).build();
        ChatModelRequest modelListenerRequest = QwenHelper.createModelListenerRequest(param, messages, toolSpecifications);
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        QwenHelper.onListenRequest(this.listeners, modelListenerRequest, attributes);
        try {
            MultiModalConversationResult result = this.conv.call(param);
            String answer = QwenHelper.answerFrom(result);
            Response response = Response.from((Object)AiMessage.from((String)answer), (TokenUsage)QwenHelper.tokenUsageFrom(result), (FinishReason)QwenHelper.finishReasonFrom(result));
            QwenHelper.onListenResponse(this.listeners, result.getRequestId(), (Response<AiMessage>)response, modelListenerRequest, attributes);
            return response;
        }
        catch (NoApiKeyException | UploadFileException | RuntimeException e) {
            QwenHelper.onListenError(this.listeners, null, e, modelListenerRequest, null, attributes);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public static QwenChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QwenChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QwenChatModelBuilderFactory factory = (QwenChatModelBuilderFactory)iterator.next();
            return (QwenChatModelBuilder)factory.get();
        }
        return new QwenChatModelBuilder();
    }

    public static class QwenChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Double topP;
        private Integer topK;
        private Boolean enableSearch;
        private Integer seed;
        private Float repetitionPenalty;
        private Float temperature;
        private List<String> stops;
        private Integer maxTokens;
        private List<ChatModelListener> listeners;

        public QwenChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QwenChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QwenChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QwenChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QwenChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public QwenChatModelBuilder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public QwenChatModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public QwenChatModelBuilder repetitionPenalty(Float repetitionPenalty) {
            this.repetitionPenalty = repetitionPenalty;
            return this;
        }

        public QwenChatModelBuilder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public QwenChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public QwenChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public QwenChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public QwenChatModel build() {
            return new QwenChatModel(this.baseUrl, this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed, this.repetitionPenalty, this.temperature, this.stops, this.maxTokens, this.listeners);
        }
    }
}

