/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.cassandra;

import com.dtsx.astra.sdk.cassio.MetadataVectorCassandraTable;
import com.dtsx.astra.sdk.cassio.SimilarityMetric;
import com.dtsx.astra.sdk.cassio.SimilaritySearchQuery;
import com.dtsx.astra.sdk.cassio.SimilaritySearchResult;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.CosineSimilarity;
import dev.langchain4j.store.embedding.EmbeddingMatch;
import dev.langchain4j.store.embedding.EmbeddingStore;
import dev.langchain4j.store.embedding.RelevanceScore;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

abstract class CassandraEmbeddingStoreSupport
implements EmbeddingStore<TextSegment> {
    protected MetadataVectorCassandraTable embeddingTable;

    CassandraEmbeddingStoreSupport() {
    }

    public String add(@NonNull Embedding embedding) {
        if (embedding == null) {
            throw new NullPointerException("embedding is marked non-null but is null");
        }
        return this.add(embedding, null);
    }

    public String add(@NonNull Embedding embedding, TextSegment textSegment) {
        if (embedding == null) {
            throw new NullPointerException("embedding is marked non-null but is null");
        }
        MetadataVectorCassandraTable.Record record = new MetadataVectorCassandraTable.Record(embedding.vectorAsList());
        if (textSegment != null) {
            record.setBody(textSegment.text());
            record.setMetadata(textSegment.metadata().asMap());
        }
        this.embeddingTable.put(record);
        return record.getRowId();
    }

    public void add(@NonNull String rowId, @NonNull Embedding embedding) {
        if (rowId == null) {
            throw new NullPointerException("rowId is marked non-null but is null");
        }
        if (embedding == null) {
            throw new NullPointerException("embedding is marked non-null but is null");
        }
        this.embeddingTable.put(new MetadataVectorCassandraTable.Record(rowId, embedding.vectorAsList()));
    }

    public List<String> addAll(List<Embedding> embeddingList) {
        return embeddingList.stream().map(Embedding::vectorAsList).map(MetadataVectorCassandraTable.Record::new).peek(arg_0 -> ((MetadataVectorCassandraTable)this.embeddingTable).putAsync(arg_0)).map(MetadataVectorCassandraTable.Record::getRowId).collect(Collectors.toList());
    }

    public List<String> addAll(List<Embedding> embeddingList, List<TextSegment> textSegmentList) {
        if (embeddingList == null || textSegmentList == null || embeddingList.size() != textSegmentList.size()) {
            throw new IllegalArgumentException("embeddingList and textSegmentList must not be null and have the same size");
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < embeddingList.size(); ++i) {
            ids.add(this.add(embeddingList.get(i), textSegmentList.get(i)));
        }
        return ids;
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding embedding, int maxResults, double minScore) {
        return this.embeddingTable.similaritySearch(SimilaritySearchQuery.builder().embeddings(embedding.vectorAsList()).recordCount(ValidationUtils.ensureGreaterThanZero((Integer)maxResults, (String)"maxResults")).threshold(CosineSimilarity.fromRelevanceScore((double)ValidationUtils.ensureBetween((Double)minScore, (double)0.0, (double)1.0, (String)"minScore"))).distance(SimilarityMetric.COS).build()).stream().map(CassandraEmbeddingStoreSupport::mapSearchResult).collect(Collectors.toList());
    }

    private static EmbeddingMatch<TextSegment> mapSearchResult(SimilaritySearchResult<MetadataVectorCassandraTable.Record> record) {
        return new EmbeddingMatch(Double.valueOf(RelevanceScore.fromCosineSimilarity((double)record.getSimilarity())), ((MetadataVectorCassandraTable.Record)record.getEmbedded()).getRowId(), Embedding.from((List)((MetadataVectorCassandraTable.Record)record.getEmbedded()).getVector()), (Object)TextSegment.from((String)((MetadataVectorCassandraTable.Record)record.getEmbedded()).getBody(), (Metadata)new Metadata(((MetadataVectorCassandraTable.Record)record.getEmbedded()).getMetadata())));
    }

    public List<EmbeddingMatch<TextSegment>> findRelevant(Embedding embedding, int maxResults, double minScore, Metadata metadata) {
        SimilaritySearchQuery.SimilaritySearchQueryBuilder builder = SimilaritySearchQuery.builder().embeddings(embedding.vectorAsList()).recordCount(ValidationUtils.ensureGreaterThanZero((Integer)maxResults, (String)"maxResults")).threshold(CosineSimilarity.fromRelevanceScore((double)ValidationUtils.ensureBetween((Double)minScore, (double)0.0, (double)1.0, (String)"minScore")));
        if (metadata != null) {
            builder.metaData(metadata.asMap());
        }
        return this.embeddingTable.similaritySearch(builder.build()).stream().map(CassandraEmbeddingStoreSupport::mapSearchResult).collect(Collectors.toList());
    }

    public MetadataVectorCassandraTable getEmbeddingTable() {
        return this.embeddingTable;
    }
}

