/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.bedrock.BedrockCachePointPlacement;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import java.util.HashMap;
import java.util.Map;

public class BedrockChatRequestParameters
extends DefaultChatRequestParameters {
    public static final BedrockChatRequestParameters EMPTY = BedrockChatRequestParameters.builder().build();
    private final Map<String, Object> additionalModelRequestFields;
    private final BedrockCachePointPlacement cachePointPlacement;

    private BedrockChatRequestParameters(Builder builder) {
        super((DefaultChatRequestParameters.Builder)builder);
        this.additionalModelRequestFields = Utils.copy(builder.additionalModelRequestFields);
        this.cachePointPlacement = builder.cachePointPlacement;
    }

    public BedrockChatRequestParameters overrideWith(ChatRequestParameters that) {
        return BedrockChatRequestParameters.builder().overrideWith((ChatRequestParameters)this).overrideWith(that).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public BedrockCachePointPlacement cachePointPlacement() {
        return this.cachePointPlacement;
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private Map<String, Object> additionalModelRequestFields;
        private BedrockCachePointPlacement cachePointPlacement;

        public Builder overrideWith(ChatRequestParameters parameters) {
            super.overrideWith(parameters);
            if (parameters instanceof BedrockChatRequestParameters) {
                BedrockChatRequestParameters bedrockRequestParameters = (BedrockChatRequestParameters)parameters;
                this.additionalModelRequestFields(Utils.getOrDefault(bedrockRequestParameters.additionalModelRequestFields, this.additionalModelRequestFields));
                this.cachePointPlacement = (BedrockCachePointPlacement)((Object)Utils.getOrDefault((Object)((Object)bedrockRequestParameters.cachePointPlacement), (Object)((Object)this.cachePointPlacement)));
            }
            return this;
        }

        public Builder additionalModelRequestFields(Map<String, Object> additionalModelRequestFields) {
            this.additionalModelRequestFields = additionalModelRequestFields;
            return this;
        }

        public Builder additionalModelRequestField(String key, Object value) {
            if (this.additionalModelRequestFields == null) {
                this.additionalModelRequestFields = new HashMap<String, Object>();
            }
            this.additionalModelRequestFields.put(key, value);
            return this;
        }

        public Builder enableReasoning(Integer tokenBudget) {
            if (tokenBudget != null) {
                if (this.additionalModelRequestFields == null) {
                    this.additionalModelRequestFields = new HashMap<String, Object>();
                }
                Map reasoningConfig = Map.ofEntries(Map.entry("type", "enabled"), Map.entry("budget_tokens", tokenBudget));
                this.additionalModelRequestFields.put("reasoning_config", reasoningConfig);
            }
            return this;
        }

        public Builder promptCaching(BedrockCachePointPlacement placement) {
            this.cachePointPlacement = placement;
            return this;
        }

        public BedrockChatRequestParameters build() {
            return new BedrockChatRequestParameters(this);
        }
    }
}

