/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.bedrock.BedrockMistralAiChatModelResponse;
import dev.langchain4j.model.bedrock.internal.AbstractBedrockChatModel;
import dev.langchain4j.model.bedrock.internal.Json;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.Response;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

@Deprecated(forRemoval=true, since="1.0.0-beta2")
public class BedrockMistralAiChatModel
extends AbstractBedrockChatModel<BedrockMistralAiChatModelResponse> {
    private static final Logger log = LoggerFactory.getLogger(BedrockMistralAiChatModel.class);
    private static final int DEFAULT_TOP_K = 200;
    private static final String DEFAULT_MODEL = Types.Mistral7bInstructV0_2.getValue();
    private final int topK;
    private final String model;

    @Override
    protected String getModelId() {
        return this.model;
    }

    @Override
    protected Map<String, Object> getRequestParameters(String prompt) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(7);
        parameters.put("prompt", prompt);
        parameters.put("max_tokens", this.getMaxTokens());
        parameters.put("temperature", this.getTemperature());
        parameters.put("top_p", Float.valueOf(this.getTopP()));
        parameters.put("top_k", this.topK);
        parameters.put("stop", this.getStopSequences());
        return parameters;
    }

    @Override
    protected Response<AiMessage> generate(List<ChatMessage> messages) {
        String prompt = this.buildPrompt(messages);
        Map<String, Object> requestParameters = this.getRequestParameters(prompt);
        String body = Json.toJson(requestParameters);
        InvokeModelRequest invokeModelRequest = (InvokeModelRequest)InvokeModelRequest.builder().modelId(this.getModelId()).body(SdkBytes.fromString((String)body, (Charset)Charset.defaultCharset())).build();
        ChatRequest listenerRequest = this.createListenerRequest(invokeModelRequest, messages, Collections.emptyList());
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(listenerRequest, this.provider(), attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        InvokeModelResponse invokeModelResponse = (InvokeModelResponse)RetryUtils.withRetryMappingExceptions(() -> this.getClient().invokeModel(invokeModelRequest), (int)this.getMaxRetries());
        String response = invokeModelResponse.body().asUtf8String().trim();
        BedrockMistralAiChatModelResponse result = Json.fromJson(response, this.getResponseClassType());
        try {
            Response<AiMessage> responseMessage = this.toAiMessage(result);
            ChatResponse listenerResponse = this.createListenerResponse(null, null, responseMessage);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(listenerResponse, listenerRequest, this.provider(), attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    log.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            return responseMessage;
        }
        catch (RuntimeException e) {
            this.listenerErrorResponse(e, listenerRequest, this.provider(), attributes);
            throw e;
        }
    }

    private String buildPrompt(List<ChatMessage> messages) {
        StringBuilder promptBuilder = new StringBuilder();
        promptBuilder.append("<s>");
        for (ChatMessage message : messages) {
            if (message instanceof UserMessage) {
                UserMessage userMessage = (UserMessage)message;
                promptBuilder.append("[INST] ").append(userMessage.singleText()).append(" [/INST]");
                continue;
            }
            if (message instanceof AiMessage) {
                AiMessage aiMessage = (AiMessage)message;
                promptBuilder.append(" ").append(aiMessage.text()).append(" ");
                continue;
            }
            throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(message.type()));
        }
        promptBuilder.append("</s>");
        return promptBuilder.toString();
    }

    @Override
    public Class<BedrockMistralAiChatModelResponse> getResponseClassType() {
        return BedrockMistralAiChatModelResponse.class;
    }

    @Override
    public int getTopK() {
        return this.topK;
    }

    public String getModel() {
        return this.model;
    }

    protected BedrockMistralAiChatModel(BedrockMistralAiChatModelBuilder<?, ?> builder) {
        super(builder);
        this.topK = builder.isTopKSet ? builder.topK : 200;
        this.model = builder.isModelSet ? builder.model : DEFAULT_MODEL;
    }

    public static BedrockMistralAiChatModelBuilder<?, ?> builder() {
        return new BedrockMistralAiChatModelBuilderImpl();
    }

    public static abstract class BedrockMistralAiChatModelBuilder<C extends BedrockMistralAiChatModel, B extends BedrockMistralAiChatModelBuilder<C, B>>
    extends AbstractBedrockChatModel.AbstractBedrockChatModelBuilder<BedrockMistralAiChatModelResponse, C, B> {
        private boolean isTopKSet;
        private int topK;
        private boolean isModelSet;
        private String model;

        @Override
        public B topK(int topK) {
            this.topK = topK;
            this.isTopKSet = true;
            return (B)this.self();
        }

        public B model(String model) {
            this.model = model;
            this.isModelSet = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BedrockMistralAiChatModel.BedrockMistralAiChatModelBuilder(super=" + super.toString() + ", topK$value=" + this.topK + ", model$value=" + this.model + ")";
        }
    }

    private static final class BedrockMistralAiChatModelBuilderImpl
    extends BedrockMistralAiChatModelBuilder<BedrockMistralAiChatModel, BedrockMistralAiChatModelBuilderImpl> {
        private BedrockMistralAiChatModelBuilderImpl() {
        }

        @Override
        protected BedrockMistralAiChatModelBuilderImpl self() {
            return this;
        }

        @Override
        public BedrockMistralAiChatModel build() {
            return new BedrockMistralAiChatModel(this);
        }
    }

    public static enum Types {
        Mistral7bInstructV0_2("mistral.mistral-7b-instruct-v0:2"),
        MistralMixtral8x7bInstructV0_1("mistral.mixtral-8x7b-instruct-v0:1");

        private final String value;

        private Types(String modelID) {
            this.value = modelID;
        }

        public String getValue() {
            return this.value;
        }
    }
}

