/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.exception.UnsupportedFeatureException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import software.amazon.awssdk.services.bedrockruntime.model.ImageFormat;

class Utils {
    private static final Map<String, ImageFormat> MIME_TYPE_MAPPING = Map.of("image/png", ImageFormat.PNG, "image/jpeg", ImageFormat.JPEG, "image/jpg", ImageFormat.JPEG, "image/gif", ImageFormat.GIF, "image/webp", ImageFormat.WEBP);
    private static final Map<String, ImageFormat> EXTENSION_MAPPING = Map.of("png", ImageFormat.PNG, "jpg", ImageFormat.JPEG, "jpeg", ImageFormat.JPEG, "gif", ImageFormat.GIF, "webp", ImageFormat.WEBP);
    private static final Set<ImageFormat> SUPPORTED_FORMATS = Set.of(ImageFormat.PNG, ImageFormat.JPEG, ImageFormat.GIF, ImageFormat.WEBP);

    Utils() {
    }

    public static String extractExtension(URI uri) {
        int lastDot;
        String path = uri.getPath();
        if (Objects.isNull(path) || path.isEmpty()) {
            return "";
        }
        String cleanPath = path.split("\\?")[0];
        String fileName = cleanPath = cleanPath.split("#")[0];
        int lastSlash = Math.max(cleanPath.lastIndexOf(47), cleanPath.lastIndexOf(92));
        if (lastSlash >= 0) {
            fileName = cleanPath.substring(lastSlash + 1);
        }
        if ((lastDot = fileName.lastIndexOf(46)) > 0) {
            return fileName.substring(lastDot + 1);
        }
        return "";
    }

    public static String extractAndValidateFormat(Image image) {
        String extension;
        ImageFormat format;
        ImageFormat format2;
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null");
        }
        if (image.mimeType() != null && !image.mimeType().isBlank() && (format2 = MIME_TYPE_MAPPING.get(image.mimeType().toLowerCase())) != null) {
            return format2.toString();
        }
        if (image.url() != null && (format = EXTENSION_MAPPING.get(extension = Utils.extractExtension(image.url()).toLowerCase())) != null) {
            return format.toString();
        }
        throw new UnsupportedFeatureException(String.format("Unsupported image format, should be one of png | jpeg | gif | webp. Mime type: %s, URI: %s", image.mimeType(), image.url()));
    }

    public static String extractCleanFileName(URI uri) {
        String fileName;
        if (uri == null) {
            return "";
        }
        String path = uri.getPath();
        if (Objects.isNull(path) || path.isEmpty()) {
            return "";
        }
        String cleanPath = path.split("\\?")[0];
        int lastSlash = Math.max((cleanPath = cleanPath.split("#")[0]).lastIndexOf(47), cleanPath.lastIndexOf(92));
        String string = fileName = lastSlash >= 0 ? cleanPath.substring(lastSlash + 1) : cleanPath;
        if (fileName.isEmpty() || fileName.matches("^[.]+$")) {
            return "";
        }
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot > 0) {
            fileName = fileName.substring(0, lastDot);
        }
        return fileName.replaceAll("[^a-zA-Z0-9\\s\\-()\\[\\]]", "-").replaceAll("\\s+", "-").trim();
    }
}

