/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.bedrock.AbstractBedrockChatModel;
import dev.langchain4j.model.bedrock.AwsLoggingInterceptor;
import dev.langchain4j.model.bedrock.BedrockChatRequestParameters;
import dev.langchain4j.model.bedrock.ConverseResponseFromStreamBuilder;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetadataEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;

public class BedrockStreamingChatModel
extends AbstractBedrockChatModel
implements StreamingChatModel {
    private static final Logger log = LoggerFactory.getLogger(BedrockStreamingChatModel.class);
    private final BedrockRuntimeAsyncClient client;

    public BedrockStreamingChatModel(String modelId) {
        this((Builder)BedrockStreamingChatModel.builder().modelId(modelId));
    }

    private BedrockStreamingChatModel(Builder builder) {
        super(builder);
        this.client = Objects.isNull(builder.client) ? this.createClient((Boolean)Utils.getOrDefault((Object)builder.logRequests, (Object)false), (Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false)) : builder.client;
    }

    public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
        ConverseStreamRequest converseStreamRequest = this.buildConverseStreamRequest(chatRequest.messages(), chatRequest.parameters().toolSpecifications(), chatRequest.parameters());
        ConverseResponseFromStreamBuilder converseResponseBuilder = ConverseResponseFromStreamBuilder.builder();
        ConverseStreamResponseHandler built = ((ConverseStreamResponseHandler.Builder)ConverseStreamResponseHandler.builder().subscriber(ConverseStreamResponseHandler.Visitor.builder().onContentBlockStart(converseResponseBuilder::append).onContentBlockDelta(chunk -> {
            if (chunk.delta().type().equals((Object)ContentBlockDelta.Type.TEXT)) {
                handler.onPartialResponse(chunk.delta().text());
            }
            converseResponseBuilder.append((ContentBlockDeltaEvent)chunk);
        }).onContentBlockStop(converseResponseBuilder::append).onMetadata(chunk -> {
            converseResponseBuilder.append((ConverseStreamMetadataEvent)chunk);
            ChatResponse completeResponse = this.chatResponseFrom(converseResponseBuilder.build(), converseStreamRequest.modelId());
            handler.onCompleteResponse(completeResponse);
        }).onMessageStart(converseResponseBuilder::append).onMessageStop(converseResponseBuilder::append).build()).onError(arg_0 -> ((StreamingChatResponseHandler)handler).onError(arg_0))).build();
        try {
            this.client.converseStream(converseStreamRequest, built).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Can't invoke '{}': {}", (Object)this.modelId, (Object)e.getCause().getMessage());
        }
    }

    public BedrockChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    private ConverseStreamRequest buildConverseStreamRequest(List<ChatMessage> messages, List<ToolSpecification> toolSpecs, ChatRequestParameters parameters) {
        String model;
        String string = model = Objects.isNull(parameters) || Objects.isNull(parameters.modelName()) ? this.modelId : parameters.modelName();
        if (Objects.nonNull(parameters)) {
            BedrockStreamingChatModel.validate(parameters);
        }
        return (ConverseStreamRequest)ConverseStreamRequest.builder().modelId(model).inferenceConfig(this.inferenceConfigurationFrom(parameters)).system(this.extractSystemMessages(messages)).messages(this.extractRegularMessages(messages)).toolConfig(this.extractToolConfigurationFrom(toolSpecs, parameters)).additionalModelRequestFields(this.additionalRequestModelFieldsFrom(parameters)).build();
    }

    private ChatResponse chatResponseFrom(ConverseResponse converseResponse, String modelId) {
        return ChatResponse.builder().aiMessage(this.aiMessageFrom(converseResponse)).metadata(ChatResponseMetadata.builder().id(UUID.randomUUID().toString()).finishReason(this.finishReasonFrom(converseResponse.stopReason())).tokenUsage(this.tokenUsageFrom(converseResponse.usage())).modelName(modelId).build()).build();
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.AMAZON_BEDROCK;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BedrockRuntimeAsyncClient createClient(boolean logRequests, boolean logResponses) {
        return (BedrockRuntimeAsyncClient)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)BedrockRuntimeAsyncClient.builder().region(this.region)).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).overrideConfiguration(config -> {
            config.apiCallTimeout(this.timeout);
            if (logRequests || logResponses) {
                config.addExecutionInterceptor((ExecutionInterceptor)new AwsLoggingInterceptor(logRequests, logResponses));
            }
        })).build();
    }

    public static class Builder
    extends AbstractBedrockChatModel.AbstractBuilder<Builder> {
        private BedrockRuntimeAsyncClient client;

        public Builder client(BedrockRuntimeAsyncClient client) {
            this.client = client;
            return this;
        }

        public BedrockStreamingChatModel build() {
            return new BedrockStreamingChatModel(this);
        }
    }
}

