/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.bedrock.BedrockAnthropicContent;
import dev.langchain4j.model.bedrock.BedrockAnthropicImageSource;
import dev.langchain4j.model.bedrock.BedrockAnthropicMessage;
import dev.langchain4j.model.bedrock.BedrockAnthropicMessageChatModelResponse;
import dev.langchain4j.model.bedrock.BedrockAntropicToolSpecification;
import dev.langchain4j.model.bedrock.internal.AbstractBedrockChatModel;
import dev.langchain4j.model.bedrock.internal.Json;
import dev.langchain4j.model.bedrock.internal.sanitizer.BedrockAnthropicMessageSanitizer;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ChatRequestValidator;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonSchemaElementHelper;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

@Deprecated(forRemoval=true, since="1.0.0-beta2")
public class BedrockAnthropicMessageChatModel
extends AbstractBedrockChatModel<BedrockAnthropicMessageChatModelResponse> {
    private static final Logger log = LoggerFactory.getLogger(BedrockAnthropicMessageChatModel.class);
    private static final String DEFAULT_ANTHROPIC_VERSION = "bedrock-2023-05-31";
    private final int topK;
    private final String anthropicVersion;
    private final String model;
    private final ObjectMapper objectMapper;

    @Override
    protected String getModelId() {
        return this.model;
    }

    @Override
    protected Map<String, Object> getRequestParameters(String prompt) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(9);
        parameters.put("max_tokens", this.getMaxTokens());
        parameters.put("temperature", this.getTemperature());
        parameters.put("top_k", this.topK);
        parameters.put("top_p", Float.valueOf(this.getTopP()));
        parameters.put("stop_sequences", this.getStopSequences());
        parameters.put("anthropic_version", this.anthropicVersion);
        return parameters;
    }

    @Override
    public ChatResponse chat(ChatRequest chatRequest) {
        Response<AiMessage> response;
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatRequestValidator.validateParameters((ChatRequestParameters)parameters);
        ChatRequestValidator.validate((ResponseFormat)parameters.responseFormat());
        List toolSpecifications = parameters.toolSpecifications();
        if (Utils.isNullOrEmpty((Collection)toolSpecifications)) {
            response = this.generate(chatRequest.messages());
        } else if (parameters.toolChoice() == ToolChoice.REQUIRED) {
            if (toolSpecifications.size() != 1) {
                throw new UnsupportedFeatureException(String.format("%s.%s is currently supported only when there is a single tool", ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
            }
            response = this.generate((List<ChatMessage>)chatRequest.messages(), (ToolSpecification)toolSpecifications.get(0));
        } else {
            response = this.generate((List<ChatMessage>)chatRequest.messages(), toolSpecifications);
        }
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
    }

    @Override
    protected Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, Collections.emptyList());
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        return this.generate(messages, toolSpecification, Collections.singletonList(toolSpecification));
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return this.generate(messages, null, toolSpecifications);
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolChoiceSpecification, List<ToolSpecification> toolSpecifications) {
        List<ChatMessage> sanitizedMessages = BedrockAnthropicMessageSanitizer.sanitizeMessages(messages);
        String system = this.getAnthropicSystemPrompt(messages);
        List<BedrockAnthropicMessage> formattedMessages = this.getAnthropicMessages(sanitizedMessages);
        Map<String, Object> parameters = this.getRequestParameters(null);
        parameters.put("messages", formattedMessages);
        parameters.put("system", system);
        if (Objects.nonNull(toolChoiceSpecification)) {
            BedrockAnthropicMessageChatModel.validateModelIdWithToolsSupport(this.model);
            parameters.put("tool_choice", this.toAnthropicToolChoice(toolChoiceSpecification));
        }
        if (!toolSpecifications.isEmpty()) {
            BedrockAnthropicMessageChatModel.validateModelIdWithToolsSupport(this.model);
            parameters.put("tools", this.toAnthropicToolSpecifications(toolSpecifications));
        }
        String body = Json.toJson(parameters);
        InvokeModelRequest invokeModelRequest = (InvokeModelRequest)InvokeModelRequest.builder().modelId(this.getModelId()).body(SdkBytes.fromString((String)body, (Charset)Charset.defaultCharset())).build();
        ChatRequest listenerRequest = this.createListenerRequest(invokeModelRequest, sanitizedMessages, toolSpecifications);
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(listenerRequest, this.provider(), attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        try {
            InvokeModelResponse invokeModelResponse = (InvokeModelResponse)RetryUtils.withRetryMappingExceptions(() -> this.getClient().invokeModel(invokeModelRequest), (int)this.getMaxRetries());
            String response = invokeModelResponse.body().asUtf8String();
            BedrockAnthropicMessageChatModelResponse result = Json.fromJson(response, this.getResponseClassType());
            Response responseMessage = Response.from((Object)this.aiMessageFrom(result), (TokenUsage)result.getTokenUsage(), (FinishReason)result.getFinishReason());
            ChatResponse listenerResponse = this.createListenerResponse(result.getId(), result.getModel(), (Response<AiMessage>)responseMessage);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(listenerResponse, listenerRequest, this.provider(), attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    log.warn("Exception while calling model listener", (Throwable)e);
                }
            });
            return responseMessage;
        }
        catch (RuntimeException e) {
            this.listenerErrorResponse(e, listenerRequest, this.provider(), attributes);
            throw e;
        }
    }

    private Object toAnthropicToolChoice(ToolSpecification toolChoiceSpecification) {
        ObjectNode toolChoiceNode = new ObjectMapper().createObjectNode();
        toolChoiceNode.put("type", "tool");
        toolChoiceNode.put("name", toolChoiceSpecification.name());
        return toolChoiceNode;
    }

    static void validateModelIdWithToolsSupport(String modelId) {
        if (Objects.isNull(modelId)) {
            throw new IllegalArgumentException("Model ID is required");
        }
        List<String> anthropicModelIdSplit = Arrays.asList(modelId.split("-"));
        if (anthropicModelIdSplit.size() < 2) {
            throw new IllegalArgumentException("Tools are currently not supported by this model");
        }
        String anthropicModelMajorVersion = anthropicModelIdSplit.get(1);
        if (anthropicModelMajorVersion.contains(":")) {
            anthropicModelMajorVersion = anthropicModelMajorVersion.split(":")[0];
        }
        if (!anthropicModelMajorVersion.matches("[0-9]")) {
            anthropicModelMajorVersion = anthropicModelMajorVersion.replaceAll("[^0-9]", "");
        }
        if (anthropicModelMajorVersion.isEmpty() || Integer.parseInt(anthropicModelMajorVersion) < 3) {
            throw new IllegalArgumentException("Tools are currently not supported by this model");
        }
    }

    private AiMessage aiMessageFrom(BedrockAnthropicMessageChatModelResponse result) {
        List toolUseRequests = result.getContent().stream().filter(content -> content.getType().equals("tool_use")).collect(Collectors.toList());
        if (toolUseRequests.isEmpty()) {
            return AiMessage.from((String)result.getOutputText());
        }
        List toolExecutionRequests = toolUseRequests.stream().map(toolUseRequest -> ToolExecutionRequest.builder().id(toolUseRequest.getId()).name(toolUseRequest.getName()).arguments(this.toJson(toolUseRequest.getInput())).build()).collect(Collectors.toList());
        return AiMessage.from(toolExecutionRequests);
    }

    private String toJson(Object input) {
        try {
            return this.objectMapper.writeValueAsString(input);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private Object toAnthropicToolSpecifications(List<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(toolSpecification -> BedrockAntropicToolSpecification.builder().name(toolSpecification.name()).description(toolSpecification.description()).input_schema(this.toAnthropicToolParameters((ToolSpecification)toolSpecification)).build()).collect(Collectors.toList());
    }

    private Object toAnthropicToolParameters(ToolSpecification toolSpecification) {
        if (toolSpecification.parameters() != null) {
            return JsonSchemaElementHelper.toMap((JsonSchemaElement)toolSpecification.parameters());
        }
        ObjectNode inputSchemaNode = new ObjectMapper().createObjectNode();
        inputSchemaNode.put("type", "object");
        inputSchemaNode.set("properties", (JsonNode)new ObjectMapper().createObjectNode());
        inputSchemaNode.set("required", (JsonNode)new ObjectMapper().createArrayNode());
        return inputSchemaNode;
    }

    private ObjectNode toAnthropicParameterProperties(Map<String, Map<String, Object>> properties) {
        ObjectNode propertiesNode = new ObjectMapper().createObjectNode();
        properties.forEach((propertyName, propertyMetadata) -> propertiesNode.set(propertyName, this.toAnthropicParameter((Map<String, Object>)propertyMetadata)));
        return propertiesNode;
    }

    private JsonNode toAnthropicParameter(Map<String, Object> propertyMetadata) {
        ObjectNode propertyNode = new ObjectMapper().createObjectNode();
        String propertyType = propertyMetadata.get("type").toString();
        String propertyDescription = (String)propertyMetadata.get("description");
        if (propertyDescription != null) {
            propertyNode.put("description", propertyDescription);
        }
        propertyNode.put("type", propertyType);
        if ("object".equals(propertyType)) {
            ObjectNode childPropertiesNode = new ObjectMapper().createObjectNode();
            childPropertiesNode.setAll(this.toAnthropicParameterProperties((Map)propertyMetadata.get("properties")));
            propertyNode.set("properties", (JsonNode)childPropertiesNode);
            if (Objects.nonNull(propertyMetadata.get("required"))) {
                ArrayNode requiredNode = new ObjectMapper().createArrayNode();
                ((List)propertyMetadata.get("required")).forEach(arg_0 -> ((ArrayNode)requiredNode).add(arg_0));
                propertyNode.set("required", (JsonNode)requiredNode);
            }
        }
        if ("array".equals(propertyType)) {
            propertyNode.set("items", this.toAnthropicParameter((Map)propertyMetadata.get("items")));
        }
        if (propertyMetadata.get("enum") != null) {
            ArrayNode enumValues = new ObjectMapper().createArrayNode();
            ((List)propertyMetadata.get("enum")).forEach(arg_0 -> ((ArrayNode)enumValues).add(arg_0));
            propertyNode.set("enum", (JsonNode)enumValues);
        }
        return propertyNode;
    }

    private List<BedrockAnthropicMessage> getAnthropicMessages(List<ChatMessage> messages) {
        List noSystemMessages = messages.stream().filter(message -> message.type() != ChatMessageType.SYSTEM).collect(Collectors.toList());
        ArrayList<BedrockAnthropicMessage> anthropicMessages = new ArrayList<BedrockAnthropicMessage>();
        ArrayList<BedrockAnthropicContent> toolContents = new ArrayList<BedrockAnthropicContent>();
        for (ChatMessage message2 : noSystemMessages) {
            List<BedrockAnthropicContent> contents = this.getAnthropicContent(message2);
            if (message2 instanceof ToolExecutionResultMessage) {
                toolContents.addAll(this.getAnthropicContent(message2));
                continue;
            }
            if (!toolContents.isEmpty()) {
                anthropicMessages.add(new BedrockAnthropicMessage("user", toolContents));
                toolContents = new ArrayList();
            }
            if (message2 instanceof UserMessage) {
                anthropicMessages.add(new BedrockAnthropicMessage("user", contents));
            }
            if (!(message2 instanceof AiMessage)) continue;
            anthropicMessages.add(new BedrockAnthropicMessage("assistant", contents));
        }
        if (!toolContents.isEmpty()) {
            anthropicMessages.add(new BedrockAnthropicMessage("user", toolContents));
        }
        return anthropicMessages;
    }

    private List<BedrockAnthropicContent> getAnthropicContent(ChatMessage message) {
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            ArrayList<BedrockAnthropicContent> contents = new ArrayList<BedrockAnthropicContent>();
            if (Utils.isNotNullOrBlank((String)aiMessage.text())) {
                contents.add(new BedrockAnthropicContent("text", aiMessage.text()));
            }
            if (aiMessage.hasToolExecutionRequests()) {
                List toolUseRequests = aiMessage.toolExecutionRequests().stream().map(toolExecutionRequest -> BedrockAnthropicContent.builder().id(toolExecutionRequest.id()).type("tool_use").name(toolExecutionRequest.name()).input(this.fromJson(toolExecutionRequest.arguments(), Map.class)).build()).collect(Collectors.toList());
                contents.addAll(toolUseRequests);
            }
            return contents;
        }
        if (message instanceof UserMessage) {
            return ((UserMessage)message).contents().stream().map(BedrockAnthropicMessageChatModel::mapContentToAnthropic).collect(Collectors.toList());
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)message;
            return Collections.singletonList(BedrockAnthropicContent.builder().type("tool_result").tool_use_id(toolExecutionResultMessage.id()).content(toolExecutionResultMessage.text()).build());
        }
        throw new IllegalArgumentException("Unknown message type: " + String.valueOf(message.type()));
    }

    private <T> T fromJson(String json, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static BedrockAnthropicContent mapContentToAnthropic(Content content) {
        if (content instanceof TextContent) {
            return new BedrockAnthropicContent("text", ((TextContent)content).text());
        }
        if (content instanceof ImageContent) {
            ImageContent imageContent = (ImageContent)content;
            if (imageContent.image().url() != null) {
                throw new UnsupportedFeatureException("Anthropic does not support images as URLs, only as Base64-encoded strings");
            }
            BedrockAnthropicImageSource imageSource = new BedrockAnthropicImageSource("base64", ValidationUtils.ensureNotBlank((String)imageContent.image().mimeType(), (String)"mimeType"), ValidationUtils.ensureNotBlank((String)imageContent.image().base64Data(), (String)"base64Data"));
            return new BedrockAnthropicContent("image", imageSource);
        }
        throw new IllegalArgumentException("Unknown content type: " + String.valueOf(content));
    }

    private String getAnthropicSystemPrompt(List<ChatMessage> messages) {
        return messages.stream().filter(message -> message.type() == ChatMessageType.SYSTEM).map(message -> ((SystemMessage)message).text()).collect(Collectors.joining("\n"));
    }

    private String getAnthropicRole(ChatMessage message) {
        return message.type() == ChatMessageType.AI ? "assistant" : "user";
    }

    @Override
    public Class<BedrockAnthropicMessageChatModelResponse> getResponseClassType() {
        return BedrockAnthropicMessageChatModelResponse.class;
    }

    @Generated
    private static int $default$topK() {
        return 250;
    }

    @Generated
    private static String $default$anthropicVersion() {
        return DEFAULT_ANTHROPIC_VERSION;
    }

    @Generated
    private static String $default$model() {
        return Types.AnthropicClaude3SonnetV1.getValue();
    }

    @Generated
    private static ObjectMapper $default$objectMapper() {
        return new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Generated
    protected BedrockAnthropicMessageChatModel(BedrockAnthropicMessageChatModelBuilder<?, ?> b) {
        super(b);
        this.topK = b.topK$set ? b.topK$value : BedrockAnthropicMessageChatModel.$default$topK();
        this.anthropicVersion = b.anthropicVersion$set ? b.anthropicVersion$value : BedrockAnthropicMessageChatModel.$default$anthropicVersion();
        this.model = b.model$set ? b.model$value : BedrockAnthropicMessageChatModel.$default$model();
        this.objectMapper = b.objectMapper$set ? b.objectMapper$value : BedrockAnthropicMessageChatModel.$default$objectMapper();
    }

    @Generated
    public static BedrockAnthropicMessageChatModelBuilder<?, ?> builder() {
        return new BedrockAnthropicMessageChatModelBuilderImpl();
    }

    @Override
    @Generated
    public int getTopK() {
        return this.topK;
    }

    @Override
    @Generated
    public String getAnthropicVersion() {
        return this.anthropicVersion;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static enum Types {
        AnthropicClaudeInstantV1("anthropic.claude-instant-v1"),
        AnthropicClaudeV2("anthropic.claude-v2"),
        AnthropicClaudeV2_1("anthropic.claude-v2:1"),
        AnthropicClaude3SonnetV1("anthropic.claude-3-sonnet-20240229-v1:0"),
        AnthropicClaude3_5SonnetV1("anthropic.claude-3-5-sonnet-20240620-v1:0"),
        AnthropicClaude3HaikuV1("anthropic.claude-3-haiku-20240307-v1:0");

        private final String value;

        private Types(String modelID) {
            this.value = modelID;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }

    @Generated
    public static abstract class BedrockAnthropicMessageChatModelBuilder<C extends BedrockAnthropicMessageChatModel, B extends BedrockAnthropicMessageChatModelBuilder<C, B>>
    extends AbstractBedrockChatModel.AbstractBedrockChatModelBuilder<BedrockAnthropicMessageChatModelResponse, C, B> {
        @Generated
        private boolean topK$set;
        @Generated
        private int topK$value;
        @Generated
        private boolean anthropicVersion$set;
        @Generated
        private String anthropicVersion$value;
        @Generated
        private boolean model$set;
        @Generated
        private String model$value;
        @Generated
        private boolean objectMapper$set;
        @Generated
        private ObjectMapper objectMapper$value;

        @Override
        @Generated
        public B topK(int topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public B anthropicVersion(String anthropicVersion) {
            this.anthropicVersion$value = anthropicVersion;
            this.anthropicVersion$set = true;
            return (B)this.self();
        }

        @Generated
        public B model(String model) {
            this.model$value = model;
            this.model$set = true;
            return (B)this.self();
        }

        @Generated
        public B objectMapper(ObjectMapper objectMapper) {
            this.objectMapper$value = objectMapper;
            this.objectMapper$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "BedrockAnthropicMessageChatModel.BedrockAnthropicMessageChatModelBuilder(super=" + super.toString() + ", topK$value=" + this.topK$value + ", anthropicVersion$value=" + this.anthropicVersion$value + ", model$value=" + this.model$value + ", objectMapper$value=" + String.valueOf(this.objectMapper$value) + ")";
        }
    }

    @Generated
    private static final class BedrockAnthropicMessageChatModelBuilderImpl
    extends BedrockAnthropicMessageChatModelBuilder<BedrockAnthropicMessageChatModel, BedrockAnthropicMessageChatModelBuilderImpl> {
        @Generated
        private BedrockAnthropicMessageChatModelBuilderImpl() {
        }

        @Override
        @Generated
        protected BedrockAnthropicMessageChatModelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BedrockAnthropicMessageChatModel build() {
            return new BedrockAnthropicMessageChatModel(this);
        }
    }
}

