/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock.internal;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.bedrock.internal.BedrockEmbeddingResponse;
import dev.langchain4j.model.bedrock.internal.Json;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public abstract class AbstractBedrockEmbeddingModel<T extends BedrockEmbeddingResponse>
implements EmbeddingModel {
    private volatile BedrockRuntimeClient client;
    private final Region region;
    private final AwsCredentialsProvider credentialsProvider;
    private final Integer maxRetries;

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<Map<String, Object>> requestParameters = this.getRequestParameters(textSegments);
        List responses = requestParameters.stream().map(Json::toJson).map(body -> (InvokeModelResponse)RetryUtils.withRetry(() -> this.invoke((String)body), (int)this.maxRetries)).map(invokeModelResponse -> invokeModelResponse.body().asUtf8String()).map(response -> (BedrockEmbeddingResponse)Json.fromJson(response, this.getResponseClassType())).collect(Collectors.toList());
        int totalInputToken = 0;
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        for (BedrockEmbeddingResponse response2 : responses) {
            embeddings.add(response2.toEmbedding());
            totalInputToken += response2.getInputTextTokenCount();
        }
        return Response.from(embeddings, (TokenUsage)new TokenUsage(Integer.valueOf(totalInputToken)));
    }

    protected abstract List<Map<String, Object>> getRequestParameters(List<TextSegment> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BedrockRuntimeClient getClient() {
        if (this.client == null) {
            AbstractBedrockEmbeddingModel abstractBedrockEmbeddingModel = this;
            synchronized (abstractBedrockEmbeddingModel) {
                if (this.client == null) {
                    this.client = this.initClient();
                }
            }
        }
        return this.client;
    }

    protected abstract String getModelId();

    protected abstract Class<T> getResponseClassType();

    protected InvokeModelResponse invoke(String body) {
        InvokeModelRequest invokeModelRequest = (InvokeModelRequest)InvokeModelRequest.builder().modelId(this.getModelId()).body(SdkBytes.fromString((String)body, (Charset)Charset.defaultCharset())).build();
        return this.getClient().invokeModel(invokeModelRequest);
    }

    protected static Map<String, Object> of(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(key, value);
        return map;
    }

    private BedrockRuntimeClient initClient() {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(this.region)).credentialsProvider(this.credentialsProvider)).build();
    }

    @Generated
    private static <T extends BedrockEmbeddingResponse> Region $default$region() {
        return Region.US_EAST_1;
    }

    @Generated
    private static <T extends BedrockEmbeddingResponse> AwsCredentialsProvider $default$credentialsProvider() {
        return DefaultCredentialsProvider.builder().build();
    }

    @Generated
    private static <T extends BedrockEmbeddingResponse> Integer $default$maxRetries() {
        return 5;
    }

    @Generated
    protected AbstractBedrockEmbeddingModel(AbstractBedrockEmbeddingModelBuilder<T, ?, ?> b) {
        this.client = b.client;
        this.region = b.region$set ? b.region$value : AbstractBedrockEmbeddingModel.$default$region();
        this.credentialsProvider = b.credentialsProvider$set ? b.credentialsProvider$value : AbstractBedrockEmbeddingModel.$default$credentialsProvider();
        this.maxRetries = b.maxRetries$set ? b.maxRetries$value : AbstractBedrockEmbeddingModel.$default$maxRetries();
    }

    @Generated
    public Region getRegion() {
        return this.region;
    }

    @Generated
    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Generated
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Generated
    public static abstract class AbstractBedrockEmbeddingModelBuilder<T extends BedrockEmbeddingResponse, C extends AbstractBedrockEmbeddingModel<T>, B extends AbstractBedrockEmbeddingModelBuilder<T, C, B>> {
        @Generated
        private BedrockRuntimeClient client;
        @Generated
        private boolean region$set;
        @Generated
        private Region region$value;
        @Generated
        private boolean credentialsProvider$set;
        @Generated
        private AwsCredentialsProvider credentialsProvider$value;
        @Generated
        private boolean maxRetries$set;
        @Generated
        private Integer maxRetries$value;

        @Generated
        public B client(BedrockRuntimeClient client) {
            this.client = client;
            return this.self();
        }

        @Generated
        public B region(Region region) {
            this.region$value = region;
            this.region$set = true;
            return this.self();
        }

        @Generated
        public B credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider$value = credentialsProvider;
            this.credentialsProvider$set = true;
            return this.self();
        }

        @Generated
        public B maxRetries(Integer maxRetries) {
            this.maxRetries$value = maxRetries;
            this.maxRetries$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractBedrockEmbeddingModel.AbstractBedrockEmbeddingModelBuilder(client=" + String.valueOf(this.client) + ", region$value=" + String.valueOf(this.region$value) + ", credentialsProvider$value=" + String.valueOf(this.credentialsProvider$value) + ", maxRetries$value=" + this.maxRetries$value + ")";
        }
    }
}

