/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.bedrock.BedrockTitanEmbeddingResponse;
import dev.langchain4j.model.bedrock.internal.AbstractBedrockEmbeddingModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BedrockTitanEmbeddingModel
extends AbstractBedrockEmbeddingModel<BedrockTitanEmbeddingResponse> {
    private static final String MODEL_V1_ID = "amazon.titan-embed-text-v1";
    private static final String MODEL_V2_ID = "amazon.titan-embed-text-v2:0";
    private final String model;
    private final Integer dimensions;
    private final Boolean normalize;

    @Override
    protected String getModelId() {
        return this.model;
    }

    @Override
    protected List<Map<String, Object>> getRequestParameters(List<TextSegment> textSegments) {
        if (MODEL_V1_ID.equals(this.model)) {
            if (this.dimensions != null || this.normalize != null) {
                throw new IllegalArgumentException("Dimensions and normalize are not supported for Titan Embedding model V1");
            }
            return textSegments.stream().map(TextSegment::text).map(text -> BedrockTitanEmbeddingModel.of("inputText", text)).collect(Collectors.toList());
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (TextSegment textSegment : textSegments) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("inputText", textSegment.text());
            parameters.put("dimensions", this.dimensions);
            parameters.put("normalize", this.normalize);
            result.add(parameters);
        }
        return result;
    }

    @Override
    protected Class<BedrockTitanEmbeddingResponse> getResponseClassType() {
        return BedrockTitanEmbeddingResponse.class;
    }

    private static String $default$model() {
        return Types.TitanEmbedTextV1.getValue();
    }

    protected BedrockTitanEmbeddingModel(BedrockTitanEmbeddingModelBuilder<?, ?> b) {
        super(b);
        this.model = b.model$set ? b.model$value : BedrockTitanEmbeddingModel.$default$model();
        this.dimensions = b.dimensions;
        this.normalize = b.normalize;
    }

    public static BedrockTitanEmbeddingModelBuilder<?, ?> builder() {
        return new BedrockTitanEmbeddingModelBuilderImpl();
    }

    public String getModel() {
        return this.model;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public Boolean getNormalize() {
        return this.normalize;
    }

    public static enum Types {
        TitanEmbedTextV1("amazon.titan-embed-text-v1"),
        TitanEmbedTextV2("amazon.titan-embed-text-v2:0");

        private final String value;

        private Types(String modelID) {
            this.value = modelID;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static abstract class BedrockTitanEmbeddingModelBuilder<C extends BedrockTitanEmbeddingModel, B extends BedrockTitanEmbeddingModelBuilder<C, B>>
    extends AbstractBedrockEmbeddingModel.AbstractBedrockEmbeddingModelBuilder<BedrockTitanEmbeddingResponse, C, B> {
        private boolean model$set;
        private String model$value;
        private Integer dimensions;
        private Boolean normalize;

        public B model(String model) {
            this.model$value = model;
            this.model$set = true;
            return (B)this.self();
        }

        public B dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return (B)this.self();
        }

        public B normalize(Boolean normalize) {
            this.normalize = normalize;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BedrockTitanEmbeddingModel.BedrockTitanEmbeddingModelBuilder(super=" + super.toString() + ", model$value=" + this.model$value + ", dimensions=" + this.dimensions + ", normalize=" + this.normalize + ")";
        }
    }

    private static final class BedrockTitanEmbeddingModelBuilderImpl
    extends BedrockTitanEmbeddingModelBuilder<BedrockTitanEmbeddingModel, BedrockTitanEmbeddingModelBuilderImpl> {
        private BedrockTitanEmbeddingModelBuilderImpl() {
        }

        @Override
        protected BedrockTitanEmbeddingModelBuilderImpl self() {
            return this;
        }

        @Override
        public BedrockTitanEmbeddingModel build() {
            return new BedrockTitanEmbeddingModel(this);
        }
    }
}

