/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.model.bedrock.internal.BedrockChatModelResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;

public class BedrockStabilityAIChatModelResponse
implements BedrockChatModelResponse {
    private String result;
    private List<Artifact> artifacts;

    @Override
    public String getOutputText() {
        return this.artifacts.get(0).base64;
    }

    @Override
    public FinishReason getFinishReason() {
        switch (this.artifacts.get(0).finishReason) {
            case "SUCCESS": {
                return FinishReason.STOP;
            }
            case "CONTENT_FILTERED": {
                return FinishReason.CONTENT_FILTER;
            }
        }
        throw new IllegalArgumentException("Unknown stop reason: " + this.artifacts.get(0).finishReason);
    }

    @Override
    public TokenUsage getTokenUsage() {
        return null;
    }

    public String getResult() {
        return this.result;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public static class Artifact {
        private String base64;
        private int seed;
        private String finishReason;

        public String getBase64() {
            return this.base64;
        }

        public int getSeed() {
            return this.seed;
        }

        public String getFinishReason() {
            return this.finishReason;
        }

        public void setBase64(String base64) {
            this.base64 = base64;
        }

        public void setSeed(int seed) {
            this.seed = seed;
        }

        public void setFinishReason(String finishReason) {
            this.finishReason = finishReason;
        }
    }
}

