/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.model.bedrock.BedrockAnthropicChatModelResponse;
import dev.langchain4j.model.bedrock.internal.AbstractBedrockChatModel;
import java.util.HashMap;
import java.util.Map;

public class BedrockAnthropicChatModel
extends AbstractBedrockChatModel<BedrockAnthropicChatModelResponse> {
    private static final String DEFAULT_ANTHROPIC_VERSION = "bedrock-2023-05-31";
    private final int topK;
    private final String anthropicVersion;
    private final Types model;

    @Override
    protected String getModelId() {
        return this.model.getValue();
    }

    @Override
    protected Map<String, Object> getRequestParameters(String prompt) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(7);
        parameters.put("prompt", prompt);
        parameters.put("max_tokens_to_sample", this.getMaxTokens());
        parameters.put("temperature", Float.valueOf(this.getTemperature()));
        parameters.put("top_k", this.topK);
        parameters.put("top_p", Float.valueOf(this.getTopP()));
        parameters.put("stop_sequences", this.getStopSequences());
        parameters.put("anthropic_version", this.anthropicVersion);
        return parameters;
    }

    @Override
    public Class<BedrockAnthropicChatModelResponse> getResponseClassType() {
        return BedrockAnthropicChatModelResponse.class;
    }

    private static int $default$topK() {
        return 250;
    }

    private static String $default$anthropicVersion() {
        return DEFAULT_ANTHROPIC_VERSION;
    }

    private static Types $default$model() {
        return Types.AnthropicClaudeV2;
    }

    protected BedrockAnthropicChatModel(BedrockAnthropicChatModelBuilder<?, ?> b) {
        super(b);
        this.topK = ((BedrockAnthropicChatModelBuilder)b).topK$set ? ((BedrockAnthropicChatModelBuilder)b).topK$value : BedrockAnthropicChatModel.$default$topK();
        this.anthropicVersion = ((BedrockAnthropicChatModelBuilder)b).anthropicVersion$set ? ((BedrockAnthropicChatModelBuilder)b).anthropicVersion$value : BedrockAnthropicChatModel.$default$anthropicVersion();
        this.model = ((BedrockAnthropicChatModelBuilder)b).model$set ? ((BedrockAnthropicChatModelBuilder)b).model$value : BedrockAnthropicChatModel.$default$model();
    }

    public static BedrockAnthropicChatModelBuilder<?, ?> builder() {
        return new BedrockAnthropicChatModelBuilderImpl();
    }

    public int getTopK() {
        return this.topK;
    }

    public String getAnthropicVersion() {
        return this.anthropicVersion;
    }

    public Types getModel() {
        return this.model;
    }

    private static final class BedrockAnthropicChatModelBuilderImpl
    extends BedrockAnthropicChatModelBuilder<BedrockAnthropicChatModel, BedrockAnthropicChatModelBuilderImpl> {
        private BedrockAnthropicChatModelBuilderImpl() {
        }

        @Override
        protected BedrockAnthropicChatModelBuilderImpl self() {
            return this;
        }

        @Override
        public BedrockAnthropicChatModel build() {
            return new BedrockAnthropicChatModel(this);
        }
    }

    public static abstract class BedrockAnthropicChatModelBuilder<C extends BedrockAnthropicChatModel, B extends BedrockAnthropicChatModelBuilder<C, B>>
    extends AbstractBedrockChatModel.AbstractBedrockChatModelBuilder<BedrockAnthropicChatModelResponse, C, B> {
        private boolean topK$set;
        private int topK$value;
        private boolean anthropicVersion$set;
        private String anthropicVersion$value;
        private boolean model$set;
        private Types model$value;

        public B topK(int topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return (B)this.self();
        }

        public B anthropicVersion(String anthropicVersion) {
            this.anthropicVersion$value = anthropicVersion;
            this.anthropicVersion$set = true;
            return (B)this.self();
        }

        public B model(Types model) {
            this.model$value = model;
            this.model$set = true;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BedrockAnthropicChatModel.BedrockAnthropicChatModelBuilder(super=" + super.toString() + ", topK$value=" + this.topK$value + ", anthropicVersion$value=" + this.anthropicVersion$value + ", model$value=" + (Object)((Object)this.model$value) + ")";
        }
    }

    public static enum Types {
        AnthropicClaudeInstantV1("anthropic.claude-instant-v1"),
        AnthropicClaudeV1("anthropic.claude-v1"),
        AnthropicClaudeV2("anthropic.claude-v2");

        private final String value;

        private Types(String modelID) {
            this.value = modelID;
        }

        public String getValue() {
            return this.value;
        }
    }
}

