/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.anthropic.InternalAnthropicHelper;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCacheType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.api.AnthropicThinking;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class AnthropicChatModel
implements ChatModel {
    private final AnthropicClient client;
    private final boolean cacheSystemMessages;
    private final boolean cacheTools;
    private final String thinkingType;
    private final Integer thinkingBudgetTokens;
    private final boolean returnThinking;
    private final boolean sendThinking;
    private final int maxRetries;
    private final List<ChatModelListener> listeners;
    private final ChatRequestParameters defaultRequestParameters;
    private final String toolChoiceName;
    private final Boolean disableParallelToolUse;
    private final String userId;
    private final Map<String, Object> customParameters;

    public AnthropicChatModel(AnthropicChatModelBuilder builder) {
        ChatRequestParameters commonParameters;
        this.client = ((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)AnthropicClient.builder().httpClientBuilder(builder.httpClientBuilder)).baseUrl((String)Utils.getOrDefault((Object)builder.baseUrl, (Object)"https://api.anthropic.com/v1/"))).apiKey(builder.apiKey)).version((String)Utils.getOrDefault((Object)builder.version, (Object)"2023-06-01"))).beta(builder.beta)).timeout(builder.timeout)).logRequests((Boolean)Utils.getOrDefault((Object)builder.logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false))).logger(builder.logger)).build();
        this.cacheSystemMessages = (Boolean)Utils.getOrDefault((Object)builder.cacheSystemMessages, (Object)false);
        this.cacheTools = (Boolean)Utils.getOrDefault((Object)builder.cacheTools, (Object)false);
        this.thinkingType = builder.thinkingType;
        this.thinkingBudgetTokens = builder.thinkingBudgetTokens;
        this.returnThinking = (Boolean)Utils.getOrDefault((Object)builder.returnThinking, (Object)false);
        this.sendThinking = (Boolean)Utils.getOrDefault((Object)builder.sendThinking, (Object)true);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)builder.maxRetries, (Object)2);
        this.listeners = Utils.copy(builder.listeners);
        this.toolChoiceName = builder.toolChoiceName;
        this.disableParallelToolUse = builder.disableParallelToolUse;
        this.userId = builder.userId;
        this.customParameters = Utils.copy(builder.customParameters);
        if (builder.defaultRequestParameters != null) {
            InternalAnthropicHelper.validate(builder.defaultRequestParameters);
            commonParameters = builder.defaultRequestParameters;
        } else {
            commonParameters = DefaultChatRequestParameters.EMPTY;
        }
        this.defaultRequestParameters = DefaultChatRequestParameters.builder().modelName((String)Utils.getOrDefault((Object)builder.modelName, (Object)commonParameters.modelName())).temperature((Double)Utils.getOrDefault((Object)builder.temperature, (Object)commonParameters.temperature())).topP((Double)Utils.getOrDefault((Object)builder.topP, (Object)commonParameters.topP())).topK((Integer)Utils.getOrDefault((Object)builder.topK, (Object)commonParameters.topK())).maxOutputTokens((Integer)Utils.getOrDefault((Object)builder.maxTokens, (Object)((Integer)Utils.getOrDefault((Object)commonParameters.maxOutputTokens(), (Object)1024)))).stopSequences(Utils.getOrDefault(builder.stopSequences, (List)commonParameters.stopSequences())).toolSpecifications(Utils.getOrDefault(builder.toolSpecifications, (List)commonParameters.toolSpecifications())).toolChoice((ToolChoice)Utils.getOrDefault((Object)builder.toolChoice, (Object)commonParameters.toolChoice())).build();
    }

    public static AnthropicChatModelBuilder builder() {
        return new AnthropicChatModelBuilder();
    }

    public ChatResponse doChat(ChatRequest chatRequest) {
        InternalAnthropicHelper.validate(chatRequest.parameters());
        AnthropicCreateMessageRequest anthropicRequest = InternalAnthropicHelper.createAnthropicRequest(chatRequest, AnthropicChatModel.toThinking(this.thinkingType, this.thinkingBudgetTokens), this.sendThinking, this.cacheSystemMessages ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE, this.cacheTools ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE, false, this.toolChoiceName, this.disableParallelToolUse, this.userId, this.customParameters);
        AnthropicCreateMessageResponse response = (AnthropicCreateMessageResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.createMessage(anthropicRequest), (int)this.maxRetries);
        return this.createChatResponse(response);
    }

    private ChatResponse createChatResponse(AnthropicCreateMessageResponse response) {
        ChatResponseMetadata responseMetadata = ChatResponseMetadata.builder().id(response.id).modelName(response.model).tokenUsage(AnthropicMapper.toTokenUsage(response.usage)).finishReason(AnthropicMapper.toFinishReason(response.stopReason)).build();
        return ChatResponse.builder().aiMessage(AnthropicMapper.toAiMessage(response.content, this.returnThinking)).metadata(responseMetadata).build();
    }

    static AnthropicThinking toThinking(String thinkingType, Integer thinkingBudgetTokens) {
        if (thinkingType != null || thinkingBudgetTokens != null) {
            return AnthropicThinking.builder().type(thinkingType).budgetTokens(thinkingBudgetTokens).build();
        }
        return null;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.ANTHROPIC;
    }

    public ChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public static class AnthropicChatModelBuilder {
        private HttpClientBuilder httpClientBuilder;
        private String baseUrl;
        private String apiKey;
        private String version;
        private String beta;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer topK;
        private Integer maxTokens;
        private List<String> stopSequences;
        private List<ToolSpecification> toolSpecifications;
        private ToolChoice toolChoice;
        private String toolChoiceName;
        private Boolean disableParallelToolUse;
        private Boolean cacheSystemMessages;
        private Boolean cacheTools;
        private String thinkingType;
        private Integer thinkingBudgetTokens;
        private Boolean returnThinking;
        private Boolean sendThinking;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;
        private Logger logger;
        private List<ChatModelListener> listeners;
        private ChatRequestParameters defaultRequestParameters;
        private String userId;
        private Map<String, Object> customParameters;

        public AnthropicChatModelBuilder httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        public AnthropicChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public AnthropicChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public AnthropicChatModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AnthropicChatModelBuilder beta(String beta) {
            this.beta = beta;
            return this;
        }

        public AnthropicChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public AnthropicChatModelBuilder modelName(AnthropicChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public AnthropicChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AnthropicChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public AnthropicChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public AnthropicChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public AnthropicChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public AnthropicChatModelBuilder toolSpecifications(List<ToolSpecification> toolSpecifications) {
            this.toolSpecifications = toolSpecifications;
            return this;
        }

        public AnthropicChatModelBuilder toolSpecifications(ToolSpecification ... toolSpecifications) {
            return this.toolSpecifications(Arrays.asList(toolSpecifications));
        }

        public AnthropicChatModelBuilder toolChoice(ToolChoice toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public AnthropicChatModelBuilder toolChoiceName(String toolChoiceName) {
            this.toolChoiceName = this.toolChoiceName;
            return this;
        }

        public AnthropicChatModelBuilder disableParallelToolUse(Boolean disableParallelToolUse) {
            this.disableParallelToolUse = disableParallelToolUse;
            return this;
        }

        public AnthropicChatModelBuilder cacheSystemMessages(Boolean cacheSystemMessages) {
            this.cacheSystemMessages = cacheSystemMessages;
            return this;
        }

        public AnthropicChatModelBuilder cacheTools(Boolean cacheTools) {
            this.cacheTools = cacheTools;
            return this;
        }

        public AnthropicChatModelBuilder thinkingType(String thinkingType) {
            this.thinkingType = thinkingType;
            return this;
        }

        public AnthropicChatModelBuilder thinkingBudgetTokens(Integer thinkingBudgetTokens) {
            this.thinkingBudgetTokens = thinkingBudgetTokens;
            return this;
        }

        public AnthropicChatModelBuilder returnThinking(Boolean returnThinking) {
            this.returnThinking = returnThinking;
            return this;
        }

        public AnthropicChatModelBuilder sendThinking(Boolean sendThinking) {
            this.sendThinking = sendThinking;
            return this;
        }

        public AnthropicChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public AnthropicChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public AnthropicChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public AnthropicChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AnthropicChatModelBuilder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public AnthropicChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public AnthropicChatModelBuilder defaultRequestParameters(ChatRequestParameters parameters) {
            this.defaultRequestParameters = parameters;
            return this;
        }

        public AnthropicChatModelBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AnthropicChatModelBuilder customParameters(Map<String, Object> customParameters) {
            this.customParameters = customParameters;
            return this;
        }

        public AnthropicChatModel build() {
            return new AnthropicChatModel(this);
        }
    }
}

