/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.mapper;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.PdfFileContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.pdf.PdfFile;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.anthropic.AnthropicTokenUsage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCacheType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicImageContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicMessage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicMessageContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicPdfContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicRedactedThinkingContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicRole;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTextContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicThinkingContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTool;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolChoice;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolChoiceType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolResultContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolSchema;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolUseContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicUsage;
import dev.langchain4j.model.anthropic.internal.client.Json;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Internal
public class AnthropicMapper {
    public static final String THINKING_SIGNATURE_KEY = "thinking_signature";
    public static final String REDACTED_THINKING_KEY = "redacted_thinking";

    public static List<AnthropicMessage> toAnthropicMessages(List<ChatMessage> messages) {
        return AnthropicMapper.toAnthropicMessages(messages, false);
    }

    public static List<AnthropicMessage> toAnthropicMessages(List<ChatMessage> messages, boolean sendThinking) {
        ArrayList<AnthropicMessage> anthropicMessages = new ArrayList<AnthropicMessage>();
        ArrayList<AnthropicMessageContent> toolContents = new ArrayList<AnthropicMessageContent>();
        for (ChatMessage message : messages) {
            List<AnthropicMessageContent> contents;
            if (message instanceof ToolExecutionResultMessage) {
                toolContents.add(AnthropicMapper.toAnthropicToolResultContent((ToolExecutionResultMessage)message));
                continue;
            }
            if (message instanceof SystemMessage) continue;
            if (!toolContents.isEmpty()) {
                anthropicMessages.add(new AnthropicMessage(AnthropicRole.USER, toolContents));
                toolContents = new ArrayList();
            }
            if (message instanceof UserMessage) {
                contents = AnthropicMapper.toAnthropicMessageContents((UserMessage)message);
                anthropicMessages.add(new AnthropicMessage(AnthropicRole.USER, contents));
                continue;
            }
            if (!(message instanceof AiMessage)) continue;
            AiMessage aiMessage = (AiMessage)message;
            contents = AnthropicMapper.toAnthropicMessageContents(aiMessage, sendThinking);
            anthropicMessages.add(new AnthropicMessage(AnthropicRole.ASSISTANT, contents));
        }
        if (!toolContents.isEmpty()) {
            anthropicMessages.add(new AnthropicMessage(AnthropicRole.USER, toolContents));
        }
        return anthropicMessages;
    }

    private static AnthropicToolResultContent toAnthropicToolResultContent(ToolExecutionResultMessage message) {
        return new AnthropicToolResultContent(message.id(), message.text(), null);
    }

    private static List<AnthropicMessageContent> toAnthropicMessageContents(UserMessage message) {
        return message.contents().stream().map(content -> {
            if (content instanceof TextContent) {
                TextContent textContent = (TextContent)content;
                return new AnthropicTextContent(textContent.text());
            }
            if (content instanceof ImageContent) {
                ImageContent imageContent = (ImageContent)content;
                Image image = imageContent.image();
                if (image.url() != null) {
                    return AnthropicImageContent.fromUrl(image.url().toString());
                }
                return AnthropicImageContent.fromBase64(ValidationUtils.ensureNotBlank((String)image.mimeType(), (String)"mimeType"), ValidationUtils.ensureNotBlank((String)image.base64Data(), (String)"base64Data"));
            }
            if (content instanceof PdfFileContent) {
                PdfFileContent pdfFileContent = (PdfFileContent)content;
                PdfFile pdfFile = pdfFileContent.pdfFile();
                return new AnthropicPdfContent(pdfFile.mimeType(), ValidationUtils.ensureNotBlank((String)pdfFile.base64Data(), (String)"base64Data"));
            }
            throw Exceptions.illegalArgument((String)("Unknown content type: " + String.valueOf(content)), (Object[])new Object[0]);
        }).collect(Collectors.toList());
    }

    private static List<AnthropicMessageContent> toAnthropicMessageContents(AiMessage message, boolean sendThinking) {
        ArrayList<AnthropicMessageContent> contents = new ArrayList<AnthropicMessageContent>();
        if (sendThinking && Utils.isNotNullOrBlank((String)message.thinking())) {
            String signature = (String)message.attribute(THINKING_SIGNATURE_KEY, String.class);
            contents.add(new AnthropicThinkingContent(message.thinking(), signature));
        }
        if (sendThinking && message.attributes().containsKey(REDACTED_THINKING_KEY)) {
            List redactedThinkings = (List)message.attribute(REDACTED_THINKING_KEY, List.class);
            for (String redactedThinking : redactedThinkings) {
                contents.add(new AnthropicRedactedThinkingContent(redactedThinking));
            }
        }
        if (Utils.isNotNullOrBlank((String)message.text())) {
            contents.add(new AnthropicTextContent(message.text()));
        }
        if (message.hasToolExecutionRequests()) {
            List<AnthropicToolUseContent> toolUseContents = message.toolExecutionRequests().stream().map(toolExecutionRequest -> AnthropicToolUseContent.builder().id(toolExecutionRequest.id()).name(toolExecutionRequest.name()).input(AnthropicMapper.toAnthropicInput(toolExecutionRequest)).build()).toList();
            contents.addAll(toolUseContents);
        }
        return contents;
    }

    private static Map<String, Object> toAnthropicInput(ToolExecutionRequest toolExecutionRequest) {
        String arguments = toolExecutionRequest.arguments();
        if (Utils.isNullOrBlank((String)arguments)) {
            return Map.of();
        }
        return Json.fromJson(arguments, Map.class);
    }

    public static List<AnthropicTextContent> toAnthropicSystemPrompt(List<ChatMessage> messages, AnthropicCacheType cacheType) {
        List systemMessages = messages.stream().filter(message -> message instanceof SystemMessage).map(message -> (SystemMessage)message).collect(Collectors.toList());
        SystemMessage lastSystemMessage = systemMessages.isEmpty() ? null : (SystemMessage)systemMessages.get(systemMessages.size() - 1);
        return systemMessages.stream().map(message -> {
            boolean isLastItem = message.equals((Object)lastSystemMessage);
            if (isLastItem && cacheType != AnthropicCacheType.NO_CACHE) {
                return new AnthropicTextContent(message.text(), cacheType.cacheControl());
            }
            return new AnthropicTextContent(message.text());
        }).collect(Collectors.toList());
    }

    public static AiMessage toAiMessage(List<AnthropicContent> contents) {
        return AnthropicMapper.toAiMessage(contents, false);
    }

    public static AiMessage toAiMessage(List<AnthropicContent> contents, boolean returnThinking) {
        String text = contents.stream().filter(content -> "text".equals(content.type)).map(content -> content.text).collect(Collectors.joining("\n"));
        String thinking = null;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (returnThinking) {
            List redactedThinkings;
            thinking = contents.stream().filter(content -> "thinking".equals(content.type)).map(content -> content.thinking).collect(Collectors.joining("\n"));
            String signature = contents.stream().filter(content -> "thinking".equals(content.type)).map(content -> content.signature).collect(Collectors.joining("\n"));
            if (Utils.isNotNullOrEmpty((String)signature)) {
                attributes.put(THINKING_SIGNATURE_KEY, signature);
            }
            if (!(redactedThinkings = contents.stream().filter(content -> REDACTED_THINKING_KEY.equals(content.type)).map(content -> content.data).collect(Collectors.toList())).isEmpty()) {
                attributes.put(REDACTED_THINKING_KEY, redactedThinkings);
            }
        }
        List toolExecutionRequests = contents.stream().filter(content -> "tool_use".equals(content.type)).map(content -> ToolExecutionRequest.builder().id(content.id).name(content.name).arguments(Json.toJson(content.input)).build()).collect(Collectors.toList());
        return AiMessage.builder().text(Utils.isNullOrEmpty((String)text) ? null : text).thinking(Utils.isNullOrEmpty((String)thinking) ? null : thinking).toolExecutionRequests(toolExecutionRequests).attributes(attributes).build();
    }

    public static TokenUsage toTokenUsage(AnthropicUsage anthropicUsage) {
        if (anthropicUsage == null) {
            return null;
        }
        return AnthropicTokenUsage.builder().inputTokenCount(anthropicUsage.inputTokens).outputTokenCount(anthropicUsage.outputTokens).cacheCreationInputTokens(anthropicUsage.cacheCreationInputTokens).cacheReadInputTokens(anthropicUsage.cacheReadInputTokens).build();
    }

    public static FinishReason toFinishReason(String anthropicStopReason) {
        if (anthropicStopReason == null) {
            return null;
        }
        return switch (anthropicStopReason) {
            case "end_turn", "stop_sequence" -> FinishReason.STOP;
            case "max_tokens" -> FinishReason.LENGTH;
            case "tool_use" -> FinishReason.TOOL_EXECUTION;
            default -> FinishReason.OTHER;
        };
    }

    public static AnthropicToolChoice toAnthropicToolChoice(ToolChoice toolChoice, String toolChoiceName, Boolean disableParallelToolUse) {
        AnthropicToolChoiceType toolChoiceType;
        if (toolChoice == null) {
            return null;
        }
        switch (toolChoice) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case AUTO: {
                AnthropicToolChoiceType anthropicToolChoiceType = AnthropicToolChoiceType.AUTO;
                break;
            }
            case REQUIRED: {
                AnthropicToolChoiceType anthropicToolChoiceType = AnthropicToolChoiceType.ANY;
                break;
            }
            case NONE: {
                AnthropicToolChoiceType anthropicToolChoiceType = toolChoiceType = AnthropicToolChoiceType.NONE;
            }
        }
        if (toolChoiceName != null) {
            return AnthropicToolChoice.from(toolChoiceName, disableParallelToolUse);
        }
        return AnthropicToolChoice.from(toolChoiceType, disableParallelToolUse);
    }

    public static List<AnthropicTool> toAnthropicTools(List<ToolSpecification> toolSpecifications, AnthropicCacheType cacheToolsPrompt) {
        ToolSpecification lastToolSpecification = toolSpecifications.isEmpty() ? null : toolSpecifications.get(toolSpecifications.size() - 1);
        return toolSpecifications.stream().map(toolSpecification -> {
            boolean isLastItem = toolSpecification.equals((Object)lastToolSpecification);
            if (isLastItem && cacheToolsPrompt != AnthropicCacheType.NO_CACHE) {
                return AnthropicMapper.toAnthropicTool(toolSpecification, cacheToolsPrompt);
            }
            return AnthropicMapper.toAnthropicTool(toolSpecification, AnthropicCacheType.NO_CACHE);
        }).collect(Collectors.toList());
    }

    public static AnthropicTool toAnthropicTool(ToolSpecification toolSpecification, AnthropicCacheType cacheToolsPrompt) {
        JsonObjectSchema parameters = toolSpecification.parameters();
        AnthropicTool.Builder toolBuilder = AnthropicTool.builder().name(toolSpecification.name()).description(toolSpecification.description()).inputSchema(AnthropicToolSchema.builder().properties(parameters != null ? JsonSchemaElementUtils.toMap((Map)parameters.properties()) : Collections.emptyMap()).required(parameters != null ? parameters.required() : Collections.emptyList()).build());
        if (cacheToolsPrompt != AnthropicCacheType.NO_CACHE) {
            return toolBuilder.cacheControl(cacheToolsPrompt.cacheControl()).build();
        }
        return toolBuilder.build();
    }
}

