/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.sanitizer;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSanitizer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSanitizer.class);

    public static List<ChatMessage> sanitizeMessages(List<ChatMessage> messages) {
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        ArrayList<ChatMessage> sanitizedMessages = new ArrayList<ChatMessage>(messages);
        MessageSanitizer.stripSystemMessages(sanitizedMessages);
        MessageSanitizer.ensureFirstMessageIsUserMessage(sanitizedMessages);
        MessageSanitizer.ensureNoConsecutiveUserMessages(sanitizedMessages);
        return sanitizedMessages;
    }

    private static void stripSystemMessages(List<ChatMessage> messages) {
        messages.removeIf(message -> message instanceof SystemMessage);
    }

    private static void ensureNoConsecutiveUserMessages(List<ChatMessage> messages) {
        boolean lastWasUserMessage = false;
        ArrayList<ChatMessage> toRemove = new ArrayList<ChatMessage>();
        for (ChatMessage message : messages) {
            if (message instanceof UserMessage) {
                if (lastWasUserMessage) {
                    toRemove.add(message);
                    log.warn("Removing consecutive UserMessage: {}", (Object)((UserMessage)message).singleText());
                    continue;
                }
                lastWasUserMessage = true;
                continue;
            }
            lastWasUserMessage = false;
        }
        messages.removeAll(toRemove);
    }

    private static void ensureFirstMessageIsUserMessage(List<ChatMessage> messages) {
        while (!messages.isEmpty() && !(messages.get(0) instanceof UserMessage)) {
            ChatMessage removedMessage = messages.remove(0);
            log.warn("Dropping non-UserMessage in 1st element: {}", (Object)removedMessage);
        }
    }
}

