package dev.langchain4j.model.anthropic.internal.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies.SnakeCaseStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.EqualsAndHashCode;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@EqualsAndHashCode
@JsonInclude(NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(SnakeCaseStrategy.class)
public abstract class AnthropicMessageContent {

    public String type;
    public AnthropicCacheControl cacheControl;

    public AnthropicMessageContent(String type) {
        this.type = type;
    }

    public AnthropicMessageContent(String type, AnthropicCacheControl cacheControl) {
        this.type = type;
        this.cacheControl = cacheControl;
    }
}
