/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.anthropic.InternalAnthropicHelper;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCacheType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTextContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicToolChoice;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.anthropic.internal.sanitizer.MessageSanitizer;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.output.Response;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnthropicStreamingChatModel
implements StreamingChatLanguageModel {
    private static final Logger log = LoggerFactory.getLogger(AnthropicStreamingChatModel.class);
    private final AnthropicClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer topK;
    private final int maxTokens;
    private final List<String> stopSequences;
    private final boolean cacheSystemMessages;
    private final boolean cacheTools;
    private final List<ChatModelListener> listeners;

    private AnthropicStreamingChatModel(String baseUrl, String apiKey, String version, String beta, String modelName, Double temperature, Double topP, Integer topK, Integer maxTokens, List<String> stopSequences, Boolean cacheSystemMessages, Boolean cacheTools, Duration timeout, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners) {
        this.client = ((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)AnthropicClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.anthropic.com/v1/"))).apiKey(apiKey)).version((String)Utils.getOrDefault((Object)version, (Object)"2023-06-01"))).beta(beta)).timeout((Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)AnthropicChatModelName.CLAUDE_3_HAIKU_20240307.toString());
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.maxTokens = (Integer)Utils.getOrDefault((Object)maxTokens, (Object)1024);
        this.stopSequences = stopSequences;
        this.cacheSystemMessages = (Boolean)Utils.getOrDefault((Object)cacheSystemMessages, (Object)false);
        this.cacheTools = (Boolean)Utils.getOrDefault((Object)cacheTools, (Object)false);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
    }

    @Deprecated(forRemoval=true)
    public static AnthropicStreamingChatModel withApiKey(String apiKey) {
        return AnthropicStreamingChatModel.builder().apiKey(apiKey).build();
    }

    public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, null, null, handler);
    }

    public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, toolSpecifications, null, handler);
    }

    public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
        this.generate(messages, null, toolSpecification, handler);
    }

    private void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted, final StreamingResponseHandler<AiMessage> handler) {
        AnthropicCacheType toolsCacheType;
        List<ChatMessage> sanitizedMessages = MessageSanitizer.sanitizeMessages(messages);
        List<AnthropicTextContent> systemPrompt = AnthropicMapper.toAnthropicSystemPrompt(messages, this.cacheSystemMessages ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE);
        ValidationUtils.ensureNotNull(handler, (String)"handler");
        AnthropicCreateMessageRequest.AnthropicCreateMessageRequestBuilder requestBuilder = AnthropicCreateMessageRequest.builder().stream(true).model(this.modelName).messages(AnthropicMapper.toAnthropicMessages(sanitizedMessages)).system(systemPrompt).maxTokens(this.maxTokens).stopSequences(this.stopSequences).temperature(this.temperature).topP(this.topP).topK(this.topK);
        AnthropicCacheType anthropicCacheType = toolsCacheType = this.cacheTools ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE;
        if (toolThatMustBeExecuted != null) {
            requestBuilder.tools(AnthropicMapper.toAnthropicTools(Collections.singletonList(toolThatMustBeExecuted), toolsCacheType));
            requestBuilder.toolChoice(AnthropicToolChoice.from(toolThatMustBeExecuted.name()));
        } else if (!Utils.isNullOrEmpty(toolSpecifications)) {
            requestBuilder.tools(AnthropicMapper.toAnthropicTools(toolSpecifications, toolsCacheType));
        }
        AnthropicCreateMessageRequest request = requestBuilder.build();
        final ChatModelRequest modelListenerRequest = InternalAnthropicHelper.createModelListenerRequest(request, messages, toolSpecifications);
        final ConcurrentHashMap attributes = new ConcurrentHashMap();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(modelListenerRequest, attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", (Throwable)e);
            }
        });
        StreamingResponseHandler<AiMessage> listenerHandler = new StreamingResponseHandler<AiMessage>(){

            public void onNext(String token) {
                handler.onNext(token);
            }

            public void onError(Throwable error) {
                ChatModelErrorContext errorContext = InternalAnthropicHelper.createErrorContext(error, modelListenerRequest, attributes);
                AnthropicStreamingChatModel.this.listeners.forEach(listener -> {
                    try {
                        listener.onError(errorContext);
                    }
                    catch (Exception e2) {
                        log.warn("Exception while calling model listener", (Throwable)e2);
                    }
                });
                handler.onError(error);
            }

            public void onComplete(Response<AiMessage> response) {
                ChatModelResponse modelListenerResponse = InternalAnthropicHelper.createModelListenerResponse((String)response.metadata().get("id"), (String)response.metadata().get("model"), response);
                ChatModelResponseContext responseContext = new ChatModelResponseContext(modelListenerResponse, modelListenerRequest, attributes);
                AnthropicStreamingChatModel.this.listeners.forEach(listener -> {
                    try {
                        listener.onResponse(responseContext);
                    }
                    catch (Exception e) {
                        log.warn("Exception while calling model listener", (Throwable)e);
                    }
                });
                handler.onComplete(response);
                super.onComplete(response);
            }
        };
        this.client.createMessage(request, listenerHandler);
    }

    public static AnthropicStreamingChatModelBuilder builder() {
        return new AnthropicStreamingChatModelBuilder();
    }

    public static class AnthropicStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String version;
        private String beta;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer topK;
        private Integer maxTokens;
        private List<String> stopSequences;
        private Boolean cacheSystemMessages;
        private Boolean cacheTools;
        private Duration timeout;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;

        public AnthropicStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public AnthropicStreamingChatModelBuilder modelName(AnthropicChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        AnthropicStreamingChatModelBuilder() {
        }

        public AnthropicStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public AnthropicStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public AnthropicStreamingChatModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AnthropicStreamingChatModelBuilder beta(String beta) {
            this.beta = beta;
            return this;
        }

        public AnthropicStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AnthropicStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public AnthropicStreamingChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public AnthropicStreamingChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public AnthropicStreamingChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public AnthropicStreamingChatModelBuilder cacheSystemMessages(Boolean cacheSystemMessages) {
            this.cacheSystemMessages = cacheSystemMessages;
            return this;
        }

        public AnthropicStreamingChatModelBuilder cacheTools(Boolean cacheTools) {
            this.cacheTools = cacheTools;
            return this;
        }

        public AnthropicStreamingChatModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public AnthropicStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public AnthropicStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AnthropicStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public AnthropicStreamingChatModel build() {
            return new AnthropicStreamingChatModel(this.baseUrl, this.apiKey, this.version, this.beta, this.modelName, this.temperature, this.topP, this.topK, this.maxTokens, this.stopSequences, this.cacheSystemMessages, this.cacheTools, this.timeout, this.logRequests, this.logResponses, this.listeners);
        }

        public String toString() {
            return "AnthropicStreamingChatModel.AnthropicStreamingChatModelBuilder(baseUrl=" + this.baseUrl + ", apiKey=" + this.apiKey + ", version=" + this.version + ", beta=" + this.beta + ", modelName=" + this.modelName + ", temperature=" + this.temperature + ", topP=" + this.topP + ", topK=" + this.topK + ", maxTokens=" + this.maxTokens + ", stopSequences=" + String.valueOf(this.stopSequences) + ", cacheSystemMessages=" + this.cacheSystemMessages + ", cacheTools=" + this.cacheTools + ", timeout=" + String.valueOf(this.timeout) + ", logRequests=" + this.logRequests + ", logResponses=" + this.logResponses + ", listeners=" + String.valueOf(this.listeners) + ")";
        }
    }
}

