/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.client;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClientBuilderFactory;
import dev.langchain4j.model.anthropic.internal.client.DefaultAnthropicClient;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Iterator;

public abstract class AnthropicClient {
    public abstract AnthropicCreateMessageResponse createMessage(AnthropicCreateMessageRequest var1);

    public abstract void createMessage(AnthropicCreateMessageRequest var1, StreamingResponseHandler<AiMessage> var2);

    public static Builder builder() {
        Iterator iterator = ServiceHelper.loadFactories(AnthropicClientBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            AnthropicClientBuilderFactory factory = (AnthropicClientBuilderFactory)iterator.next();
            return (Builder)factory.get();
        }
        return DefaultAnthropicClient.builder();
    }

    public static abstract class Builder<T extends AnthropicClient, B extends Builder<T, B>> {
        public String baseUrl;
        public String apiKey;
        public String version;
        public String beta;
        public Duration timeout;
        public Boolean logRequests;
        public Boolean logResponses;

        public abstract T build();

        public B baseUrl(String baseUrl) {
            if (baseUrl == null || baseUrl.trim().isEmpty()) {
                throw new IllegalArgumentException("baseUrl cannot be null or empty");
            }
            this.baseUrl = baseUrl;
            return (B)this;
        }

        public B apiKey(String apiKey) {
            if (apiKey == null || apiKey.trim().isEmpty()) {
                throw new IllegalArgumentException("Anthropic API key must be defined. It can be generated here: https://console.anthropic.com/settings/keys");
            }
            this.apiKey = apiKey;
            return (B)this;
        }

        public B version(String version) {
            if (version == null) {
                throw new IllegalArgumentException("version cannot be null or empty");
            }
            this.version = version;
            return (B)this;
        }

        public B beta(String beta) {
            if (beta == null) {
                throw new IllegalArgumentException("beta cannot be null or empty");
            }
            this.beta = beta;
            return (B)this;
        }

        public B timeout(Duration timeout) {
            if (timeout == null) {
                throw new IllegalArgumentException("timeout cannot be null");
            }
            this.timeout = timeout;
            return (B)this;
        }

        public B logRequests() {
            return this.logRequests(true);
        }

        public B logRequests(Boolean logRequests) {
            if (logRequests == null) {
                logRequests = false;
            }
            this.logRequests = logRequests;
            return (B)this;
        }

        public B logResponses() {
            return this.logResponses(true);
        }

        public B logResponses(Boolean logResponses) {
            if (logResponses == null) {
                logResponses = false;
            }
            this.logResponses = logResponses;
            return (B)this;
        }
    }
}

