/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.workflow.impl;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.internal.AbstractAgentInvocationHandler;
import dev.langchain4j.agentic.internal.AbstractService;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.agentic.workflow.ParallelAgentService;
import dev.langchain4j.internal.DefaultExecutorProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ParallelAgentServiceImpl<T>
extends AbstractService<T, ParallelAgentService<T>>
implements ParallelAgentService<T> {
    private Executor executor;

    private ParallelAgentServiceImpl(Class<T> agentServiceClass, Method agenticMethod) {
        super(agentServiceClass, agenticMethod);
    }

    @Override
    public T build() {
        return (T)Proxy.newProxyInstance(this.agentServiceClass.getClassLoader(), new Class[]{this.agentServiceClass, AgentSpecification.class, AgenticScopeOwner.class}, (InvocationHandler)new ParallelInvocationHandler());
    }

    public static ParallelAgentServiceImpl<UntypedAgent> builder() {
        return new ParallelAgentServiceImpl<UntypedAgent>(UntypedAgent.class, null);
    }

    public static <T> ParallelAgentServiceImpl<T> builder(Class<T> agentServiceClass) {
        return new ParallelAgentServiceImpl<T>(agentServiceClass, AgentUtil.validateAgentClass(agentServiceClass, false));
    }

    @Override
    public ParallelAgentServiceImpl<T> executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    private class ParallelInvocationHandler
    extends AbstractAgentInvocationHandler {
        private ParallelInvocationHandler() {
            super(ParallelAgentServiceImpl.this);
        }

        private ParallelInvocationHandler(DefaultAgenticScope agenticScope) {
            super(ParallelAgentServiceImpl.this, agenticScope);
        }

        @Override
        protected Object doAgentAction(DefaultAgenticScope agenticScope) {
            this.parallelExecution(agenticScope);
            return this.result(agenticScope, ParallelAgentServiceImpl.this.output.apply(agenticScope));
        }

        @Override
        protected InvocationHandler createSubAgentWithAgenticScope(DefaultAgenticScope agenticScope) {
            return new ParallelInvocationHandler(agenticScope);
        }

        private void parallelExecution(DefaultAgenticScope agenticScope) {
            ExecutorService exec = ParallelAgentServiceImpl.this.executor != null ? ParallelAgentServiceImpl.this.executor : DefaultExecutorProvider.getDefaultExecutorService();
            List<CompletableFuture> tasks = ParallelAgentServiceImpl.this.agentExecutors().stream().map(agentExecutor -> CompletableFuture.supplyAsync(() -> agentExecutor.execute(agenticScope), exec)).toList();
            try {
                for (Future future : tasks) {
                    future.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

