/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.workflow.impl;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.internal.AbstractAgentInvocationHandler;
import dev.langchain4j.agentic.internal.AbstractService;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.agentic.workflow.ParallelAgentService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelAgentServiceImpl<T>
extends AbstractService<T, ParallelAgentService<T>>
implements ParallelAgentService<T> {
    private ExecutorService executorService;

    private ParallelAgentServiceImpl(Class<T> agentServiceClass) {
        super(agentServiceClass);
    }

    @Override
    public T build() {
        return (T)Proxy.newProxyInstance(this.agentServiceClass.getClassLoader(), new Class[]{this.agentServiceClass, AgentSpecification.class, AgenticScopeOwner.class}, (InvocationHandler)new ParallelInvocationHandler());
    }

    public static ParallelAgentServiceImpl<UntypedAgent> builder() {
        return ParallelAgentServiceImpl.builder(UntypedAgent.class);
    }

    public static <T> ParallelAgentServiceImpl<T> builder(Class<T> agentServiceClass) {
        return new ParallelAgentServiceImpl<T>(agentServiceClass);
    }

    @Override
    public ParallelAgentServiceImpl<T> executorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    private class ParallelInvocationHandler
    extends AbstractAgentInvocationHandler {
        private ParallelInvocationHandler() {
            super(ParallelAgentServiceImpl.this);
        }

        private ParallelInvocationHandler(DefaultAgenticScope agenticScope) {
            super(ParallelAgentServiceImpl.this, agenticScope);
        }

        @Override
        protected Object doAgentAction(DefaultAgenticScope agenticScope) {
            this.parallelExecution(agenticScope);
            return this.result(agenticScope, ParallelAgentServiceImpl.this.output.apply(agenticScope));
        }

        @Override
        protected InvocationHandler createSubAgentWithAgenticScope(DefaultAgenticScope agenticScope) {
            return new ParallelInvocationHandler(agenticScope);
        }

        private void parallelExecution(DefaultAgenticScope agenticScope) {
            ExecutorService executors = ParallelAgentServiceImpl.this.executorService != null ? ParallelAgentServiceImpl.this.executorService : DefaultExecutorHolder.DEFAULT_EXECUTOR;
            List<Callable> tasks = ParallelAgentServiceImpl.this.agentExecutors().stream().map(agentExecutor -> () -> agentExecutor.execute(agenticScope)).toList();
            try {
                for (Future future : executors.invokeAll(tasks)) {
                    future.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class DefaultExecutorHolder {
        private static final ExecutorService DEFAULT_EXECUTOR = Executors.newCachedThreadPool();

        private DefaultExecutorHolder() {
        }
    }
}

