/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.scope;

import dev.langchain4j.Internal;
import dev.langchain4j.agentic.agent.AgentInvocationException;
import dev.langchain4j.agentic.agent.ErrorContext;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.internal.AgentInvocation;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.scope.AgenticScopeRegistry;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultAgenticScope
implements AgenticScope {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAgenticScope.class);
    private final Object memoryId;
    private final Map<String, Object> state = new ConcurrentHashMap<String, Object>();
    private final Map<String, List<AgentInvocation>> agentInvocations = new ConcurrentHashMap<String, List<AgentInvocation>>();
    private final List<AgentMessage> context = Collections.synchronizedList(new ArrayList());
    private final transient Map<String, Object> agents = new ConcurrentHashMap<String, Object>();
    private static final Function<ErrorContext, ErrorRecoveryResult> DEFAULT_ERROR_RECOVERY = errorContext -> ErrorRecoveryResult.throwException();
    private transient Function<ErrorContext, ErrorRecoveryResult> errorHandler = DEFAULT_ERROR_RECOVERY;
    private final Kind kind;
    private transient ReadWriteLock lock = null;

    DefaultAgenticScope(Kind kind) {
        this(UUID.randomUUID().toString(), kind);
    }

    DefaultAgenticScope(Object memoryId, Kind kind) {
        this.memoryId = memoryId;
        this.kind = kind;
        if (kind == Kind.PERSISTENT) {
            this.lock = new ReentrantReadWriteLock();
        }
    }

    @Override
    public Object memoryId() {
        return this.memoryId;
    }

    @Override
    public void writeState(String key, Object value) {
        this.withReadLock(() -> {
            if (value == null) {
                this.state.remove(key);
            } else {
                this.state.put(key, value);
            }
        });
    }

    @Override
    public void writeStates(Map<String, Object> newState) {
        this.withReadLock(() -> this.state.putAll(newState));
    }

    @Override
    public boolean hasState(String key) {
        String s;
        Object value = this.state.get(key);
        if (value == null) {
            return false;
        }
        return value instanceof String ? !(s = (String)value).isBlank() : true;
    }

    @Override
    public Object readState(String key) {
        return this.state.get(key);
    }

    @Override
    public <T> T readState(String key, T defaultValue) {
        return (T)this.state.getOrDefault(key, defaultValue);
    }

    @Override
    public Map<String, Object> state() {
        return this.state;
    }

    public <T> T getOrCreateAgent(String agentId, Function<DefaultAgenticScope, T> agentFactory) {
        return (T)this.agents.computeIfAbsent(agentId, id -> agentFactory.apply(this));
    }

    public void registerAgentCall(String agentName, Object agent, Object[] input, Object output) {
        this.withReadLock(() -> {
            this.agentInvocations.computeIfAbsent(agentName, name -> new ArrayList()).add(new AgentInvocation(agentName, input, output));
            this.registerContext(agentName, agent);
        });
    }

    public void rootCallStarted(AgenticScopeRegistry registry) {
    }

    public void rootCallEnded(AgenticScopeRegistry registry) {
        if (this.kind == Kind.EPHEMERAL) {
            registry.evict(this.memoryId);
        } else if (this.kind == Kind.PERSISTENT) {
            this.flush(registry);
        }
    }

    private void flush(AgenticScopeRegistry registry) {
        this.lock.writeLock().lock();
        try {
            registry.update(this);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void registerContext(String agentName, Object agent) {
        List agentMessages;
        ChatMessage lastMessage;
        ChatMemoryAccess agentWithMemory;
        ChatMemory chatMemory;
        if (agent instanceof ChatMemoryAccess && (chatMemory = (agentWithMemory = (ChatMemoryAccess)agent).getChatMemory(this.memoryId)) != null && (lastMessage = (ChatMessage)(agentMessages = chatMemory.messages()).get(agentMessages.size() - 1)) instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)lastMessage;
            for (int i = agentMessages.size() - 1; i >= 0; --i) {
                Object e = agentMessages.get(i);
                if (!(e instanceof UserMessage)) continue;
                UserMessage userMessage = (UserMessage)e;
                this.context.add(new AgentMessage(agentName, (ChatMessage)userMessage));
                this.context.add(new AgentMessage(agentName, (ChatMessage)aiMessage));
                return;
            }
        }
    }

    public List<AgentMessage> context() {
        return this.context;
    }

    @Override
    public String contextAsConversation(String ... agentNames) {
        Predicate<String> agentFilter = agentNames != null && agentNames.length > 0 ? List.of(agentNames)::contains : agent -> true;
        StringBuilder sb = new StringBuilder();
        for (AgentMessage agentMessage : this.context) {
            if (!agentFilter.test(agentMessage.agentName())) continue;
            ChatMessage message = agentMessage.message();
            if (message instanceof UserMessage) {
                UserMessage userMessage = (UserMessage)message;
                sb.append("User: ").append(userMessage.singleText()).append("\n");
                continue;
            }
            if (!(message instanceof AiMessage)) continue;
            AiMessage aiMessage = (AiMessage)message;
            sb.append(agentMessage.agentName()).append(" agent: ").append(aiMessage.text()).append("\n");
        }
        String contextAsConversation = sb.toString();
        LOG.debug("AgenticScope context as conversation: '{}'", (Object)contextAsConversation);
        return contextAsConversation;
    }

    public List<AgentInvocation> agentInvocations(String agentName) {
        return this.agentInvocations.getOrDefault(agentName, List.of());
    }

    public String toString() {
        return "AgenticScope{memoryId='" + String.valueOf(this.memoryId) + "', state=" + String.valueOf(this.state) + "}";
    }

    private void withReadLock(Runnable action) {
        if (this.kind == Kind.PERSISTENT) {
            this.lock.readLock().lock();
            try {
                action.run();
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            action.run();
        }
    }

    public DefaultAgenticScope withErrorHandler(Function<ErrorContext, ErrorRecoveryResult> errorHandler) {
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
        return this;
    }

    public ErrorRecoveryResult handleError(String agentName, AgentInvocationException exception) {
        return this.errorHandler.apply(new ErrorContext(agentName, this, exception));
    }

    DefaultAgenticScope normalizeAfterDeserialization() {
        HashMap modifiedEntries = new HashMap();
        for (Map.Entry<String, Object> entry : this.state.entrySet()) {
            this.enumValue(entry).ifPresent(enumValue -> modifiedEntries.put(entry.getKey(), enumValue));
        }
        this.state.putAll(modifiedEntries);
        return this;
    }

    private Optional<Object> enumValue(Map.Entry<String, Object> entry) {
        Map m;
        Object object = entry.getValue();
        if (object instanceof Map && (m = (Map)object).size() == 1) {
            Map.Entry e = m.entrySet().iterator().next();
            try {
                Class<?> c = Class.forName(e.getKey().toString());
                if (c.isEnum()) {
                    return Optional.ofNullable(Enum.valueOf(c, e.getValue().toString()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static enum Kind {
        EPHEMERAL,
        REGISTERED,
        PERSISTENT;

    }

    public record AgentMessage(String agentName, ChatMessage message) {
    }
}

