/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.agent.AgentBuilder;
import dev.langchain4j.agentic.agent.ErrorContext;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.declarative.ActivationCondition;
import dev.langchain4j.agentic.declarative.ConditionalAgent;
import dev.langchain4j.agentic.declarative.ErrorHandler;
import dev.langchain4j.agentic.declarative.ExecutorService;
import dev.langchain4j.agentic.declarative.ExitCondition;
import dev.langchain4j.agentic.declarative.LoopAgent;
import dev.langchain4j.agentic.declarative.Output;
import dev.langchain4j.agentic.declarative.ParallelAgent;
import dev.langchain4j.agentic.declarative.SequenceAgent;
import dev.langchain4j.agentic.declarative.SubAgent;
import dev.langchain4j.agentic.declarative.SupervisorAgent;
import dev.langchain4j.agentic.declarative.SupervisorChatModel;
import dev.langchain4j.agentic.declarative.SupervisorRequest;
import dev.langchain4j.agentic.internal.A2AClientBuilder;
import dev.langchain4j.agentic.internal.A2AService;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.supervisor.SupervisorAgentService;
import dev.langchain4j.agentic.supervisor.SupervisorAgentServiceImpl;
import dev.langchain4j.agentic.workflow.ConditionalAgentService;
import dev.langchain4j.agentic.workflow.HumanInTheLoop;
import dev.langchain4j.agentic.workflow.LoopAgentService;
import dev.langchain4j.agentic.workflow.ParallelAgentService;
import dev.langchain4j.agentic.workflow.SequentialAgentService;
import dev.langchain4j.agentic.workflow.WorkflowAgentsBuilder;
import dev.langchain4j.agentic.workflow.WorkflowService;
import dev.langchain4j.agentic.workflow.impl.WorkflowAgentsBuilderImpl;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.ChatModel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AgenticServices {
    private AgenticServices() {
    }

    public static void setWorkflowAgentsBuilder(WorkflowAgentsBuilder workflowAgentsBuilder) {
        WorkflowBuilderProvider.INSTANCE.internalSetWorkflowAgentsBuilder(workflowAgentsBuilder);
    }

    private static WorkflowAgentsBuilder workflowAgentsBuilder() {
        return WorkflowBuilderProvider.INSTANCE.workflowAgentsBuilder;
    }

    public static <T> AgentBuilder<T> agentBuilder(Class<T> agentServiceClass) {
        return new AgentBuilder<T>(agentServiceClass, AgentUtil.validateAgentClass(agentServiceClass));
    }

    public static HumanInTheLoop.HumanInTheLoopBuilder humanInTheLoopBuilder() {
        return new HumanInTheLoop.HumanInTheLoopBuilder();
    }

    public static SequentialAgentService<UntypedAgent> sequenceBuilder() {
        return AgenticServices.workflowAgentsBuilder().sequenceBuilder();
    }

    public static <T> SequentialAgentService<T> sequenceBuilder(Class<T> agentServiceClass) {
        return AgenticServices.workflowAgentsBuilder().sequenceBuilder(agentServiceClass);
    }

    public static ParallelAgentService<UntypedAgent> parallelBuilder() {
        return AgenticServices.workflowAgentsBuilder().parallelBuilder();
    }

    public static <T> ParallelAgentService<T> parallelBuilder(Class<T> agentServiceClass) {
        return AgenticServices.workflowAgentsBuilder().parallelBuilder(agentServiceClass);
    }

    public static LoopAgentService<UntypedAgent> loopBuilder() {
        return AgenticServices.workflowAgentsBuilder().loopBuilder();
    }

    public static <T> LoopAgentService<T> loopBuilder(Class<T> agentServiceClass) {
        return AgenticServices.workflowAgentsBuilder().loopBuilder(agentServiceClass);
    }

    public static ConditionalAgentService<UntypedAgent> conditionalBuilder() {
        return AgenticServices.workflowAgentsBuilder().conditionalBuilder();
    }

    public static <T> ConditionalAgentService<T> conditionalBuilder(Class<T> agentServiceClass) {
        return AgenticServices.workflowAgentsBuilder().conditionalBuilder(agentServiceClass);
    }

    public static SupervisorAgentService<dev.langchain4j.agentic.supervisor.SupervisorAgent> supervisorBuilder() {
        return SupervisorAgentServiceImpl.builder();
    }

    public static <T> SupervisorAgentService<T> supervisorBuilder(Class<T> agentServiceClass) {
        return SupervisorAgentServiceImpl.builder(agentServiceClass);
    }

    public static A2AClientBuilder<UntypedAgent> a2aBuilder(String a2aServerUrl) {
        return AgenticServices.a2aBuilder(a2aServerUrl, UntypedAgent.class);
    }

    public static <T> A2AClientBuilder<T> a2aBuilder(String a2aServerUrl, Class<T> agentServiceClass) {
        return A2AService.get().a2aBuilder(a2aServerUrl, agentServiceClass);
    }

    public static <T> T createAgenticSystem(Class<T> agentServiceClass, ChatModel chatModel) {
        T agent = AgenticServices.createComposedAgent(agentServiceClass, chatModel);
        if (agent == null) {
            throw new IllegalArgumentException("Provided class " + agentServiceClass.getName() + " is not an agent.");
        }
        return agent;
    }

    private static <T> T createComposedAgent(Class<T> agentServiceClass, ChatModel chatModel) {
        Optional<Method> sequenceMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, SequenceAgent.class);
        if (sequenceMethod.isPresent()) {
            return AgenticServices.buildSequentialAgent(agentServiceClass, sequenceMethod.get(), chatModel);
        }
        Optional<Method> loopMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, LoopAgent.class);
        if (loopMethod.isPresent()) {
            return AgenticServices.buildLoopAgent(agentServiceClass, loopMethod.get(), chatModel);
        }
        Optional<Method> conditionalMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, ConditionalAgent.class);
        if (conditionalMethod.isPresent()) {
            return AgenticServices.buildConditionalAgent(agentServiceClass, conditionalMethod.get(), chatModel);
        }
        Optional<Method> parallelMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, ParallelAgent.class);
        if (parallelMethod.isPresent()) {
            return AgenticServices.buildParallelAgent(agentServiceClass, parallelMethod.get(), chatModel);
        }
        Optional<Method> supervisorMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, SupervisorAgent.class);
        if (supervisorMethod.isPresent()) {
            return AgenticServices.buildSupervisorAgent(agentServiceClass, supervisorMethod.get(), chatModel);
        }
        return null;
    }

    private static <T> T buildSequentialAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel) {
        SequenceAgent sequenceAgent = agentMethod.getAnnotation(SequenceAgent.class);
        SequentialAgentService builder = (SequentialAgentService)AgenticServices.sequenceBuilder(agentServiceClass).subAgents(AgenticServices.createSubagents(sequenceAgent.subAgents(), chatModel));
        AgenticServices.buildOutput(agentServiceClass, sequenceAgent.outputName(), builder);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        return (T)builder.build();
    }

    private static <T> T buildLoopAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel) {
        LoopAgent loopAgent = agentMethod.getAnnotation(LoopAgent.class);
        LoopAgentService builder = ((LoopAgentService)AgenticServices.loopBuilder(agentServiceClass).subAgents(AgenticServices.createSubagents(loopAgent.subAgents(), chatModel))).maxIterations(loopAgent.maxIterations());
        AgenticServices.buildOutput(agentServiceClass, loopAgent.outputName(), builder);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        AgenticServices.predicateMethod(agentServiceClass, method -> method.isAnnotationPresent(ExitCondition.class)).map(AgenticServices::agenticScopePredicate).ifPresent(builder::exitCondition);
        return (T)builder.build();
    }

    private static <T> T buildConditionalAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel) {
        ConditionalAgent conditionalAgent = agentMethod.getAnnotation(ConditionalAgent.class);
        ConditionalAgentService builder = AgenticServices.conditionalBuilder(agentServiceClass);
        AgenticServices.buildOutput(agentServiceClass, conditionalAgent.outputName(), builder);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        for (SubAgent subagent : conditionalAgent.subAgents()) {
            AgenticServices.predicateMethod(agentServiceClass, method -> {
                ActivationCondition activationCondition = method.getAnnotation(ActivationCondition.class);
                return activationCondition != null && Arrays.asList(activationCondition.value()).contains(subagent.type());
            }).map(AgenticServices::agenticScopePredicate).ifPresent(condition -> builder.subAgent((Predicate<AgenticScope>)condition, AgenticServices.createSubagent(subagent, chatModel)));
        }
        return (T)builder.build();
    }

    private static <T> T buildParallelAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel) {
        ParallelAgent parallelAgent = agentMethod.getAnnotation(ParallelAgent.class);
        ParallelAgentService builder = (ParallelAgentService)AgenticServices.parallelBuilder(agentServiceClass).subAgents(AgenticServices.createSubagents(parallelAgent.subAgents(), chatModel));
        AgenticServices.buildOutput(agentServiceClass, parallelAgent.outputName(), builder);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(ExecutorService.class) && method.getReturnType() == java.util.concurrent.ExecutorService.class && method.getParameterCount() == 0).map(method -> {
            try {
                return (java.util.concurrent.ExecutorService)method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking executor method: " + method.getName(), e);
            }
        }).ifPresent(builder::executorService);
        return (T)builder.build();
    }

    private static <T> T buildSupervisorAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel) {
        SupervisorAgent supervisorAgent = agentMethod.getAnnotation(SupervisorAgent.class);
        SupervisorAgentService builder = AgenticServices.supervisorBuilder(agentServiceClass).maxAgentsInvocations(supervisorAgent.maxAgentsInvocations()).contextGenerationStrategy(supervisorAgent.contextStrategy()).responseStrategy(supervisorAgent.responseStrategy()).subAgents(AgenticServices.createSubagents(supervisorAgent.subAgents(), chatModel));
        if (!supervisorAgent.outputName().isBlank()) {
            builder.outputName(supervisorAgent.outputName());
        }
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(SupervisorRequest.class) && method.getReturnType() == String.class).map(m -> AgenticServices.agenticScopeFunction(m, String.class)).ifPresent(builder::requestGenerator);
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(SupervisorChatModel.class) && method.getReturnType() == ChatModel.class && method.getParameterCount() == 0).map(method -> {
            try {
                return (ChatModel)method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking executor method: " + method.getName(), e);
            }
        }).ifPresentOrElse(builder::chatModel, () -> builder.chatModel(chatModel));
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        return builder.build();
    }

    private static <T> void buildOutput(Class<T> agentServiceClass, String outputName, WorkflowService<?, ?> builder) {
        if (!outputName.isBlank()) {
            builder.outputName(outputName);
        }
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(Output.class)).map(m -> AgenticServices.agenticScopeFunction(m, Object.class)).ifPresent(builder::output);
    }

    private static <T> Optional<Function<ErrorContext, ErrorRecoveryResult>> buildErrorHandler(Class<T> agentServiceClass) {
        return AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(ErrorHandler.class)).map(m -> errorContext -> {
            try {
                return (ErrorRecoveryResult)m.invoke(null, errorContext);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Optional<Method> predicateMethod(Class<?> agentServiceClass, Predicate<Method> methodSelector) {
        return AgenticServices.selectMethod(agentServiceClass, methodSelector.and(m -> m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class));
    }

    private static Optional<Method> selectMethod(Class<?> agentServiceClass, Predicate<Method> methodSelector) {
        for (Method method : agentServiceClass.getDeclaredMethods()) {
            if (!methodSelector.test(method) || !Modifier.isStatic(method.getModifiers())) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    private static Predicate<AgenticScope> agenticScopePredicate(Method predicateMethod) {
        return agenticScope -> AgenticServices.agenticScopeFunction(predicateMethod, Boolean.TYPE).apply((AgenticScope)agenticScope);
    }

    private static <T> Function<AgenticScope, T> agenticScopeFunction(Method functionMethod, Class<T> targetClass) {
        boolean isAgenticScopeArg = functionMethod.getParameterCount() == 1 && functionMethod.getParameterTypes()[0] == AgenticScope.class;
        return agenticScope -> {
            try {
                Object[] objectArray;
                if (isAgenticScopeArg) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = agenticScope;
                } else {
                    objectArray = AgentUtil.methodInvocationArguments(agenticScope, functionMethod);
                }
                Object[] args = objectArray;
                return functionMethod.invoke(null, args);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking exit condition method: " + functionMethod.getName(), e);
            }
        };
    }

    private static List<AgentExecutor> createSubagents(SubAgent[] subAgents, ChatModel chatModel) {
        return Stream.of(subAgents).map(subagent -> AgenticServices.createSubagent(subagent, chatModel)).toList();
    }

    private static AgentExecutor createSubagent(SubAgent subagent, ChatModel chatModel) {
        AgentExecutor agentExecutor = AgenticServices.createComposedAgentExecutor(subagent.type(), chatModel);
        if (agentExecutor != null) {
            return agentExecutor;
        }
        return AgentUtil.agentToExecutor((AgentSpecification)AgenticServices.agentBuilder(subagent.type()).chatModel(chatModel).outputName(subagent.outputName()).build());
    }

    private static AgentExecutor createComposedAgentExecutor(Class<?> agentServiceClass, ChatModel chatModel) {
        Optional<Method> sequenceMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, SequenceAgent.class);
        if (sequenceMethod.isPresent()) {
            Method method = sequenceMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildSequentialAgent(agentServiceClass, method, chatModel);
            SequenceAgent annotation = method.getAnnotation(SequenceAgent.class);
            String name = annotation == null || Utils.isNullOrBlank((String)annotation.name()) ? method.getName() : annotation.name();
            String description = annotation == null ? "" : String.join((CharSequence)"\n", annotation.description());
            return new AgentExecutor(AgentInvoker.fromMethodAndSpec(method, name, description, agent.outputName()), agent);
        }
        Optional<Method> loopMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, LoopAgent.class);
        if (loopMethod.isPresent()) {
            Method method = loopMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildLoopAgent(agentServiceClass, loopMethod.get(), chatModel);
            LoopAgent annotation = method.getAnnotation(LoopAgent.class);
            String name = annotation == null || Utils.isNullOrBlank((String)annotation.name()) ? method.getName() : annotation.name();
            String description = annotation == null ? "" : String.join((CharSequence)"\n", annotation.description());
            return new AgentExecutor(AgentInvoker.fromMethodAndSpec(method, name, description, agent.outputName()), agent);
        }
        Optional<Method> conditionalMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, ConditionalAgent.class);
        if (conditionalMethod.isPresent()) {
            Method method = conditionalMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildConditionalAgent(agentServiceClass, conditionalMethod.get(), chatModel);
            ConditionalAgent annotation = method.getAnnotation(ConditionalAgent.class);
            String name = annotation == null || Utils.isNullOrBlank((String)annotation.name()) ? method.getName() : annotation.name();
            String description = annotation == null ? "" : String.join((CharSequence)"\n", annotation.description());
            return new AgentExecutor(AgentInvoker.fromMethodAndSpec(method, name, description, agent.outputName()), agent);
        }
        Optional<Method> parallelMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, ParallelAgent.class);
        if (parallelMethod.isPresent()) {
            Method method = parallelMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildConditionalAgent(agentServiceClass, parallelMethod.get(), chatModel);
            ParallelAgent annotation = method.getAnnotation(ParallelAgent.class);
            String name = annotation == null || Utils.isNullOrBlank((String)annotation.name()) ? method.getName() : annotation.name();
            String description = annotation == null ? "" : String.join((CharSequence)"\n", annotation.description());
            return new AgentExecutor(AgentInvoker.fromMethodAndSpec(method, name, description, agent.outputName()), agent);
        }
        Optional<Method> supervisorMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, SupervisorAgent.class);
        if (supervisorMethod.isPresent()) {
            Method method = supervisorMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildSupervisorAgent(agentServiceClass, supervisorMethod.get(), chatModel);
            SupervisorAgent annotation = method.getAnnotation(SupervisorAgent.class);
            String name = annotation == null || Utils.isNullOrBlank((String)annotation.name()) ? method.getName() : annotation.name();
            String description = annotation == null ? "" : String.join((CharSequence)"\n", annotation.description());
            return new AgentExecutor(AgentInvoker.fromMethodAndSpec(method, name, description, agent.outputName()), agent);
        }
        return null;
    }

    private static enum WorkflowBuilderProvider {
        INSTANCE;

        private WorkflowAgentsBuilder workflowAgentsBuilder;

        private WorkflowBuilderProvider() {
            this.internalSetWorkflowAgentsBuilder(WorkflowBuilderProvider.loadWorkflowAgentsBuilder());
        }

        private static WorkflowAgentsBuilder loadWorkflowAgentsBuilder() {
            ServiceLoader<WorkflowAgentsBuilder> loader = ServiceLoader.load(WorkflowAgentsBuilder.class);
            Iterator<WorkflowAgentsBuilder> iterator = loader.iterator();
            if (iterator.hasNext()) {
                WorkflowAgentsBuilder builder = iterator.next();
                return builder;
            }
            return WorkflowAgentsBuilderImpl.INSTANCE;
        }

        private void internalSetWorkflowAgentsBuilder(WorkflowAgentsBuilder workflowAgentsBuilder) {
            this.workflowAgentsBuilder = workflowAgentsBuilder;
        }
    }
}

