/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.agent.AgentInvocationException;
import dev.langchain4j.agentic.agent.AgentRequest;
import dev.langchain4j.agentic.agent.AgentResponse;
import dev.langchain4j.agentic.agent.MissingArgumentException;
import dev.langchain4j.agentic.internal.AgentInvocationArguments;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.MethodAgentInvoker;
import dev.langchain4j.agentic.internal.UntypedAgentInvoker;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.service.V;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AgentInvoker
extends AgentSpecification {
    public static final Logger LOG = LoggerFactory.getLogger(AgentInvoker.class);

    public Method method();

    public String toCard();

    public AgentInvocationArguments toInvocationArguments(AgenticScope var1) throws MissingArgumentException;

    default public Object invoke(AgenticScope agenticScope, Object agent, AgentInvocationArguments args) throws AgentInvocationException {
        try {
            this.beforeInvocation(new AgentRequest(agenticScope, this.name(), args.namedArgs()));
        }
        catch (Exception e) {
            LOG.error("Before agent invocation listener for agent " + this.name() + " failed: " + e.getMessage(), (Throwable)e);
        }
        Object result = this.internalInvoke(agent, args);
        try {
            this.afterInvocation(new AgentResponse(agenticScope, this.name(), args.namedArgs(), result));
        }
        catch (Exception e) {
            LOG.error("After agent invocation listener for agent " + this.name() + " failed: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Object internalInvoke(Object agent, AgentInvocationArguments args) {
        try {
            return this.method().invoke(agent, args.positionalArgs());
        }
        catch (Exception e) {
            throw new AgentInvocationException("Failed to invoke agent method: " + String.valueOf(this.method()), e);
        }
    }

    public static AgentInvoker fromMethod(AgentSpecification spec, Method method) {
        if (method.getDeclaringClass() == UntypedAgent.class) {
            return new UntypedAgentInvoker(method, spec);
        }
        return new MethodAgentInvoker(method, spec, AgentUtil.argumentsFromMethod(method));
    }

    public static String parameterName(Parameter parameter) {
        return AgentInvoker.optionalParameterName(parameter).orElseThrow(() -> new IllegalArgumentException("Parameter name not specified and no @P or @V annotation present: " + String.valueOf(parameter)));
    }

    public static Optional<String> optionalParameterName(Parameter parameter) {
        P p = parameter.getAnnotation(P.class);
        if (p != null) {
            return Optional.of(p.value());
        }
        V v = parameter.getAnnotation(V.class);
        if (v != null) {
            return Optional.of(v.value());
        }
        return parameter.isNamePresent() ? Optional.of(parameter.getName()) : Optional.empty();
    }
}

