/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.agent.AgentRequest;
import dev.langchain4j.agentic.agent.AgentResponse;
import dev.langchain4j.agentic.agent.ErrorContext;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.internal.AbstractService;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.scope.AgenticScopeAccess;
import dev.langchain4j.agentic.scope.AgenticScopeRegistry;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.agentic.scope.ResultWithAgenticScope;
import dev.langchain4j.service.MemoryId;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class AbstractAgentInvocationHandler
implements InvocationHandler {
    protected final String name;
    protected final String uniqueName;
    protected final String description;
    protected final String outputName;
    protected final Consumer<AgentRequest> beforeListener;
    protected final Consumer<AgentResponse> afterListener;
    private final Class<?> agentServiceClass;
    private final Consumer<AgenticScope> beforeCall;
    private final DefaultAgenticScope agenticScope;
    private final Function<ErrorContext, ErrorRecoveryResult> errorHandler;
    private final AtomicReference<AgenticScopeRegistry> agenticScopeRegistry = new AtomicReference();

    protected AbstractAgentInvocationHandler(AbstractService<?, ?> workflowService) {
        this(workflowService, null);
    }

    protected AbstractAgentInvocationHandler(AbstractService<?, ?> service, DefaultAgenticScope agenticScope) {
        this.agentServiceClass = service.agentServiceClass;
        this.name = service.name;
        this.uniqueName = AgentUtil.uniqueAgentName(this.name);
        this.description = service.description;
        this.outputName = service.outputName;
        this.beforeCall = service.beforeCall;
        this.errorHandler = service.errorHandler;
        this.beforeListener = service.beforeListener;
        this.afterListener = service.afterListener;
        this.agenticScope = agenticScope;
    }

    public AgenticScopeOwner withAgenticScope(DefaultAgenticScope agenticScope) {
        return (AgenticScopeOwner)Proxy.newProxyInstance(this.agentServiceClass.getClassLoader(), new Class[]{this.agentServiceClass, AgentSpecification.class, AgenticScopeOwner.class}, this.createSubAgentWithAgenticScope(agenticScope));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        AgenticScopeRegistry registry = this.agenticScopeRegistry();
        if (method.getDeclaringClass() == AgenticScopeOwner.class) {
            return switch (method.getName()) {
                case "withAgenticScope" -> this.withAgenticScope((DefaultAgenticScope)args[0]);
                case "registry" -> registry;
                default -> throw new UnsupportedOperationException("Unknown method on AgenticScopeOwner class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == AgenticScopeAccess.class) {
            return switch (method.getName()) {
                case "getAgenticScope" -> registry.get(args[0]);
                case "evictAgenticScope" -> registry.evict(args[0]);
                default -> throw new UnsupportedOperationException("Unknown method on AgenticScopeAccess class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == AgentSpecification.class) {
            return switch (method.getName()) {
                case "name" -> this.name;
                case "uniqueName" -> this.uniqueName;
                case "description" -> this.description;
                case "outputName" -> this.outputName;
                case "async" -> false;
                case "beforeInvocation" -> {
                    this.beforeListener.accept((AgentRequest)args[0]);
                    yield null;
                }
                case "afterInvocation" -> {
                    this.afterListener.accept((AgentResponse)args[0]);
                    yield null;
                }
                default -> throw new UnsupportedOperationException("Unknown method on AgentInstance class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == ChatMemoryAccess.class) {
            return this.accessChatMemory(method.getName(), args[0]);
        }
        return this.executeAgentMethod(this.currentAgenticScope(registry, method, args), registry, method, args);
    }

    private AgenticScopeRegistry agenticScopeRegistry() {
        if (this.isRootCall()) {
            this.agenticScopeRegistry.compareAndSet(null, new AgenticScopeRegistry(this.agentServiceClass.getName()));
        }
        return this.agenticScopeRegistry.get();
    }

    private Object executeAgentMethod(DefaultAgenticScope agenticScope, AgenticScopeRegistry registry, Method method, Object[] args) {
        AbstractAgentInvocationHandler.writeAgenticScope(agenticScope, method, args);
        this.beforeCall.accept(agenticScope);
        if (this.isRootCall()) {
            agenticScope.rootCallStarted(registry);
        }
        Object result = this.doAgentAction(agenticScope);
        if (this.isRootCall()) {
            agenticScope.rootCallEnded(registry);
        }
        Object output = this.outputName != null ? agenticScope.readState(this.outputName) : result;
        return method.getReturnType().equals(ResultWithAgenticScope.class) ? new ResultWithAgenticScope<Object>(agenticScope, output) : output;
    }

    private boolean isRootCall() {
        return this.agenticScope == null;
    }

    private static void writeAgenticScope(DefaultAgenticScope agenticScope, Method method, Object[] args) {
        if (method.getDeclaringClass() == UntypedAgent.class) {
            agenticScope.writeStates((Map)args[0]);
        } else {
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                int index = i;
                AgentInvoker.optionalParameterName(parameters[i]).ifPresent(argName -> agenticScope.writeState((String)argName, args[index]));
            }
        }
    }

    private DefaultAgenticScope currentAgenticScope(AgenticScopeRegistry registry, Method method, Object[] args) {
        if (this.agenticScope != null) {
            return this.agenticScope;
        }
        Object memoryId = this.memoryId(method, args);
        DefaultAgenticScope newAgenticScope = memoryId != null ? registry.getOrCreate(memoryId) : registry.createEphemeralAgenticScope();
        return newAgenticScope.withErrorHandler(this.errorHandler);
    }

    private Object memoryId(Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getAnnotation(MemoryId.class) == null) continue;
            return args[i];
        }
        return null;
    }

    protected Object result(DefaultAgenticScope agenticScope, Object result) {
        if (this.outputName != null) {
            if (result != null) {
                agenticScope.writeState(this.outputName, result);
                return result;
            }
            return agenticScope.readState(this.outputName);
        }
        return result;
    }

    protected Object accessChatMemory(String methodName, Object memoryId) {
        throw new UnsupportedOperationException();
    }

    protected abstract Object doAgentAction(DefaultAgenticScope var1);

    protected abstract InvocationHandler createSubAgentWithAgenticScope(DefaultAgenticScope var1);
}

