/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.scope;

import dev.langchain4j.Internal;
import dev.langchain4j.agentic.agent.AgentInvocationException;
import dev.langchain4j.agentic.agent.ChatMessagesAccess;
import dev.langchain4j.agentic.agent.ErrorContext;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.declarative.TypedKey;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.AsyncResponse;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.scope.AgentInvocation;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.scope.AgenticScopeRegistry;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultAgenticScope
implements AgenticScope {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAgenticScope.class);
    private final Object memoryId;
    private final Map<String, Object> state = new ConcurrentHashMap<String, Object>();
    private final List<AgentInvocation> agentInvocations = Collections.synchronizedList(new ArrayList());
    private final List<AgentMessage> context = Collections.synchronizedList(new ArrayList());
    private final transient Map<String, Object> agents = new ConcurrentHashMap<String, Object>();
    private static final Function<ErrorContext, ErrorRecoveryResult> DEFAULT_ERROR_RECOVERY = errorContext -> ErrorRecoveryResult.throwException();
    private transient Function<ErrorContext, ErrorRecoveryResult> errorHandler = DEFAULT_ERROR_RECOVERY;
    private final Kind kind;
    private final transient ReadWriteLock lock;

    DefaultAgenticScope(Kind kind) {
        this(Utils.randomUUID(), kind);
    }

    DefaultAgenticScope(Object memoryId, Kind kind) {
        this.memoryId = memoryId;
        this.kind = kind;
        this.lock = kind == Kind.PERSISTENT ? new ReentrantReadWriteLock() : null;
    }

    @Override
    public Object memoryId() {
        return this.memoryId;
    }

    @Override
    public void writeState(String key, Object value) {
        this.withReadLock(() -> {
            if (value == null) {
                this.state.remove(key);
            } else {
                this.state.put(key, value);
            }
        });
    }

    @Override
    public <T> void writeState(Class<? extends TypedKey<T>> key, T value) {
        this.writeState(AgentUtil.keyName(key), value);
    }

    @Override
    public void writeStates(Map<String, Object> newState) {
        this.withReadLock(() -> this.state.putAll(newState));
    }

    @Override
    public boolean hasState(String key) {
        String s;
        Object value = this.state.get(key);
        if (value == null) {
            return false;
        }
        return value instanceof String ? !(s = (String)value).isBlank() : true;
    }

    @Override
    public boolean hasState(Class<? extends TypedKey<?>> key) {
        return this.hasState(AgentUtil.keyName(key));
    }

    @Override
    public Object readState(String key) {
        return this.readStateBlocking(key, this.state.get(key));
    }

    @Override
    public <T> T readState(String key, T defaultValue) {
        return (T)this.readStateBlocking(key, this.state.getOrDefault(key, defaultValue));
    }

    @Override
    public <T> T readState(Class<? extends TypedKey<T>> key) {
        return this.readState(AgentUtil.keyName(key), AgentUtil.keyDefaultValue(key));
    }

    private Object readStateBlocking(String key, Object state) {
        if (state instanceof AsyncResponse) {
            AsyncResponse asyncResponse = (AsyncResponse)state;
            state = asyncResponse.blockingGet();
            this.writeState(key, state);
        }
        return state;
    }

    @Override
    public Map<String, Object> state() {
        return this.state;
    }

    public <T> T getOrCreateAgent(String agentId, Function<DefaultAgenticScope, T> agentFactory) {
        return (T)this.agents.computeIfAbsent(agentId, id -> agentFactory.apply(this));
    }

    public void registerAgentInvocation(AgentInvocation agentInvocation, Object agent) {
        this.withReadLock(() -> {
            this.agentInvocations.add(agentInvocation);
            this.registerContext(agentInvocation, agent);
        });
    }

    public void rootCallStarted(AgenticScopeRegistry registry) {
    }

    public void rootCallEnded(AgenticScopeRegistry registry) {
        this.state.replaceAll(this::readStateBlocking);
        if (this.kind == Kind.EPHEMERAL) {
            registry.evict(this.memoryId);
        } else if (this.kind == Kind.PERSISTENT) {
            this.flush(registry);
        }
    }

    private void flush(AgenticScopeRegistry registry) {
        this.lock.writeLock().lock();
        try {
            registry.update(this);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void registerContext(AgentInvocation agentInvocation, Object agent) {
        ChatMemory chatMemory;
        if (agent instanceof ChatMemoryAccess) {
            ChatMemoryAccess agentWithMemory = (ChatMemoryAccess)agent;
            v0 = agentWithMemory.getChatMemory(this.memoryId);
        } else {
            v0 = chatMemory = null;
        }
        if (chatMemory != null) {
            this.registerContextFromChatMemory(agentInvocation, chatMemory);
        } else if (agentInvocation.output() != null && agent instanceof ChatMessagesAccess) {
            ChatMessagesAccess chatMessagesAccess = (ChatMessagesAccess)agent;
            this.context.add(new AgentMessage(agentInvocation.agentName(), agentInvocation.agentId(), (ChatMessage)chatMessagesAccess.lastUserMessage()));
            this.context.add(new AgentMessage(agentInvocation.agentName(), agentInvocation.agentId(), (ChatMessage)AiMessage.aiMessage((String)agentInvocation.output().toString())));
        }
    }

    private void registerContextFromChatMemory(AgentInvocation agentInvocation, ChatMemory chatMemory) {
        List agentMessages = chatMemory.messages();
        if (Utils.isNullOrEmpty((Collection)agentMessages)) {
            return;
        }
        ChatMessage lastMessage = (ChatMessage)agentMessages.get(agentMessages.size() - 1);
        if (!(lastMessage instanceof AiMessage)) {
            return;
        }
        AiMessage aiMessage = (AiMessage)lastMessage;
        for (int i = agentMessages.size() - 1; i >= 0; --i) {
            Object e = agentMessages.get(i);
            if (!(e instanceof UserMessage)) continue;
            UserMessage userMessage = (UserMessage)e;
            this.context.add(new AgentMessage(agentInvocation.agentName(), agentInvocation.agentId(), (ChatMessage)userMessage));
            this.context.add(new AgentMessage(agentInvocation.agentName(), agentInvocation.agentId(), (ChatMessage)aiMessage));
            return;
        }
    }

    public List<AgentMessage> context() {
        return this.context;
    }

    @Override
    public String contextAsConversation(Object ... agents) {
        Predicate<String> agentFilter = agents != null && agents.length > 0 ? Arrays.stream(agents).filter(AgentSpecification.class::isInstance).map(AgentSpecification.class::cast).map(AgentInstance::name).toList()::contains : agent -> true;
        return this.contextAsConversation(agentFilter);
    }

    @Override
    public String contextAsConversation(String ... agentNames) {
        Predicate<String> agentFilter = agentNames != null && agentNames.length > 0 ? List.of(agentNames)::contains : agent -> true;
        return this.contextAsConversation(agentFilter);
    }

    private String contextAsConversation(Predicate<String> agentFilter) {
        StringBuilder sb = new StringBuilder();
        for (AgentMessage agentMessage : this.context) {
            if (!agentFilter.test(agentMessage.agentName())) continue;
            ChatMessage message = agentMessage.message();
            if (message instanceof UserMessage) {
                UserMessage userMessage = (UserMessage)message;
                sb.append("User: \"").append(userMessage.singleText()).append("\"\n");
                continue;
            }
            if (!(message instanceof AiMessage)) continue;
            AiMessage aiMessage = (AiMessage)message;
            sb.append(agentMessage.agentName()).append(" agent: \"").append(aiMessage.text()).append("\"\n");
        }
        String contextAsConversation = sb.toString();
        LOG.trace("AgenticScope context as conversation: '{}'", (Object)contextAsConversation);
        return contextAsConversation;
    }

    @Override
    public List<AgentInvocation> agentInvocations() {
        return this.agentInvocations;
    }

    @Override
    public List<AgentInvocation> agentInvocations(String agentName) {
        return this.agentInvocations.stream().filter(inv -> inv.agentName().equals(agentName)).toList();
    }

    @Override
    public List<AgentInvocation> agentInvocations(Class<?> agentType) {
        return this.agentInvocations.stream().filter(inv -> inv.agentType().equals(agentType)).toList();
    }

    public String toString() {
        return "AgenticScope{memoryId='" + String.valueOf(this.memoryId) + "', state=" + String.valueOf(this.state) + "}";
    }

    private void withReadLock(Runnable action) {
        if (this.kind == Kind.PERSISTENT) {
            this.lock.readLock().lock();
            try {
                action.run();
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            action.run();
        }
    }

    public DefaultAgenticScope withErrorHandler(Function<ErrorContext, ErrorRecoveryResult> errorHandler) {
        if (errorHandler != null) {
            this.errorHandler = errorHandler;
        }
        return this;
    }

    public ErrorRecoveryResult handleError(String agentName, AgentInvocationException exception) {
        return this.errorHandler.apply(new ErrorContext(agentName, this, exception));
    }

    public static enum Kind {
        EPHEMERAL,
        REGISTERED,
        PERSISTENT;

    }

    public record AgentMessage(String agentName, String agentId, ChatMessage message) {
    }
}

