/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic;

import dev.langchain4j.agentic.Agent;
import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.agent.AgentBuilder;
import dev.langchain4j.agentic.agent.AgentRequest;
import dev.langchain4j.agentic.agent.AgentResponse;
import dev.langchain4j.agentic.agent.ErrorContext;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.declarative.A2AClientAgent;
import dev.langchain4j.agentic.declarative.ActivationCondition;
import dev.langchain4j.agentic.declarative.AfterAgentInvocation;
import dev.langchain4j.agentic.declarative.BeforeAgentInvocation;
import dev.langchain4j.agentic.declarative.ChatMemoryProviderSupplier;
import dev.langchain4j.agentic.declarative.ChatModelSupplier;
import dev.langchain4j.agentic.declarative.ConditionalAgent;
import dev.langchain4j.agentic.declarative.DeclarativeUtil;
import dev.langchain4j.agentic.declarative.ErrorHandler;
import dev.langchain4j.agentic.declarative.ExitCondition;
import dev.langchain4j.agentic.declarative.HumanInTheLoop;
import dev.langchain4j.agentic.declarative.HumanInTheLoopResponseSupplier;
import dev.langchain4j.agentic.declarative.LoopAgent;
import dev.langchain4j.agentic.declarative.Output;
import dev.langchain4j.agentic.declarative.ParallelAgent;
import dev.langchain4j.agentic.declarative.ParallelExecutor;
import dev.langchain4j.agentic.declarative.PlannerAgent;
import dev.langchain4j.agentic.declarative.PlannerSupplier;
import dev.langchain4j.agentic.declarative.SequenceAgent;
import dev.langchain4j.agentic.declarative.SupervisorAgent;
import dev.langchain4j.agentic.declarative.SupervisorRequest;
import dev.langchain4j.agentic.internal.A2AClientBuilder;
import dev.langchain4j.agentic.internal.A2AService;
import dev.langchain4j.agentic.internal.AbstractServiceBuilder;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentSpecification;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.planner.AgentArgument;
import dev.langchain4j.agentic.planner.AgenticService;
import dev.langchain4j.agentic.planner.Planner;
import dev.langchain4j.agentic.planner.PlannerBasedService;
import dev.langchain4j.agentic.planner.PlannerBasedServiceImpl;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.supervisor.SupervisorAgentService;
import dev.langchain4j.agentic.supervisor.SupervisorAgentServiceImpl;
import dev.langchain4j.agentic.workflow.ConditionalAgentService;
import dev.langchain4j.agentic.workflow.HumanInTheLoop;
import dev.langchain4j.agentic.workflow.LoopAgentService;
import dev.langchain4j.agentic.workflow.ParallelAgentService;
import dev.langchain4j.agentic.workflow.SequentialAgentService;
import dev.langchain4j.agentic.workflow.WorkflowAgentsBuilder;
import dev.langchain4j.agentic.workflow.impl.ConditionalAgentServiceImpl;
import dev.langchain4j.agentic.workflow.impl.LoopAgentServiceImpl;
import dev.langchain4j.agentic.workflow.impl.ParallelAgentServiceImpl;
import dev.langchain4j.agentic.workflow.impl.SequentialAgentServiceImpl;
import dev.langchain4j.agentic.workflow.impl.WorkflowAgentsBuilderImpl;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AgenticServices {
    private AgenticServices() {
    }

    public static void setWorkflowAgentsBuilder(WorkflowAgentsBuilder workflowAgentsBuilder) {
        WorkflowBuilderProvider.INSTANCE.internalSetWorkflowAgentsBuilder(workflowAgentsBuilder);
    }

    private static WorkflowAgentsBuilder workflowAgentsBuilder() {
        return WorkflowBuilderProvider.INSTANCE.workflowAgentsBuilder;
    }

    public static <T> AgentBuilder<T> agentBuilder(Class<T> agentServiceClass) {
        return new AgentBuilder<T>(agentServiceClass, AgentUtil.validateAgentClass(agentServiceClass));
    }

    public static HumanInTheLoop.HumanInTheLoopBuilder humanInTheLoopBuilder() {
        return new HumanInTheLoop.HumanInTheLoopBuilder();
    }

    public static SequentialAgentService<UntypedAgent> sequenceBuilder() {
        return AgenticServices.workflowAgentsBuilder().sequenceBuilder();
    }

    public static <T> SequentialAgentService<T> sequenceBuilder(Class<T> agentServiceClass) {
        return AgenticServices.workflowAgentsBuilder().sequenceBuilder(agentServiceClass);
    }

    public static ParallelAgentService<UntypedAgent> parallelBuilder() {
        return AgenticServices.workflowAgentsBuilder().parallelBuilder();
    }

    public static <T> ParallelAgentService<T> parallelBuilder(Class<T> agentServiceClass) {
        return AgenticServices.workflowAgentsBuilder().parallelBuilder(agentServiceClass);
    }

    public static LoopAgentService<UntypedAgent> loopBuilder() {
        return AgenticServices.workflowAgentsBuilder().loopBuilder();
    }

    public static <T> LoopAgentService<T> loopBuilder(Class<T> agentServiceClass) {
        return AgenticServices.workflowAgentsBuilder().loopBuilder(agentServiceClass);
    }

    public static ConditionalAgentService<UntypedAgent> conditionalBuilder() {
        return AgenticServices.workflowAgentsBuilder().conditionalBuilder();
    }

    public static <T> ConditionalAgentService<T> conditionalBuilder(Class<T> agentServiceClass) {
        return AgenticServices.workflowAgentsBuilder().conditionalBuilder(agentServiceClass);
    }

    public static SupervisorAgentService<dev.langchain4j.agentic.supervisor.SupervisorAgent> supervisorBuilder() {
        return SupervisorAgentServiceImpl.builder();
    }

    public static <T> SupervisorAgentService<T> supervisorBuilder(Class<T> agentServiceClass) {
        return SupervisorAgentServiceImpl.builder(agentServiceClass);
    }

    public static PlannerBasedService<UntypedAgent> plannerBuilder() {
        return PlannerBasedServiceImpl.builder(UntypedAgent.class);
    }

    public static <T> PlannerBasedService<T> plannerBuilder(Class<T> agentServiceClass) {
        return PlannerBasedServiceImpl.builder(agentServiceClass);
    }

    public static A2AClientBuilder<UntypedAgent> a2aBuilder(String a2aServerUrl) {
        return AgenticServices.a2aBuilder(a2aServerUrl, UntypedAgent.class);
    }

    public static <T> A2AClientBuilder<T> a2aBuilder(String a2aServerUrl, Class<T> agentServiceClass) {
        return A2AService.get().a2aBuilder(a2aServerUrl, agentServiceClass);
    }

    public static <T> T createAgenticSystem(Class<T> agentServiceClass) {
        return AgenticServices.createAgenticSystem(agentServiceClass, AgenticServices.declarativeChatModel(agentServiceClass));
    }

    public static <T> T createAgenticSystem(Class<T> agentServiceClass, ChatModel chatModel) {
        return AgenticServices.createAgenticSystem(agentServiceClass, chatModel, ctx -> {});
    }

    public static <T> T createAgenticSystem(Class<T> agentServiceClass, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        return AgenticServices.createAgenticSystem(agentServiceClass, AgenticServices.declarativeChatModel(agentServiceClass), agentConfigurator);
    }

    public static <T> T createAgenticSystem(Class<T> agentServiceClass, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        T agent = AgenticServices.createComposedAgent(agentServiceClass, chatModel, agentConfigurator);
        if (agent == null) {
            AgentBuilder<T> agentBuilder = AgenticServices.agentBuilder(agentServiceClass);
            DeclarativeUtil.configureAgent(agentServiceClass, chatModel, agentBuilder, agentConfigurator);
            agent = agentBuilder.build();
        }
        if (agent == null) {
            throw new IllegalArgumentException("Provided class " + agentServiceClass.getName() + " is not an agent.");
        }
        return agent;
    }

    private static <T> ChatModel declarativeChatModel(Class<T> agentServiceClass) {
        return AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(ChatModelSupplier.class) && method.getReturnType() == ChatModel.class && method.getParameterCount() == 0).map(method -> (ChatModel)DeclarativeUtil.invokeStatic(method, new Object[0])).orElse(null);
    }

    private static <T> T createComposedAgent(Class<T> agentServiceClass, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        Optional<Method> sequenceMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, SequenceAgent.class);
        if (sequenceMethod.isPresent()) {
            return AgenticServices.buildSequentialAgent(agentServiceClass, sequenceMethod.get(), chatModel, agentConfigurator);
        }
        Optional<Method> loopMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, LoopAgent.class);
        if (loopMethod.isPresent()) {
            return AgenticServices.buildLoopAgent(agentServiceClass, loopMethod.get(), chatModel, agentConfigurator);
        }
        Optional<Method> conditionalMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, ConditionalAgent.class);
        if (conditionalMethod.isPresent()) {
            return AgenticServices.buildConditionalAgent(agentServiceClass, conditionalMethod.get(), chatModel, agentConfigurator);
        }
        Optional<Method> parallelMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, ParallelAgent.class);
        if (parallelMethod.isPresent()) {
            return AgenticServices.buildParallelAgent(agentServiceClass, parallelMethod.get(), chatModel, agentConfigurator);
        }
        Optional<Method> supervisorMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, SupervisorAgent.class);
        if (supervisorMethod.isPresent()) {
            return AgenticServices.buildSupervisorAgent(agentServiceClass, supervisorMethod.get(), chatModel, agentConfigurator);
        }
        Optional<Method> plannerMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, PlannerAgent.class);
        if (plannerMethod.isPresent()) {
            return AgenticServices.buildPlannerAgent(agentServiceClass, plannerMethod.get(), chatModel, agentConfigurator);
        }
        return null;
    }

    private static <T> T buildSequentialAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        SequenceAgent sequenceAgent = agentMethod.getAnnotation(SequenceAgent.class);
        SequentialAgentService builder = (SequentialAgentService)new SequentialAgentServiceImpl<T>(agentServiceClass, agentMethod).subAgents(AgenticServices.createSubagents(sequenceAgent.subAgents(), chatModel, agentConfigurator));
        AgenticServices.buildAgentSpecs(agentServiceClass, agentMethod, sequenceAgent.name(), sequenceAgent.description(), AgentUtil.outputKey(sequenceAgent.outputKey(), sequenceAgent.typedOutputKey()), builder);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        AgenticServices.buildInvocationHandler(agentServiceClass).ifPresent(builder::beforeAgentInvocation);
        AgenticServices.buildCompletionHandler(agentServiceClass).ifPresent(builder::afterAgentInvocation);
        return (T)builder.build();
    }

    private static <T> T buildLoopAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        LoopAgent loopAgent = agentMethod.getAnnotation(LoopAgent.class);
        LoopAgentService builder = ((LoopAgentService)new LoopAgentServiceImpl<T>(agentServiceClass, agentMethod).subAgents(AgenticServices.createSubagents(loopAgent.subAgents(), chatModel, agentConfigurator))).maxIterations(loopAgent.maxIterations());
        AgenticServices.buildAgentSpecs(agentServiceClass, agentMethod, loopAgent.name(), loopAgent.description(), AgentUtil.outputKey(loopAgent.outputKey(), loopAgent.typedOutputKey()), builder);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        AgenticServices.buildInvocationHandler(agentServiceClass).ifPresent(builder::beforeAgentInvocation);
        AgenticServices.buildCompletionHandler(agentServiceClass).ifPresent(builder::afterAgentInvocation);
        AgenticServices.predicateMethod(agentServiceClass, method -> method.isAnnotationPresent(ExitCondition.class)).map(method -> {
            builder.testExitAtLoopEnd(method.getAnnotation(ExitCondition.class).testExitAtLoopEnd());
            return method;
        }).map(AgenticServices::loopExitConditionPredicate).ifPresent(builder::exitCondition);
        return (T)builder.build();
    }

    private static <T> T buildConditionalAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        ConditionalAgent conditionalAgent = agentMethod.getAnnotation(ConditionalAgent.class);
        ConditionalAgentServiceImpl builder = new ConditionalAgentServiceImpl(agentServiceClass, agentMethod);
        AgenticServices.buildAgentSpecs(agentServiceClass, agentMethod, conditionalAgent.name(), conditionalAgent.description(), AgentUtil.outputKey(conditionalAgent.outputKey(), conditionalAgent.typedOutputKey()), builder);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        AgenticServices.buildInvocationHandler(agentServiceClass).ifPresent(builder::beforeAgentInvocation);
        AgenticServices.buildCompletionHandler(agentServiceClass).ifPresent(builder::afterAgentInvocation);
        for (Class<?> subagent : conditionalAgent.subAgents()) {
            AgenticServices.predicateMethod(agentServiceClass, method -> {
                ActivationCondition activationCondition = method.getAnnotation(ActivationCondition.class);
                return activationCondition != null && Arrays.asList(activationCondition.value()).contains(subagent);
            }).map(AgenticServices::agenticScopePredicate).ifPresent(condition -> builder.subAgent((Predicate)condition, AgenticServices.createSubagent(subagent, chatModel, agentConfigurator)));
        }
        return builder.build();
    }

    private static <T> T buildParallelAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        ParallelAgent parallelAgent = agentMethod.getAnnotation(ParallelAgent.class);
        ParallelAgentService builder = (ParallelAgentService)new ParallelAgentServiceImpl<T>(agentServiceClass, agentMethod).subAgents(AgenticServices.createSubagents(parallelAgent.subAgents(), chatModel, agentConfigurator));
        AgenticServices.buildAgentSpecs(agentServiceClass, agentMethod, parallelAgent.name(), parallelAgent.description(), AgentUtil.outputKey(parallelAgent.outputKey(), parallelAgent.typedOutputKey()), builder);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        AgenticServices.buildInvocationHandler(agentServiceClass).ifPresent(builder::beforeAgentInvocation);
        AgenticServices.buildCompletionHandler(agentServiceClass).ifPresent(builder::afterAgentInvocation);
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(ParallelExecutor.class) && Executor.class.isAssignableFrom(method.getReturnType()) && method.getParameterCount() == 0).map(method -> {
            try {
                return (Executor)method.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking executor method: " + method.getName(), e);
            }
        }).ifPresent(builder::executor);
        return (T)builder.build();
    }

    private static <T> T buildPlannerAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        PlannerAgent plannerAgent = agentMethod.getAnnotation(PlannerAgent.class);
        PlannerBasedService builder = (PlannerBasedService)new PlannerBasedServiceImpl<T>(agentServiceClass, agentMethod).subAgents(AgenticServices.createSubagents(plannerAgent.subAgents(), chatModel, agentConfigurator));
        AgenticServices.buildAgentSpecs(agentServiceClass, agentMethod, plannerAgent.name(), plannerAgent.description(), AgentUtil.outputKey(plannerAgent.outputKey(), plannerAgent.typedOutputKey()), builder);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        AgenticServices.buildInvocationHandler(agentServiceClass).ifPresent(builder::beforeAgentInvocation);
        AgenticServices.buildCompletionHandler(agentServiceClass).ifPresent(builder::afterAgentInvocation);
        AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, PlannerSupplier.class).ifPresentOrElse(method -> {
            DeclarativeUtil.checkReturnType(method, Planner.class);
            builder.planner(() -> (Planner)DeclarativeUtil.invokeStatic(method, new Object[0]));
        }, () -> new IllegalArgumentException("A planner agent requires a method annotated with @PlannerSupplier that returns the Planner instance."));
        return (T)builder.build();
    }

    private static <T> void buildAgentSpecs(Class<T> agentServiceClass, Method agentMethod, String name, String description, String outputKey, AgenticService<?, ?> builder) {
        if (!Utils.isNullOrBlank((String)name)) {
            builder.name(name);
        } else {
            builder.name(agentMethod.getName());
        }
        if (!Utils.isNullOrBlank((String)description)) {
            builder.description(description);
        }
        if (!Utils.isNullOrBlank((String)outputKey)) {
            builder.outputKey(outputKey);
        }
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(Output.class)).map(m -> AgenticServices.agenticScopeFunction(m, Object.class)).ifPresent(builder::output);
    }

    private static <T> T buildSupervisorAgent(Class<T> agentServiceClass, Method agentMethod, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        SupervisorAgent supervisorAgent = agentMethod.getAnnotation(SupervisorAgent.class);
        SupervisorAgentServiceImpl builder = (SupervisorAgentServiceImpl)((AbstractServiceBuilder)((Object)((SupervisorAgentServiceImpl)((SupervisorAgentServiceImpl)new SupervisorAgentServiceImpl<T>(agentServiceClass, agentMethod).maxAgentsInvocations(supervisorAgent.maxAgentsInvocations())).contextGenerationStrategy(supervisorAgent.contextStrategy())).responseStrategy(supervisorAgent.responseStrategy()))).subAgents(AgenticServices.createSubagents(supervisorAgent.subAgents(), chatModel, agentConfigurator));
        if (!Utils.isNullOrBlank((String)supervisorAgent.name())) {
            builder.name(supervisorAgent.name());
        } else {
            builder.name(agentMethod.getName());
        }
        if (!Utils.isNullOrBlank((String)supervisorAgent.description())) {
            builder.description(supervisorAgent.description());
        }
        builder.outputKey(AgentUtil.outputKey(supervisorAgent.outputKey(), supervisorAgent.typedOutputKey()));
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(SupervisorRequest.class) && method.getReturnType() == String.class).map(m -> AgenticServices.agenticScopeFunction(m, String.class)).ifPresent(builder::requestGenerator);
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(ChatModelSupplier.class) && method.getReturnType() == ChatModel.class && method.getParameterCount() == 0).map(method -> (ChatModel)DeclarativeUtil.invokeStatic(method, new Object[0])).ifPresentOrElse(builder::chatModel, () -> builder.chatModel(chatModel));
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(ChatMemoryProviderSupplier.class) && method.getReturnType() == ChatMemory.class && method.getParameterCount() == 1).map(method -> memoryId -> (ChatMemory)DeclarativeUtil.invokeStatic(method, memoryId)).ifPresent(builder::chatMemoryProvider);
        AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(Output.class)).map(m -> AgenticServices.agenticScopeFunction(m, Object.class)).ifPresent(builder::output);
        AgenticServices.buildErrorHandler(agentServiceClass).ifPresent(builder::errorHandler);
        AgenticServices.buildInvocationHandler(agentServiceClass).ifPresent(builder::beforeAgentInvocation);
        AgenticServices.buildCompletionHandler(agentServiceClass).ifPresent(builder::afterAgentInvocation);
        return builder.build();
    }

    private static <T> Optional<Function<ErrorContext, ErrorRecoveryResult>> buildErrorHandler(Class<T> agentServiceClass) {
        return AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(ErrorHandler.class)).map(m -> errorContext -> (ErrorRecoveryResult)DeclarativeUtil.invokeStatic(m, errorContext));
    }

    private static <T> Optional<Consumer<AgentRequest>> buildInvocationHandler(Class<T> agentServiceClass) {
        return AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(BeforeAgentInvocation.class)).map(m -> request -> DeclarativeUtil.invokeStatic(m, request));
    }

    private static <T> Optional<Consumer<AgentResponse>> buildCompletionHandler(Class<T> agentServiceClass) {
        return AgenticServices.selectMethod(agentServiceClass, method -> method.isAnnotationPresent(AfterAgentInvocation.class)).map(m -> response -> DeclarativeUtil.invokeStatic(m, response));
    }

    private static Optional<Method> predicateMethod(Class<?> agentServiceClass, Predicate<Method> methodSelector) {
        return AgenticServices.selectMethod(agentServiceClass, methodSelector.and(m -> m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class));
    }

    private static Optional<Method> selectMethod(Class<?> agentServiceClass, Predicate<Method> methodSelector) {
        Optional<Method> method;
        for (Method method2 : agentServiceClass.getMethods()) {
            if (!methodSelector.test(method2) || !Modifier.isStatic(method2.getModifiers())) continue;
            return Optional.of(method2);
        }
        if (agentServiceClass.getSuperclass() != null && (method = AgenticServices.selectMethod(agentServiceClass.getSuperclass(), methodSelector)).isPresent()) {
            return method;
        }
        for (GenericDeclaration genericDeclaration : agentServiceClass.getInterfaces()) {
            Optional<Method> method3 = AgenticServices.selectMethod(genericDeclaration, methodSelector);
            if (!method3.isPresent()) continue;
            return method3;
        }
        return Optional.empty();
    }

    private static BiPredicate<AgenticScope, Integer> loopExitConditionPredicate(Method predicateMethod) {
        List<AgentArgument> agentArguments = AgentUtil.argumentsFromMethod(predicateMethod);
        return (agenticScope, loopCounter) -> {
            try {
                Object[] args = AgentUtil.agentInvocationArguments(agenticScope, agentArguments, Map.of("@AgenticScope", agenticScope, "@LoopCounter", loopCounter)).positionalArgs();
                return (Boolean)predicateMethod.invoke(null, args);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking exit condition method: " + predicateMethod.getName(), e);
            }
        };
    }

    private static Predicate<AgenticScope> agenticScopePredicate(Method predicateMethod) {
        return agenticScope -> AgenticServices.agenticScopeFunction(predicateMethod, Boolean.TYPE).apply((AgenticScope)agenticScope);
    }

    private static <T> Function<AgenticScope, T> agenticScopeFunction(Method functionMethod, Class<T> targetClass) {
        List<AgentArgument> agentArguments = AgentUtil.argumentsFromMethod(functionMethod);
        return agenticScope -> {
            try {
                Object[] args = AgentUtil.agentInvocationArguments(agenticScope, agentArguments, Map.of("@AgenticScope", agenticScope)).positionalArgs();
                return functionMethod.invoke(null, args);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking method: " + functionMethod.getName(), e);
            }
        };
    }

    private static List<AgentExecutor> createSubagents(Class<?>[] subAgents, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        return Stream.of(subAgents).map(subagent -> AgenticServices.createSubagent(subagent, chatModel, agentConfigurator)).toList();
    }

    private static AgentExecutor createSubagent(Class<?> subgentClass, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        AgentExecutor agentExecutor = AgenticServices.createBuiltInAgentExecutor(subgentClass, chatModel, agentConfigurator);
        if (agentExecutor != null) {
            return agentExecutor;
        }
        AgentBuilder<?> agentBuilder = AgenticServices.agentBuilder(subgentClass);
        DeclarativeUtil.configureAgent(subgentClass, chatModel, agentBuilder, agentConfigurator);
        return AgentUtil.agentToExecutor((AgentSpecification)agentBuilder.build());
    }

    private static AgentExecutor createBuiltInAgentExecutor(Class<?> agentServiceClass, ChatModel chatModel, Consumer<DeclarativeAgentCreationContext> agentConfigurator) {
        Method agenticMethod;
        Optional<Method> sequenceMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, SequenceAgent.class);
        if (sequenceMethod.isPresent()) {
            Method method = sequenceMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildSequentialAgent(agentServiceClass, method, chatModel, agentConfigurator);
            return new AgentExecutor(AgentInvoker.fromMethod(agent, method), agent);
        }
        Optional<Method> loopMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, LoopAgent.class);
        if (loopMethod.isPresent()) {
            Method method = loopMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildLoopAgent(agentServiceClass, method, chatModel, agentConfigurator);
            return new AgentExecutor(AgentInvoker.fromMethod(agent, method), agent);
        }
        Optional<Method> conditionalMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, ConditionalAgent.class);
        if (conditionalMethod.isPresent()) {
            Method method = conditionalMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildConditionalAgent(agentServiceClass, method, chatModel, agentConfigurator);
            return new AgentExecutor(AgentInvoker.fromMethod(agent, method), agent);
        }
        Optional<Method> parallelMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, ParallelAgent.class);
        if (parallelMethod.isPresent()) {
            Method method = parallelMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildParallelAgent(agentServiceClass, method, chatModel, agentConfigurator);
            return new AgentExecutor(AgentInvoker.fromMethod(agent, method), agent);
        }
        Optional<Method> supervisorMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, SupervisorAgent.class);
        if (supervisorMethod.isPresent()) {
            Method method = supervisorMethod.get();
            AgentSpecification agent = (AgentSpecification)AgenticServices.buildSupervisorAgent(agentServiceClass, method, chatModel, agentConfigurator);
            return new AgentExecutor(AgentInvoker.fromMethod(agent, method), agent);
        }
        Optional<Method> humanInTheLoopMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, HumanInTheLoop.class);
        if (humanInTheLoopMethod.isPresent()) {
            return AgenticServices.createHumanInTheLoopAgent(agentServiceClass, humanInTheLoopMethod.get());
        }
        Optional<Method> a2aClientMethod = AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, A2AClientAgent.class);
        if (a2aClientMethod.isPresent()) {
            return AgenticServices.createA2AClientAgent(agentServiceClass, a2aClientMethod.get());
        }
        if (!agentServiceClass.isInterface() && (agenticMethod = AgenticServices.nonAiAgentMethod(agentServiceClass)) != null) {
            if (agenticMethod.getParameterCount() == 0) {
                return AgentUtil.agentToExecutor(new AgentAction(() -> DeclarativeUtil.invokeStatic(agenticMethod, new Object[0])));
            }
            if (agenticMethod.getParameterCount() == 1 && AgenticScope.class.isAssignableFrom(agenticMethod.getParameterTypes()[0])) {
                return AgentUtil.agentToExecutor(new AgenticScopeAction(agenticScope -> DeclarativeUtil.invokeStatic(agenticMethod, agenticScope)));
            }
        }
        return null;
    }

    private static AgentExecutor createA2AClientAgent(Class<?> agentServiceClass, Method a2aMethod) {
        A2AClientAgent a2aClient = a2aMethod.getAnnotation(A2AClientAgent.class);
        A2AClientBuilder<?> a2aClientBuilder = AgenticServices.a2aBuilder(a2aClient.a2aServerUrl(), agentServiceClass).inputKeys((String[])Stream.of(a2aMethod.getParameters()).map(AgentInvoker::parameterName).toArray(String[]::new)).outputKey(AgentUtil.outputKey(a2aClient.outputKey(), a2aClient.typedOutputKey())).async(a2aClient.async());
        AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, BeforeAgentInvocation.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, AgentRequest.class);
            DeclarativeUtil.checkReturnType(method, Void.TYPE);
            a2aClientBuilder.beforeAgentInvocation(request -> DeclarativeUtil.invokeStatic(method, request));
        });
        AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, AfterAgentInvocation.class).ifPresent(method -> {
            DeclarativeUtil.checkArguments(method, AgentResponse.class);
            DeclarativeUtil.checkReturnType(method, Void.TYPE);
            a2aClientBuilder.afterAgentInvocation(response -> DeclarativeUtil.invokeStatic(method, response));
        });
        return AgentUtil.agentToExecutor(a2aClientBuilder.build());
    }

    private static AgentExecutor createHumanInTheLoopAgent(Class<?> agentServiceClass, Method method) {
        HumanInTheLoop humanInTheLoop = method.getAnnotation(HumanInTheLoop.class);
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("Method " + method.getName() + " annotated with @" + dev.langchain4j.agentic.workflow.HumanInTheLoop.class.getSimpleName() + " must have exactly one parameter");
        }
        HumanInTheLoop.HumanInTheLoopBuilder humanInTheLoopBuilder = AgenticServices.humanInTheLoopBuilder().description(humanInTheLoop.description()).outputKey(humanInTheLoop.outputKey()).async(humanInTheLoop.async()).inputKey(AgentInvoker.parameterName(method.getParameters()[0])).requestWriter(arg -> DeclarativeUtil.invokeStatic(method, arg));
        AgentUtil.getAnnotatedMethodOnClass(agentServiceClass, HumanInTheLoopResponseSupplier.class).ifPresentOrElse(readerMethod -> humanInTheLoopBuilder.responseReader(() -> DeclarativeUtil.invokeStatic(readerMethod, new Object[0])), () -> {
            throw new IllegalArgumentException("Human in the loop class " + agentServiceClass.getName() + " must have a static method annotated with @" + HumanInTheLoopResponseSupplier.class.getSimpleName());
        });
        return AgentUtil.agentToExecutor(humanInTheLoopBuilder.build());
    }

    private static Method nonAiAgentMethod(Class<?> agentServiceClass) {
        Method agenticMethod = null;
        for (Method method : agentServiceClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Agent.class) || !Modifier.isStatic(method.getModifiers())) continue;
            if (agenticMethod != null) {
                throw new IllegalArgumentException("Multiple agent methods found in class: " + agentServiceClass.getName());
            }
            agenticMethod = method;
        }
        return agenticMethod;
    }

    public static AgentAction agentAction(AgentAction.NonThrowingRunnable runnable) {
        return new AgentAction(runnable);
    }

    public static AgenticScopeAction agentAction(AgenticScopeAction.NonThrowingConsumer<AgenticScope> consumer) {
        return new AgenticScopeAction(consumer);
    }

    private static enum WorkflowBuilderProvider {
        INSTANCE;

        private WorkflowAgentsBuilder workflowAgentsBuilder;

        private WorkflowBuilderProvider() {
            this.internalSetWorkflowAgentsBuilder(WorkflowBuilderProvider.loadWorkflowAgentsBuilder());
        }

        private static WorkflowAgentsBuilder loadWorkflowAgentsBuilder() {
            ServiceLoader<WorkflowAgentsBuilder> loader = ServiceLoader.load(WorkflowAgentsBuilder.class);
            Iterator<WorkflowAgentsBuilder> iterator = loader.iterator();
            if (iterator.hasNext()) {
                WorkflowAgentsBuilder builder = iterator.next();
                return builder;
            }
            return WorkflowAgentsBuilderImpl.INSTANCE;
        }

        private void internalSetWorkflowAgentsBuilder(WorkflowAgentsBuilder workflowAgentsBuilder) {
            this.workflowAgentsBuilder = workflowAgentsBuilder;
        }
    }

    public static class AgentAction {
        private final NonThrowingRunnable runnable;

        private AgentAction(NonThrowingRunnable runnable) {
            this.runnable = runnable;
        }

        @Agent
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @FunctionalInterface
        public static interface NonThrowingRunnable {
            public void run() throws Exception;
        }
    }

    public static class AgenticScopeAction {
        private final NonThrowingConsumer<AgenticScope> consumer;

        private AgenticScopeAction(NonThrowingConsumer<AgenticScope> consumer) {
            this.consumer = consumer;
        }

        @Agent
        public void accept(AgenticScope agenticScope) {
            try {
                this.consumer.accept(agenticScope);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @FunctionalInterface
        public static interface NonThrowingConsumer<T> {
            public void accept(T var1) throws Exception;
        }
    }

    public record DefaultDeclarativeAgentCreationContext<T>(Class<T> agentServiceClass, AgentBuilder<T> agentBuilder) implements DeclarativeAgentCreationContext<T>
    {
    }

    public static interface DeclarativeAgentCreationContext<T> {
        public Class<T> agentServiceClass();

        public AgentBuilder<T> agentBuilder();
    }
}

