/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.a2a;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.a2a.A2AClientSpecification;
import dev.langchain4j.agentic.agent.AgentRequest;
import dev.langchain4j.agentic.agent.AgentResponse;
import dev.langchain4j.agentic.internal.AgentInvocationArguments;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.scope.AgenticScope;
import io.a2a.spec.AgentCard;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Stream;

public class A2AClientAgentInvoker
implements AgentInvoker {
    private final String uniqueName;
    private final String[] inputKeys;
    private final A2AClientSpecification a2AClientInstance;
    private final AgentCard agentCard;
    private final Method method;

    public A2AClientAgentInvoker(A2AClientSpecification a2AClientInstance, Method method) {
        this.method = method;
        this.a2AClientInstance = a2AClientInstance;
        this.agentCard = a2AClientInstance.agentCard();
        this.uniqueName = AgentUtil.uniqueAgentName((String)this.name());
        this.inputKeys = this.inputKeys(a2AClientInstance);
    }

    private String[] inputKeys(A2AClientSpecification a2AClientInstance) {
        return this.isUntyped() ? a2AClientInstance.inputKeys() : (String[])Stream.of(this.method.getParameters()).map(AgentInvoker::parameterName).toArray(String[]::new);
    }

    public String name() {
        return this.agentCard.name();
    }

    public String uniqueName() {
        return this.uniqueName;
    }

    public String description() {
        return this.agentCard.description();
    }

    public String outputKey() {
        return this.a2AClientInstance.outputKey();
    }

    public boolean async() {
        return this.a2AClientInstance.async();
    }

    public void beforeInvocation(AgentRequest request) {
        this.a2AClientInstance.beforeInvocation(request);
    }

    public void afterInvocation(AgentResponse response) {
        this.a2AClientInstance.afterInvocation(response);
    }

    public Method method() {
        return this.method;
    }

    public String toCard() {
        return "{" + this.uniqueName() + ": " + this.description() + ", " + Arrays.toString(this.inputKeys) + "}";
    }

    public AgentInvocationArguments toInvocationArguments(AgenticScope agenticScope) {
        return this.isUntyped() ? new AgentInvocationArguments(agenticScope.state(), new Object[]{agenticScope.state()}) : this.agentInvocationArguments(agenticScope);
    }

    private AgentInvocationArguments agentInvocationArguments(AgenticScope agenticScope) {
        HashMap<String, Object> namedArgs = new HashMap<String, Object>();
        Object[] positionalArgs = new Object[this.inputKeys.length];
        int i = 0;
        for (String argName : this.inputKeys) {
            Object argValue = agenticScope.readState(argName);
            positionalArgs[i++] = argValue;
            namedArgs.put(argName, argValue);
        }
        return new AgentInvocationArguments(namedArgs, positionalArgs);
    }

    private boolean isUntyped() {
        return this.method.getDeclaringClass() == UntypedAgent.class;
    }
}

