/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.Annotation;
import dev.harrel.jsonschema.AnnotationTree;
import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.Error;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.JsonNodeFactory;
import dev.harrel.jsonschema.JsonParser;
import dev.harrel.jsonschema.OptionalUtil;
import dev.harrel.jsonschema.Schema;
import dev.harrel.jsonschema.SchemaNotFoundException;
import dev.harrel.jsonschema.SchemaRegistry;
import dev.harrel.jsonschema.SchemaResolver;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

public final class Validator {
    private final JsonNodeFactory schemaNodeFactory;
    private final JsonNodeFactory instanceNodeFactory;
    private final SchemaResolver schemaResolver;
    private final SchemaRegistry schemaRegistry;
    private final JsonParser jsonParser;

    Validator(JsonNodeFactory schemaNodeFactory, JsonNodeFactory instanceNodeFactory, SchemaResolver schemaResolver, SchemaRegistry schemaRegistry, JsonParser jsonParser) {
        this.schemaNodeFactory = Objects.requireNonNull(schemaNodeFactory);
        this.instanceNodeFactory = Objects.requireNonNull(instanceNodeFactory);
        this.schemaResolver = Objects.requireNonNull(schemaResolver);
        this.schemaRegistry = Objects.requireNonNull(schemaRegistry);
        this.jsonParser = Objects.requireNonNull(jsonParser);
    }

    public URI registerSchema(String rawSchema) {
        return this.registerSchema(this.schemaNodeFactory.create(rawSchema));
    }

    public URI registerSchema(Object schemaProviderNode) {
        return this.registerSchema(this.schemaNodeFactory.wrap(schemaProviderNode));
    }

    public URI registerSchema(JsonNode schemaNode) {
        return this.jsonParser.parseRootSchema(this.generateSchemaUri(), schemaNode);
    }

    public URI registerSchema(URI uri, String rawSchema) {
        return this.registerSchema(uri, this.schemaNodeFactory.create(rawSchema));
    }

    public URI registerSchema(URI uri, Object schemaProviderNode) {
        return this.registerSchema(uri, this.schemaNodeFactory.wrap(schemaProviderNode));
    }

    public URI registerSchema(URI uri, JsonNode schemaNode) {
        return this.jsonParser.parseRootSchema(uri, schemaNode);
    }

    public Result validate(URI schemaUri, String rawInstance) {
        return this.validate(schemaUri, this.instanceNodeFactory.create(rawInstance));
    }

    public Result validate(URI schemaUri, Object instanceProviderNode) {
        return this.validate(schemaUri, this.instanceNodeFactory.wrap(instanceProviderNode));
    }

    public Result validate(URI schemaUri, JsonNode instanceNode) {
        Schema schema = this.getRootSchema(schemaUri);
        EvaluationContext ctx = this.createNewEvaluationContext();
        boolean valid = ctx.validateAgainstSchema(schema, instanceNode);
        return new Result(valid, ctx);
    }

    private Schema getRootSchema(URI uri) {
        CompoundUri compoundUri = CompoundUri.fromString(uri.toString());
        return (Schema)OptionalUtil.firstPresent(() -> Optional.ofNullable(this.schemaRegistry.get(compoundUri)), () -> this.resolveExternalSchema(compoundUri)).orElseThrow(() -> new SchemaNotFoundException(compoundUri));
    }

    private Optional<Schema> resolveExternalSchema(CompoundUri compoundUri) {
        if (this.schemaRegistry.get(compoundUri.uri) != null) {
            return Optional.empty();
        }
        return this.schemaResolver.resolve(compoundUri.uri.toString()).toJsonNode(this.schemaNodeFactory).map(node -> {
            this.jsonParser.parseRootSchema(compoundUri.uri, (JsonNode)node);
            return this.schemaRegistry.get(compoundUri);
        });
    }

    private URI generateSchemaUri() {
        return URI.create("https://harrel.dev/" + UUID.randomUUID().toString().substring(0, 8));
    }

    private EvaluationContext createNewEvaluationContext() {
        return new EvaluationContext(this.schemaNodeFactory, this.jsonParser, this.schemaRegistry, this.schemaResolver);
    }

    public static final class Result {
        private final boolean valid;
        private final List<Error> errors;
        private final AnnotationTree annotationTree;
        private List<Annotation> annotations;

        Result(boolean valid, EvaluationContext ctx) {
            this.valid = valid;
            this.errors = Collections.unmodifiableList(ctx.getErrors().stream().filter(e -> e.getError() != null).collect(Collectors.toList()));
            this.annotationTree = ctx.getAnnotationTree();
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<Annotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = Collections.unmodifiableList(this.annotationTree.getAllAnnotations().stream().filter(a -> a.getAnnotation() != null).collect(Collectors.toList()));
            }
            return this.annotations;
        }

        public List<Error> getErrors() {
            return this.errors;
        }
    }
}

