/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.ArrayList;
import java.util.List;

class UniqueItemsEvaluator
implements Evaluator {
    private final boolean unique;

    UniqueItemsEvaluator(JsonNode node) {
        if (!node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.unique = node.asBoolean();
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isArray() || !this.unique) {
            return Evaluator.Result.success();
        }
        ArrayList<JsonNode> parsed = new ArrayList<JsonNode>();
        List<JsonNode> jsonNodes = node.asArray();
        for (int i = 0; i < jsonNodes.size(); ++i) {
            JsonNode element = jsonNodes.get(i);
            if (parsed.stream().anyMatch(element::isEqualTo)) {
                return Evaluator.Result.failure(String.format("Array contains non-unique item at index [%d]", i));
            }
            parsed.add(element);
        }
        return Evaluator.Result.success();
    }
}

