/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.CompoundUri;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.util.Set;

class UnevaluatedPropertiesEvaluator
implements Evaluator {
    private final CompoundUri schemaRef;

    UnevaluatedPropertiesEvaluator(SchemaParsingContext ctx, JsonNode node) {
        if (!node.isObject() && !node.isBoolean()) {
            throw new IllegalArgumentException();
        }
        this.schemaRef = ctx.getCompoundUri(node);
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        Set<String> evaluatedInstances = ctx.calculateEvaluatedInstancesFromParent();
        boolean valid = true;
        for (JsonNode fieldNode : node.asObject().values()) {
            if (evaluatedInstances.contains(fieldNode.getJsonPointer())) continue;
            valid = ctx.resolveInternalRefAndValidate(this.schemaRef, fieldNode) && valid;
        }
        return valid ? Evaluator.Result.success() : Evaluator.Result.failure();
    }

    @Override
    public int getOrder() {
        return 20;
    }
}

