/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.JsonNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class RequiredEvaluator
implements Evaluator {
    private final List<String> requiredProperties;

    RequiredEvaluator(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException();
        }
        this.requiredProperties = Collections.unmodifiableList(node.asArray().stream().map(JsonNode::asString).collect(Collectors.toList()));
    }

    @Override
    public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
        if (!node.isObject()) {
            return Evaluator.Result.success();
        }
        Set<String> keys = node.asObject().keySet();
        if (keys.containsAll(this.requiredProperties)) {
            return Evaluator.Result.success();
        }
        HashSet<String> unsatisfied = new HashSet<String>(this.requiredProperties);
        unsatisfied.removeAll(keys);
        return Evaluator.Result.failure(String.format("Object does not have some of the required properties [%s]", unsatisfied));
    }
}

