/*
 * Decompiled with CFR 0.152.
 */
package dev.harrel.jsonschema;

import com.sanctionco.jmail.JMail;
import com.sanctionco.jmail.net.InternetProtocolAddress;
import dev.harrel.jsonschema.EvaluationContext;
import dev.harrel.jsonschema.Evaluator;
import dev.harrel.jsonschema.EvaluatorFactory;
import dev.harrel.jsonschema.JsonNode;
import dev.harrel.jsonschema.SchemaParsingContext;
import java.net.URI;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;

public final class FormatEvaluatorFactory
implements EvaluatorFactory {
    private static final Pattern DURATION_PATTERN = Pattern.compile("P(?:\\d+W|T(?:\\d+H(?:\\d+M(?:\\d+S)?)?|\\d+M(?:\\d+S)?|\\d+S)|(?:\\d+D|\\d+M(?:\\d+D)?|\\d+Y(?:\\d+M(?:\\d+D)?)?)(?:T(?:\\d+H(?:\\d+M(?:\\d+S)?)?|\\d+M(?:\\d+S)?|\\d+S))?)", 2);
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])(\\.([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]))*", 2);
    private final Predicate<SchemaParsingContext> vocabPredicate;

    public FormatEvaluatorFactory() {
        this.vocabPredicate = ctx -> true;
    }

    public FormatEvaluatorFactory(Set<String> vocabularies) {
        Set<String> vocabsCopy = Collections.unmodifiableSet(new HashSet<String>(vocabularies));
        this.vocabPredicate = ctx -> !Collections.disjoint(vocabsCopy, ctx.getMetaValidationData().activeVocabularies);
    }

    @Override
    public Optional<Evaluator> create(SchemaParsingContext ctx, String fieldName, JsonNode fieldNode) {
        if (!("format".equals(fieldName) && fieldNode.isString() && this.vocabPredicate.test(ctx))) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getOperator(fieldNode.asString())).map(x$0 -> new FormatEvaluator((UnaryOperator)x$0));
    }

    private UnaryOperator<String> getOperator(String format) {
        switch (format) {
            case "date": {
                return FormatEvaluatorFactory.tryOf(DateTimeFormatter.ISO_DATE::parse);
            }
            case "date-time": {
                return FormatEvaluatorFactory.tryOf(DateTimeFormatter.ISO_DATE_TIME::parse);
            }
            case "time": {
                return FormatEvaluatorFactory.tryOf(DateTimeFormatter.ISO_TIME::parse);
            }
            case "duration": {
                return v -> DURATION_PATTERN.matcher((CharSequence)v).matches() ? null : String.format("\"%s\" is not a valid duration string", v);
            }
            case "email": 
            case "idn-email": {
                return v -> JMail.isValid((String)v) ? null : String.format("\"%s\" is not a valid email address", v);
            }
            case "hostname": 
            case "idn-hostname": {
                return v -> HOSTNAME_PATTERN.matcher((CharSequence)v).matches() ? null : String.format("\"%s\" is not a valid hostname", v);
            }
            case "ipv4": {
                return v -> InternetProtocolAddress.validateIpv4((String)v).isPresent() ? null : String.format("\"%s\" is not a valid IPv4 address", v);
            }
            case "ipv6": {
                return v -> InternetProtocolAddress.validateIpv6((String)v).isPresent() ? null : String.format("\"%s\" is not a valid IPv6 address", v);
            }
            case "uri": 
            case "iri": {
                return FormatEvaluatorFactory::uriOperator;
            }
            case "uri-reference": 
            case "iri-reference": {
                return FormatEvaluatorFactory.tryOf(URI::create);
            }
            case "uuid": {
                return FormatEvaluatorFactory::uuidOperator;
            }
            case "uri-template": {
                return FormatEvaluatorFactory::uriTemplateOperator;
            }
            case "json-pointer": {
                return v -> FormatEvaluatorFactory.validateJsonPointer(v) ? null : String.format("\"%s\" is not a valid json-pointer", v);
            }
            case "relative-json-pointer": {
                return FormatEvaluatorFactory::rjpOperator;
            }
            case "regex": {
                return FormatEvaluatorFactory.tryOf(Pattern::compile);
            }
        }
        return null;
    }

    private static UnaryOperator<String> tryOf(Consumer<String> op) {
        return v -> {
            try {
                op.accept((String)v);
                return null;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        };
    }

    private static boolean validateJsonPointer(String pointer) {
        if (pointer.isEmpty()) {
            return true;
        }
        if (!pointer.startsWith("/")) {
            return false;
        }
        String decoded = pointer.replace("~0", "").replace("~1", "");
        return !decoded.contains("~");
    }

    private static String uriOperator(String value) {
        try {
            URI uri = URI.create(value);
            return uri.isAbsolute() ? null : String.format("\"%s\" is a relative URI", uri);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static String uuidOperator(String value) {
        try {
            UUID.fromString(value);
            return value.length() == 36 ? null : String.format("\"%s\" UUID has invalid length", value);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private static String uriTemplateOperator(String value) {
        int level = 0;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '{') {
                ++level;
                continue;
            }
            if (c != '}' || level <= 0) continue;
            --level;
        }
        return level == 0 ? null : String.format("\"%s\" is not a valid URI template", value);
    }

    private static String rjpOperator(String value) {
        int firstSegmentEndIdx = value.length();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '#' || c == '/') {
                firstSegmentEndIdx = i;
                break;
            }
            if (c >= '0' && c <= '9') continue;
            return FormatEvaluatorFactory.invalidRjpMessage(value);
        }
        String firstSegment = value.substring(0, firstSegmentEndIdx);
        String secondSegment = value.substring(firstSegmentEndIdx);
        if (firstSegment.isEmpty() || firstSegment.length() > 1 && firstSegment.startsWith("0") || !"#".equals(secondSegment) && !FormatEvaluatorFactory.validateJsonPointer(secondSegment)) {
            return FormatEvaluatorFactory.invalidRjpMessage(value);
        }
        return null;
    }

    private static String invalidRjpMessage(String value) {
        return String.format("\"%s\" is not a valid relative-json-pointer", value);
    }

    private static final class FormatEvaluator
    implements Evaluator {
        private final UnaryOperator<String> operator;

        private FormatEvaluator(UnaryOperator<String> operator) {
            this.operator = operator;
        }

        @Override
        public Evaluator.Result evaluate(EvaluationContext ctx, JsonNode node) {
            if (!node.isString()) {
                return Evaluator.Result.success();
            }
            String value = node.asString();
            String err = (String)this.operator.apply(value);
            return err == null ? Evaluator.Result.success(value) : Evaluator.Result.failure(err);
        }
    }
}

