/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

class Unsafe {
    Unsafe() {
    }

    public static float getFloat(byte[] arr, int off) {
        int v = Unsafe.getLE32(arr, off);
        return Float.intBitsToFloat(v);
    }

    public static short getLE16(byte[] arr, int off) {
        short val = (short)((0xFF & arr[off + 1]) << 8);
        val = (short)(val | (short)(0xFF & arr[off]));
        return val;
    }

    public static short getLE16(byte[] arr) {
        return Unsafe.getLE16(arr, 0);
    }

    public static int getLE24(byte[] arr, int off) {
        int val = (0xFF & arr[off + 2]) << 16;
        val |= (0xFF & arr[off + 1]) << 8;
        return val |= 0xFF & arr[off + 0];
    }

    public static int getLE32(byte[] arr, int off) {
        int val = (0xFF & arr[off + 0]) << 0;
        val |= (0xFF & arr[off + 1]) << 8;
        val |= (0xFF & arr[off + 2]) << 16;
        return val |= (0xFF & arr[off + 3]) << 24;
    }

    public static long getLE64(byte[] arr, int off) {
        long val = 0L;
        val |= (long)(0xFF & arr[off + 7]) << 56;
        val |= (long)(0xFF & arr[off + 6]) << 48;
        val |= (long)(0xFF & arr[off + 5]) << 40;
        val |= (long)(0xFF & arr[off + 4]) << 32;
        val |= (long)(0xFF & arr[off + 3]) << 24;
        val |= (long)(0xFF & arr[off + 2]) << 16;
        val |= (long)(0xFF & arr[off + 1]) << 8;
        return val |= (long)(0xFF & arr[off + 0]) << 0;
    }

    public static void putLE16(byte[] arr, int off, short val) {
        arr[off + 1] = (byte)((0xFFFF & val) >>> 8 & 0xFF);
        arr[off + 0] = (byte)((0xFFFF & val) >>> 0 & 0xFF);
    }

    public static void putLE24(byte[] arr, int off, int val) {
        arr[off] = (byte)(val >>> 0 & 0xFF);
        arr[off + 1] = (byte)(val >>> 8 & 0xFF);
        arr[off + 2] = (byte)(val >>> 16 & 0xFF);
    }

    public static void putLE32(byte[] arr, int off, int val) {
        arr[off + 0] = (byte)(val >>> 0 & 0xFF);
        arr[off + 1] = (byte)(val >>> 8 & 0xFF);
        arr[off + 2] = (byte)(val >>> 16 & 0xFF);
        arr[off + 3] = (byte)(val >>> 24 & 0xFF);
    }

    public static int floatToUInt32(float value) {
        return Float.floatToIntBits(value);
    }

    public static void toByteArray(float[] arr, int start, int len, byte[] dst, int offset) {
        int psrc = start;
        int pdst = offset;
        for (int i = 0; i < len; ++i) {
            int v = Unsafe.floatToUInt32(arr[psrc]);
            Unsafe.putLE32(dst, pdst, v);
            ++psrc;
            pdst += 4;
        }
    }

    public static float[] toFloatArray(byte[] array, float[] ret) {
        if (ret.length == 0) {
            return ret;
        }
        int i = 0;
        int d = 0;
        while (i < ret.length) {
            ret[d] = Unsafe.getFloat(array, i);
            i += 4;
            ++d;
        }
        return ret;
    }
}

