/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributeQuantizationTransform;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.PointAttribute;
import dev.fileformat.drako.PointCloudEncoder;
import dev.fileformat.drako.SequentialIntegerAttributeEncoder;

class SequentialQuantizationAttributeEncoder
extends SequentialIntegerAttributeEncoder {
    private AttributeQuantizationTransform attribute_quantization_transform_;

    @Override
    public int getUniqueId() {
        return 2;
    }

    @Override
    public boolean isLossyEncoder() {
        return true;
    }

    @Override
    public void initialize(PointCloudEncoder encoder, int attributeId) throws DrakoException {
        super.initialize(encoder, attributeId);
        PointAttribute attribute = this.getEncoder().getPointCloud().attribute(attributeId);
        if (attribute.getDataType() != 9) {
            throw DracoUtils.failed();
        }
        int quantization_bits = encoder.getOptions().getQuantizationBits(attribute);
        if (quantization_bits < 1) {
            throw DracoUtils.failed();
        }
        this.attribute_quantization_transform_.computeParameters(attribute, quantization_bits);
    }

    @Override
    public void encodeDataNeededByPortableTransform(EncoderBuffer out_buffer) throws DrakoException {
        this.attribute_quantization_transform_.encodeParameters(out_buffer);
    }

    @Override
    protected void prepareValues(int[] pointIds, int numPoints) {
        PointAttribute portable_attribute = this.attribute_quantization_transform_.initTransformedAttribute(this.attribute, pointIds.length);
        this.attribute_quantization_transform_.transformAttribute(this.attribute, pointIds, portable_attribute);
        this.portableAttribute = portable_attribute;
    }

    public SequentialQuantizationAttributeEncoder() {
        this.$initFields$();
    }

    private void $initFields$() {
        try {
            this.attribute_quantization_transform_ = new AttributeQuantizationTransform();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

