/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Algorithms;
import dev.fileformat.drako.BytePointer;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.Encoding;
import dev.fileformat.drako.MetaClasses;
import dev.fileformat.drako.RAnsBitCodec;
import dev.fileformat.drako.RAnsEncoder;
import java.util.Comparator;

class RAnsSymbolEncoder
extends RAnsBitCodec {
    private int maxSymbols;
    private int ransPrecisionBits;
    private int ransPrecision;
    private RAnsBitCodec.RansSym[] probabilityTable;
    int numSymbols;
    long numExpectedBits;
    RAnsEncoder ans;
    long bufferOffset;

    public RAnsSymbolEncoder(int maxSymbolBitLength, long[] frequencies, EncoderBuffer buffer) {
        int numSymbols;
        this.maxSymbols = 1 << maxSymbolBitLength;
        this.ransPrecisionBits = RAnsBitCodec.computeRAnsPrecisionFromMaxSymbolBitLength(maxSymbolBitLength);
        this.ransPrecision = 1 << this.ransPrecisionBits;
        this.ans = new RAnsEncoder(this.ransPrecisionBits);
        long totalFreq = 0L;
        int maxValidSymbol = 0;
        int i = 0;
        while ((0xFFFFFFFFL & (long)i) < (long)frequencies.length) {
            totalFreq += frequencies[i];
            if (frequencies[i] > 0L) {
                maxValidSymbol = i;
            }
            ++i;
        }
        this.numSymbols = numSymbols = maxValidSymbol + 1;
        this.probabilityTable = (RAnsBitCodec.RansSym[])MetaClasses.RansSym.newArray(numSymbols);
        double totalFreqD = totalFreq;
        double ransPrecisionD = this.ransPrecision;
        int totalRansProb = 0;
        int i2 = 0;
        while ((long)i2 < (0xFFFFFFFFL & (long)numSymbols)) {
            long freq = frequencies[i2];
            double prob = (double)freq / totalFreqD;
            int ransProb = (int)(prob * ransPrecisionD + 0.5);
            if (ransProb == 0 && freq > 0L) {
                ransProb = 1;
            }
            this.probabilityTable[i2].prob = ransProb;
            totalRansProb += ransProb;
            ++i2;
        }
        if (totalRansProb != this.ransPrecision) {
            int[] sortedProbabilities = new int[numSymbols];
            int i3 = 0;
            while ((long)i3 < (0xFFFFFFFFL & (long)numSymbols)) {
                sortedProbabilities[i3] = i3;
                ++i3;
            }
            Algorithms.sort(sortedProbabilities, new Comparator<Integer>(){

                @Override
                public int compare(Integer a, Integer b) {
                    return Long.compare((long)((RAnsSymbolEncoder)RAnsSymbolEncoder.this).probabilityTable[a.intValue()].prob & 0xFFFFFFFFL, (long)((RAnsSymbolEncoder)RAnsSymbolEncoder.this).probabilityTable[b.intValue()].prob & 0xFFFFFFFFL);
                }
            });
            if (totalRansProb < this.ransPrecision) {
                this.probabilityTable[sortedProbabilities.length - 1].prob += this.ransPrecision - totalRansProb;
            } else {
                int error = totalRansProb - this.ransPrecision;
                block3: while (error > 0) {
                    double actTotalProbD = totalRansProb;
                    double actRelErrorD = ransPrecisionD / actTotalProbD;
                    for (int j = numSymbols - 1; j > 0; --j) {
                        int symbolId = sortedProbabilities[j];
                        if ((0xFFFFFFFFL & (long)this.probabilityTable[symbolId].prob) <= 1L) {
                            if (j != numSymbols - 1) continue block3;
                            return;
                        }
                        int newProb = (int)Math.floor(actRelErrorD * (double)this.probabilityTable[symbolId].prob);
                        int fix = this.probabilityTable[symbolId].prob - newProb;
                        if (fix == 0) {
                            fix = 1;
                        }
                        if (fix >= this.probabilityTable[symbolId].prob) {
                            fix = this.probabilityTable[symbolId].prob - 1;
                        }
                        if (fix > error) {
                            fix = error;
                        }
                        this.probabilityTable[symbolId].prob -= fix;
                        error -= fix;
                        if ((totalRansProb -= fix) == this.ransPrecision) continue block3;
                    }
                }
            }
        }
        int totalProb = 0;
        int i4 = 0;
        while ((long)i4 < (0xFFFFFFFFL & (long)numSymbols)) {
            this.probabilityTable[i4].cumProb = totalProb;
            totalProb += this.probabilityTable[i4].prob;
            ++i4;
        }
        if ((0xFFFFFFFFL & (long)totalProb) != (long)this.ransPrecision) {
            throw new RuntimeException("Failed to initialize RAns symbol encoder");
        }
        double numBits = 0.0;
        int i5 = 0;
        while ((long)i5 < (0xFFFFFFFFL & (long)numSymbols)) {
            if (this.probabilityTable[i5].prob != 0) {
                double normProb = (double)this.probabilityTable[i5].prob / ransPrecisionD;
                numBits += (double)frequencies[i5] * (Math.log(normProb) / Math.log(2.0));
            }
            ++i5;
        }
        this.numExpectedBits = (long)Math.ceil(-numBits);
        this.encodeTable(buffer);
    }

    private void encodeTable(EncoderBuffer buffer) {
        Encoding.encodeVarint2(this.numSymbols, buffer);
        int i = 0;
        while ((0xFFFFFFFFL & (long)i) < (0xFFFFFFFFL & (long)this.numSymbols)) {
            int prob = this.probabilityTable[i].prob;
            int numExtraBytes = 0;
            if ((0xFFFFFFFFL & (long)prob) >= 64L) {
                ++numExtraBytes;
                if ((0xFFFFFFFFL & (long)prob) >= 16384L) {
                    ++numExtraBytes;
                    if ((0xFFFFFFFFL & (long)prob) >= 0x400000L) {
                        ++numExtraBytes;
                    }
                }
            }
            if (prob == 0) {
                int next_prob;
                int offset = 0;
                while ((0xFFFFFFFFL & (long)offset) < 63L && (0xFFFFFFFFL & (long)(next_prob = this.probabilityTable[i + offset + 1].prob)) <= 0L) {
                    ++offset;
                }
                buffer.encode((byte)(offset << 2 | 3));
                i += offset;
            } else {
                buffer.encode((byte)(prob << 2 | numExtraBytes & 3));
                for (int b = 0; b < numExtraBytes; ++b) {
                    buffer.encode((byte)(prob >>> 8 * (b + 1) - 2));
                }
            }
            ++i;
        }
    }

    public void startEncoding(EncoderBuffer buffer) {
        long requiredBits = 2L * this.numExpectedBits + 32L;
        this.bufferOffset = buffer.getBytes();
        long requiredBytes = (requiredBits + 7L) / 8L;
        buffer.resize((int)this.bufferOffset + (int)requiredBytes + 8);
        byte[] data = buffer.getData();
        this.ans.reset(new BytePointer(data, (int)this.bufferOffset));
    }

    public void encodeSymbol(int symbol) {
        this.ans.write(this.probabilityTable[symbol]);
    }

    public void endEncoding(EncoderBuffer buffer) {
        int src = (int)this.bufferOffset;
        long bytes_written = this.ans.writeEnd();
        EncoderBuffer var_size_buffer = new EncoderBuffer();
        Encoding.encodeVarint(bytes_written, var_size_buffer);
        int size_len = var_size_buffer.getBytes();
        int dst = src + size_len;
        System.arraycopy(buffer.getData(), src, buffer.getData(), dst, (int)bytes_written);
        System.arraycopy(var_size_buffer.getData(), 0, buffer.getData(), src, size_len);
        buffer.resize((int)this.bufferOffset + (int)bytes_written + size_len);
    }
}

