/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.BytePointer;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IBitDecoder;
import dev.fileformat.drako.RAnsBitCodec;

class RAnsBitDecoder
extends RAnsBitCodec
implements IBitDecoder {
    private BytePointer buf = new BytePointer();
    private int offset;
    private int state;
    private byte probZero;

    RAnsBitDecoder() {
    }

    @Override
    public void startDecoding(DecoderBuffer sourceBuffer) throws DrakoException {
        this.clear();
        this.probZero = sourceBuffer.decodeU8();
        int sizeInBytes = sourceBuffer.getBitstreamVersion() < 22 ? sourceBuffer.decodeU32() : Decoding.decodeVarintU32(sourceBuffer);
        if ((0xFFFFFFFFL & (long)sizeInBytes) > (long)sourceBuffer.getRemainingSize()) {
            throw DracoUtils.failed();
        }
        if (this.aNSReadInit(BytePointer.add(sourceBuffer.getPointer(), sourceBuffer.getDecodedSize()), sizeInBytes) != 0) {
            throw DracoUtils.failed();
        }
        sourceBuffer.advance(sizeInBytes);
    }

    private int aNSReadInit(BytePointer buf, int offset) {
        BytePointer bytePointer = buf = buf == null ? new BytePointer() : buf.clone();
        if (offset < 1) {
            return 1;
        }
        this.buf.copyFrom(buf);
        int x = (0xFF & buf.get(offset - 1)) >>> 6;
        if (x == 0) {
            this.offset = offset - 1;
            this.state = 0xFF & buf.get(this.offset - 1) & 0x3F;
        } else if (x == 1) {
            if (offset < 2) {
                return 1;
            }
            this.offset = offset - 2;
            this.state = 0xFFFF & buf.toUInt16LE(this.offset) & 0x3FFF;
        } else if (x == 2) {
            if (offset < 3) {
                return 1;
            }
            this.offset = offset - 3;
            this.state = buf.toUInt24LE(this.offset) & 0x3FFFFF;
        } else {
            return 1;
        }
        this.state += 4096;
        if ((0xFFFFFFFFL & (long)this.state) >= 0x100000L) {
            return 1;
        }
        return 0;
    }

    boolean rabsRead(int p0) {
        int p = 256 - p0;
        if ((0xFFFFFFFFL & (long)this.state) < 4096L) {
            this.state = this.state * 256 + (0xFF & this.buf.get(--this.offset));
        }
        int x = this.state;
        int quot = x / 256;
        int rem = x % 256;
        int xn = quot * p;
        boolean val = (0xFFFFFFFFL & (long)rem) < (long)p;
        this.state = val ? xn + rem : x - xn - p;
        return val;
    }

    @Override
    public boolean decodeNextBit() {
        return this.rabsRead(0xFF & this.probZero);
    }

    @Override
    public int decodeLeastSignificantBits32(int nbits) {
        int result = 0;
        while (nbits > 0) {
            result = (result << 1) + (this.decodeNextBit() ? 1 : 0);
            --nbits;
        }
        return result;
    }

    @Override
    public void endDecoding() {
    }

    public void clear() {
        this.state = 4096;
    }
}

