/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.HashBuilder;
import dev.fileformat.drako.Struct;
import java.io.Serializable;

class RAnsBitCodec {
    protected static final int ANSP8_PRECISION = 256;
    protected static final int ANSP8_SHIFT = 8;
    protected static final int ANSP10_PRECISION = 1024;
    protected static final int L_BASE = 4096;
    protected static final int IO_BASE = 256;

    RAnsBitCodec() {
    }

    public static int computeRAnsUnclampedPrecision(int maxBitLength) {
        return 3 * maxBitLength / 2;
    }

    public static int computeRAnsPrecisionFromMaxSymbolBitLength(int maxBitLength) {
        return RAnsBitCodec.computeRAnsUnclampedPrecision(maxBitLength) < 12 ? 12 : (RAnsBitCodec.computeRAnsUnclampedPrecision(maxBitLength) > 20 ? 20 : RAnsBitCodec.computeRAnsUnclampedPrecision(maxBitLength));
    }

    public static final class RansSym
    implements Struct<RansSym>,
    Serializable {
        public int prob;
        public int cumProb;
        static final long serialVersionUID = -154003714L;

        public String toString() {
            return String.format("prob = %d, cumProb=%d", this.prob, this.cumProb);
        }

        public RansSym() {
        }

        private RansSym(RansSym other) {
            this.prob = other.prob;
            this.cumProb = other.cumProb;
        }

        @Override
        public RansSym clone() {
            return new RansSym(this);
        }

        @Override
        public void copyFrom(RansSym src) {
            if (src == null) {
                return;
            }
            this.prob = src.prob;
            this.cumProb = src.cumProb;
        }

        public int hashCode() {
            HashBuilder builder = new HashBuilder();
            builder.hash(this.prob);
            builder.hash(this.cumProb);
            return builder.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RansSym)) {
                return false;
            }
            RansSym rhs = (RansSym)obj;
            if (this.prob != rhs.prob) {
                return false;
            }
            return this.cumProb == rhs.cumProb;
        }
    }
}

