/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributesEncoder;
import dev.fileformat.drako.DracoEncodeOptions;
import dev.fileformat.drako.DracoPointCloud;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.EncoderBuffer;
import dev.fileformat.drako.PointAttribute;
import java.util.ArrayList;
import java.util.Arrays;

abstract class PointCloudEncoder {
    private DracoPointCloud pointCloud;
    private ArrayList<AttributesEncoder> attributesEncoders;
    private int[] attributeToEncoderMap;
    private int[] attributesEncoderIdsOrder;
    protected EncoderBuffer buffer;
    protected DracoEncodeOptions options;

    public PointCloudEncoder() {
        this.$initFields$();
    }

    public void encode(DracoEncodeOptions options, EncoderBuffer outBuffer) throws DrakoException {
        this.options = options;
        this.buffer = outBuffer;
        this.attributesEncoders.clear();
        this.attributeToEncoderMap = null;
        this.attributesEncoderIdsOrder = null;
        if (this.pointCloud == null) {
            throw DracoUtils.failed();
        }
        this.initializeEncoder();
        this.encodeEncoderData();
        this.encodeGeometryData();
        this.encodePointAttributes();
    }

    public int getGeometryType() {
        return 0;
    }

    public abstract int getEncodingMethod();

    public int getNumAttributesEncoders() {
        return this.attributesEncoders.size();
    }

    public AttributesEncoder attributesEncoder(int i) {
        return this.attributesEncoders.get(i);
    }

    public int addAttributesEncoder(AttributesEncoder attEnc) {
        this.attributesEncoders.add(attEnc);
        return this.attributesEncoders.size() - 1;
    }

    public boolean markParentAttribute(int parentAttId) {
        if (parentAttId < 0 || parentAttId >= this.pointCloud.getNumAttributes()) {
            return false;
        }
        int parentAttEncoderId = this.attributeToEncoderMap[parentAttId];
        return this.attributesEncoders.get(parentAttEncoderId).markParentAttribute(parentAttId);
    }

    public EncoderBuffer getBuffer() {
        return this.buffer;
    }

    public DracoEncodeOptions getOptions() {
        return this.options;
    }

    public DracoPointCloud getPointCloud() {
        return this.pointCloud;
    }

    public void setPointCloud(DracoPointCloud value) {
        this.pointCloud = value;
    }

    protected void initializeEncoder() {
    }

    protected void encodeEncoderData() {
    }

    protected void encodeGeometryData() throws DrakoException {
    }

    protected void encodePointAttributes() throws DrakoException {
        int i;
        this.generateAttributesEncoders();
        this.buffer.encode((byte)this.attributesEncoders.size());
        for (AttributesEncoder attEnc : this.attributesEncoders) {
            attEnc.initialize(this, this.pointCloud);
        }
        this.rearrangeAttributesEncoders();
        for (i = 0; i < this.attributesEncoderIdsOrder.length; ++i) {
            int attEncoderId = this.attributesEncoderIdsOrder[i];
            this.encodeAttributesEncoderIdentifier(attEncoderId);
        }
        for (i = 0; i < this.attributesEncoderIdsOrder.length; ++i) {
            int attEncoderId = this.attributesEncoderIdsOrder[i];
            this.attributesEncoders.get(attEncoderId).encodeAttributesEncoderData(this.buffer);
        }
        this.encodeAllAttributes();
    }

    protected void generateAttributesEncoders() throws DrakoException {
        int i;
        for (i = 0; i < this.pointCloud.getNumAttributes(); ++i) {
            this.generateAttributesEncoder(i);
        }
        this.attributeToEncoderMap = new int[this.pointCloud.getNumAttributes()];
        for (i = 0; i < this.attributesEncoders.size(); ++i) {
            for (int j = 0; j < this.attributesEncoders.get(i).getNumAttributes(); ++j) {
                this.attributeToEncoderMap[this.attributesEncoders.get((int)i).getAttributeId((int)j)] = i;
            }
        }
    }

    protected abstract void generateAttributesEncoder(int var1) throws DrakoException;

    protected void encodeAttributesEncoderIdentifier(int attEncoderId) {
    }

    protected void encodeAllAttributes() throws DrakoException {
        for (int i = 0; i < this.attributesEncoderIdsOrder.length; ++i) {
            int attEncoderId = this.attributesEncoderIdsOrder[i];
            this.attributesEncoders.get(attEncoderId).encodeAttributes(this.buffer);
        }
    }

    private void rearrangeAttributesEncoders() throws DrakoException {
        this.attributesEncoderIdsOrder = this.attributesEncoderIdsOrder == null ? new int[this.attributesEncoders.size()] : Arrays.copyOf(this.attributesEncoderIdsOrder, this.attributesEncoders.size());
        boolean[] isEncoderProcessed = new boolean[this.attributesEncoders.size()];
        int numProcessedEncoders = 0;
        while (numProcessedEncoders < this.attributesEncoders.size()) {
            boolean encoderProcessed = false;
            for (int i = 0; i < this.attributesEncoders.size(); ++i) {
                if (isEncoderProcessed[i]) continue;
                boolean canBeProcessed = true;
                block2: for (int p = 0; p < this.attributesEncoders.get(i).getNumAttributes(); ++p) {
                    int attId = this.attributesEncoders.get(i).getAttributeId(p);
                    for (int ap = 0; ap < this.attributesEncoders.get(i).numParentAttributes(attId); ++ap) {
                        int parentAttId = this.attributesEncoders.get(i).getParentAttributeId(attId, ap);
                        int parentEncoderId = this.attributeToEncoderMap[parentAttId];
                        if (parentAttId == i || isEncoderProcessed[parentEncoderId]) continue;
                        canBeProcessed = false;
                        continue block2;
                    }
                }
                if (!canBeProcessed) continue;
                this.attributesEncoderIdsOrder[numProcessedEncoders++] = i;
                isEncoderProcessed[i] = true;
                encoderProcessed = true;
            }
            if (encoderProcessed || numProcessedEncoders >= this.attributesEncoders.size()) continue;
            throw DracoUtils.failed();
        }
        int[] attributeEncodingOrder = null;
        boolean[] isAttributeProcessed = new boolean[this.pointCloud.getNumAttributes()];
        for (int aeOrder = 0; aeOrder < this.attributesEncoders.size(); ++aeOrder) {
            int ae = this.attributesEncoderIdsOrder[aeOrder];
            int numEncoderAttributes = this.attributesEncoders.get(ae).getNumAttributes();
            if (numEncoderAttributes < 2) continue;
            int numProcessedAttributes = 0;
            int[] nArray = attributeEncodingOrder = attributeEncodingOrder == null ? new int[numEncoderAttributes] : Arrays.copyOf(attributeEncodingOrder, numEncoderAttributes);
            while (numProcessedAttributes < numEncoderAttributes) {
                boolean attributeProcessed = false;
                for (int i = 0; i < numEncoderAttributes; ++i) {
                    int attId = this.attributesEncoders.get(ae).getAttributeId(i);
                    if (isAttributeProcessed[i]) continue;
                    boolean canBeProcessed = true;
                    for (int p = 0; p < this.attributesEncoders.get(ae).numParentAttributes(attId); ++p) {
                        int parentAttId = this.attributesEncoders.get(ae).getParentAttributeId(attId, p);
                        if (isAttributeProcessed[parentAttId]) continue;
                        canBeProcessed = false;
                        break;
                    }
                    if (!canBeProcessed) continue;
                    attributeEncodingOrder[numProcessedAttributes++] = i;
                    isAttributeProcessed[i] = true;
                    attributeProcessed = true;
                }
                if (attributeProcessed || numProcessedAttributes >= numEncoderAttributes) continue;
                throw DracoUtils.failed();
            }
            this.attributesEncoders.get(ae).setAttributeIds(attributeEncodingOrder);
        }
    }

    public PointAttribute getPortableAttribute(int parent_att_id) {
        if (parent_att_id < 0 || parent_att_id >= this.pointCloud.getNumAttributes()) {
            return null;
        }
        int parent_att_encoder_id = this.attributeToEncoderMap[parent_att_id];
        return this.attributesEncoders.get(parent_att_encoder_id).getPortableAttribute(parent_att_id);
    }

    private void $initFields$() {
        try {
            this.attributesEncoders = new ArrayList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

