/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.AttributesDecoder;
import dev.fileformat.drako.DecoderBuffer;
import dev.fileformat.drako.DracoHeader;
import dev.fileformat.drako.DracoLoadOptions;
import dev.fileformat.drako.DracoPointCloud;
import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.GeometryMetadata;
import dev.fileformat.drako.MetadataDecoder;
import dev.fileformat.drako.PointAttribute;
import java.util.Arrays;

abstract class PointCloudDecoder {
    protected DecoderBuffer buffer;
    protected DracoPointCloud pointCloud;
    protected AttributesDecoder[] attributesDecoders;
    protected int geometryType;
    DracoLoadOptions options;
    private int[] attributeToDecoderMap;
    private int bitstreamVersion;

    public int getBitstreamVersion() {
        return this.bitstreamVersion;
    }

    public void setBitstreamVersion(int value) {
        this.bitstreamVersion = value;
    }

    protected PointCloudDecoder(int geometryType) {
        this.$initFields$();
        this.geometryType = geometryType;
    }

    public DracoPointCloud getPointCloud() {
        return this.pointCloud;
    }

    public int getGeometryType() {
        return this.geometryType;
    }

    public void decode(DracoHeader header, DecoderBuffer buffer, DracoPointCloud result, boolean decodeData) throws DrakoException {
        this.buffer = buffer;
        this.pointCloud = result;
        this.setBitstreamVersion(header.version);
        if (header.version >= 13 && (0xFFFF & header.flags & Short.MIN_VALUE) == 32768) {
            this.decodeMetadata();
        }
        this.initializeDecoder();
        this.decodeGeometryData();
        this.decodePointAttributes(decodeData);
    }

    private void decodeMetadata() throws DrakoException {
        MetadataDecoder decoder = new MetadataDecoder();
        GeometryMetadata metadata = decoder.decode(this.buffer);
        this.pointCloud.getMetadatas().add(metadata);
    }

    public void setAttributesDecoder(int attDecoderId, AttributesDecoder decoder) throws DrakoException {
        if (attDecoderId < 0) {
            throw DracoUtils.failed();
        }
        if (attDecoderId >= this.attributesDecoders.length) {
            this.attributesDecoders = this.attributesDecoders == null ? new AttributesDecoder[attDecoderId + 1] : Arrays.copyOf(this.attributesDecoders, attDecoderId + 1);
        }
        this.attributesDecoders[attDecoderId] = decoder;
    }

    public AttributesDecoder[] getAttributesDecoders() {
        return this.attributesDecoders;
    }

    protected void initializeDecoder() throws DrakoException {
    }

    protected void decodeGeometryData() throws DrakoException {
    }

    protected void decodePointAttributes(boolean decodeAttributeData) throws DrakoException {
        int attId;
        int numAttributes;
        int i;
        byte numAttributesDecoders = this.buffer.decodeU8();
        for (int i2 = 0; i2 < (0xFF & numAttributesDecoders); ++i2) {
            this.createAttributesDecoder(i2);
        }
        for (AttributesDecoder dec : this.attributesDecoders) {
            dec.initialize(this, this.pointCloud);
        }
        for (AttributesDecoder dec : this.attributesDecoders) {
            dec.decodeAttributesDecoderData(this.buffer);
        }
        int maxAttrId = -1;
        for (i = 0; i < this.attributesDecoders.length; ++i) {
            numAttributes = this.attributesDecoders[i].getNumAttributes();
            for (int j = 0; j < numAttributes; ++j) {
                attId = this.attributesDecoders[i].getAttributeId(j);
                maxAttrId = Math.max(attId, maxAttrId);
            }
        }
        this.attributeToDecoderMap = new int[maxAttrId + 1];
        for (i = 0; i < this.attributesDecoders.length; ++i) {
            numAttributes = this.attributesDecoders[i].getNumAttributes();
            for (int j = 0; j < numAttributes; ++j) {
                attId = this.attributesDecoders[i].getAttributeId(j);
                this.attributeToDecoderMap[attId] = i;
            }
        }
        if (decodeAttributeData) {
            this.decodeAllAttributes();
        }
        this.onAttributesDecoded();
    }

    protected abstract void createAttributesDecoder(int var1) throws DrakoException;

    protected void onAttributesDecoded() {
    }

    protected void decodeAllAttributes() throws DrakoException {
        for (AttributesDecoder dec : this.attributesDecoders) {
            dec.decodeAttributes(this.buffer);
        }
    }

    public DecoderBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(DecoderBuffer value) {
        this.buffer = value;
    }

    public PointAttribute getPortableAttribute(int attId) {
        if (attId < 0 || attId >= this.pointCloud.getNumAttributes()) {
            return null;
        }
        int parentAttDecoderId = this.attributeToDecoderMap[attId];
        return this.attributesDecoders[parentAttDecoderId].getPortableAttribute(attId);
    }

    private void $initFields$() {
        try {
            this.attributesDecoders = new AttributesDecoder[0];
            this.options = new DracoLoadOptions();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

