/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Decoding;
import dev.fileformat.drako.DrakoException;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.LinearSequencer;
import dev.fileformat.drako.MeshDecoder;
import dev.fileformat.drako.SequentialAttributeDecodersController;

class MeshSequentialDecoder
extends MeshDecoder {
    MeshSequentialDecoder() {
    }

    @Override
    protected void decodeConnectivity() throws DrakoException {
        int numPoints;
        int numFaces;
        if (this.getBitstreamVersion() < 22) {
            numFaces = this.getBuffer().decodeU32();
            numPoints = this.getBuffer().decodeU32();
        } else {
            numFaces = Decoding.decodeVarintU32(this.buffer);
            numPoints = Decoding.decodeVarintU32(this.buffer);
        }
        byte connectivityMethod = this.getBuffer().decodeU8();
        if (connectivityMethod == 0) {
            this.decodeAndDecompressIndices(numFaces);
        } else if ((0xFFFFFFFFL & (long)numPoints) < 256L) {
            int[] face = new int[3];
            int i = 0;
            while ((long)i < (0xFFFFFFFFL & (long)numFaces)) {
                for (int j = 0; j < 3; ++j) {
                    byte val = this.buffer.decodeU8();
                    face[j] = 0xFF & val;
                }
                this.getMesh().addFace(face);
                ++i;
            }
        } else if ((0xFFFFFFFFL & (long)numPoints) < 65536L) {
            int[] face = new int[3];
            int i = 0;
            while ((long)i < (0xFFFFFFFFL & (long)numFaces)) {
                for (int j = 0; j < 3; ++j) {
                    short val = this.getBuffer().decodeU16();
                    face[j] = 0xFFFF & val;
                }
                this.getMesh().addFace(face);
                ++i;
            }
        } else if (this.getMesh().getNumPoints() < 0x200000 && this.getBitstreamVersion() >= 22) {
            int[] face = new int[3];
            int i = 0;
            while ((long)i < (0xFFFFFFFFL & (long)numFaces)) {
                for (int j = 0; j < 3; ++j) {
                    int val;
                    face[j] = val = Decoding.decodeVarintU32(this.buffer);
                }
                this.getMesh().addFace(face);
                ++i;
            }
        } else {
            int[] face = new int[3];
            int i = 0;
            while ((long)i < (0xFFFFFFFFL & (long)numFaces)) {
                for (int j = 0; j < 3; ++j) {
                    int val;
                    face[j] = val = this.getBuffer().decodeI32();
                }
                this.getMesh().addFace(face);
                ++i;
            }
        }
        this.getPointCloud().setNumPoints(numPoints);
    }

    @Override
    protected void createAttributesDecoder(int attrDecoderId) throws DrakoException {
        this.setAttributesDecoder(attrDecoderId, new SequentialAttributeDecodersController(new LinearSequencer(this.getPointCloud().getNumPoints())));
    }

    void decodeAndDecompressIndices(int numFaces) throws DrakoException {
        IntSpan indicesBuffer = IntSpan.wrap(new int[numFaces * 3]);
        Decoding.decodeSymbols(numFaces * 3, 1, this.getBuffer(), indicesBuffer);
        int lastIndexValue = 0;
        int vertexIndex = 0;
        int[] face = new int[3];
        for (int i = 0; i < numFaces; ++i) {
            for (int j = 0; j < 3; ++j) {
                int indexValue;
                int encodedVal = indicesBuffer.get(vertexIndex++);
                int indexDiff = encodedVal >> 1;
                if ((encodedVal & 1) != 0) {
                    indexDiff = -indexDiff;
                }
                face[j] = indexValue = indexDiff + lastIndexValue;
                lastIndexValue = indexValue;
            }
            this.getMesh().addFace(face);
        }
    }
}

