/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DracoUtils;
import dev.fileformat.drako.IntSpan;
import dev.fileformat.drako.LongVector3;
import dev.fileformat.drako.MeshPredictionSchemeData;
import dev.fileformat.drako.PointAttribute;
import java.util.Arrays;

class MeshPredictionSchemeTexCoordsPortablePredictor {
    private static final int K_NUM_COMPONENTS = 2;
    public PointAttribute pos_attribute_;
    public int[] entry_to_point_id_map_;
    public int[] predicted_value_;
    private boolean[] orientations_;
    private int orientationCount = 0;
    MeshPredictionSchemeData mesh_data_;

    public MeshPredictionSchemeTexCoordsPortablePredictor(MeshPredictionSchemeData md) {
        this.$initFields$();
        this.pos_attribute_ = null;
        this.entry_to_point_id_map_ = null;
        this.mesh_data_ = md;
    }

    boolean isInitialized() {
        return this.pos_attribute_ != null;
    }

    LongVector3 getPositionForEntryId(int entry_id) {
        int point_id = this.entry_to_point_id_map_[entry_id];
        LongVector3 pos = this.pos_attribute_.convertValue(this.pos_attribute_.mappedIndex(point_id));
        return pos;
    }

    LongVector3 getTexCoordForEntryId(int entry_id, IntSpan data) {
        int data_offset = entry_id * 2;
        return new LongVector3(data.get(data_offset), data.get(data_offset + 1));
    }

    public boolean computePredictedValue(boolean is_encoder_t, int corner_id, IntSpan data, int data_id) {
        int next_corner_id = this.mesh_data_.getCornerTable().next(corner_id);
        int prev_corner_id = this.mesh_data_.getCornerTable().previous(corner_id);
        int next_vert_id = this.mesh_data_.getCornerTable().vertex(next_corner_id);
        int prev_vert_id = this.mesh_data_.getCornerTable().vertex(prev_corner_id);
        int next_data_id = this.mesh_data_.vertexToDataMap[next_vert_id];
        int prev_data_id = this.mesh_data_.vertexToDataMap[prev_vert_id];
        if (prev_data_id < data_id && next_data_id < data_id) {
            LongVector3 n_uv = this.getTexCoordForEntryId(next_data_id, data);
            LongVector3 p_uv = this.getTexCoordForEntryId(prev_data_id, data);
            if (DracoUtils.vecEquals(p_uv, n_uv)) {
                this.predicted_value_[0] = (int)p_uv.x;
                this.predicted_value_[1] = (int)p_uv.y;
                return true;
            }
            LongVector3 tip_pos = this.getPositionForEntryId(data_id);
            LongVector3 next_pos = this.getPositionForEntryId(next_data_id);
            LongVector3 prev_pos = this.getPositionForEntryId(prev_data_id);
            LongVector3 pn = DracoUtils.sub(prev_pos, next_pos);
            int pn_norm2_squared = DracoUtils.squaredNorm(pn);
            if ((0xFFFFFFFFL & (long)pn_norm2_squared) != 0L) {
                LongVector3 cn = DracoUtils.sub(tip_pos, next_pos);
                long cn_dot_pn = DracoUtils.dot(pn, cn);
                LongVector3 pn_uv = DracoUtils.sub(p_uv, n_uv);
                LongVector3 x_uv = DracoUtils.add(DracoUtils.mul(n_uv, 0xFFFFFFFFL & (long)pn_norm2_squared), DracoUtils.mul(pn_uv, cn_dot_pn));
                LongVector3 x_pos = DracoUtils.add(next_pos, DracoUtils.div(DracoUtils.mul(pn, cn_dot_pn), 0xFFFFFFFFL & (long)pn_norm2_squared));
                long cx_norm2_squared = 0xFFFFFFFFL & (long)DracoUtils.squaredNorm(DracoUtils.sub(tip_pos, x_pos));
                LongVector3 cx_uv = new LongVector3(pn_uv.y, -pn_uv.x);
                int norm_squared = (int)DracoUtils.intSqrt(cx_norm2_squared * (0xFFFFFFFFL & (long)pn_norm2_squared));
                cx_uv.copyFrom(DracoUtils.mul(cx_uv, 0xFFFFFFFFL & (long)norm_squared));
                LongVector3 predicted_uv = new LongVector3();
                if (is_encoder_t) {
                    LongVector3 predicted_uv_0 = DracoUtils.div(DracoUtils.add(x_uv, cx_uv), 0xFFFFFFFFL & (long)pn_norm2_squared);
                    LongVector3 predicted_uv_1 = DracoUtils.div(DracoUtils.sub(x_uv, cx_uv), 0xFFFFFFFFL & (long)pn_norm2_squared);
                    LongVector3 c_uv = this.getTexCoordForEntryId(data_id, data);
                    if (this.orientationCount == this.orientations_.length) {
                        boolean[] blArray = this.orientations_ = this.orientations_ == null ? new boolean[this.orientations_.length + (this.orientations_.length >> 1)] : Arrays.copyOf(this.orientations_, this.orientations_.length + (this.orientations_.length >> 1));
                    }
                    if ((0xFFFFFFFFL & (long)DracoUtils.squaredNorm(DracoUtils.sub(c_uv, predicted_uv_0))) < (0xFFFFFFFFL & (long)DracoUtils.squaredNorm(DracoUtils.sub(c_uv, predicted_uv_1)))) {
                        predicted_uv.copyFrom(predicted_uv_0);
                        this.orientations_[this.orientationCount++] = true;
                    } else {
                        predicted_uv.copyFrom(predicted_uv_1);
                        this.orientations_[this.orientationCount++] = false;
                    }
                } else {
                    if (this.orientationCount == 0) {
                        return false;
                    }
                    boolean orientation = this.orientations_[this.orientationCount - 1];
                    --this.orientationCount;
                    if (orientation) {
                        predicted_uv.copyFrom(DracoUtils.div(DracoUtils.add(x_uv, cx_uv), 0xFFFFFFFFL & (long)pn_norm2_squared));
                    } else {
                        predicted_uv.copyFrom(DracoUtils.div(DracoUtils.sub(x_uv, cx_uv), 0xFFFFFFFFL & (long)pn_norm2_squared));
                    }
                }
                this.predicted_value_[0] = (int)predicted_uv.x;
                this.predicted_value_[1] = (int)predicted_uv.y;
                return true;
            }
        }
        int data_offset = 0;
        if (prev_data_id < data_id) {
            data_offset = prev_data_id * 2;
        }
        if (next_data_id < data_id) {
            data_offset = next_data_id * 2;
        } else if (data_id > 0) {
            data_offset = (data_id - 1) * 2;
        } else {
            for (int i = 0; i < 2; ++i) {
                this.predicted_value_[i] = 0;
            }
            return true;
        }
        for (int i = 0; i < 2; ++i) {
            this.predicted_value_[i] = data.get(data_offset + i);
        }
        return true;
    }

    public boolean orientation(int i) {
        return this.orientations_[i];
    }

    public void set_orientation(int i, boolean v) {
        this.orientations_[i] = v;
    }

    public int num_orientations() {
        return this.orientationCount;
    }

    public void resizeOrientations(int num_orientations) {
        this.orientations_ = this.orientations_ == null ? new boolean[num_orientations] : Arrays.copyOf(this.orientations_, num_orientations);
        this.orientationCount = num_orientations;
    }

    private void $initFields$() {
        try {
            this.predicted_value_ = new int[2];
            this.orientations_ = new boolean[10];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

