/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.DracoMesh;
import dev.fileformat.drako.ICornerTable;
import dev.fileformat.drako.MeshAttributeIndicesEncodingData;
import dev.fileformat.drako.PointsSequencer;

class MeshAttributeIndicesEncodingObserver<TCornerTable extends ICornerTable> {
    private TCornerTable attConnectivity;
    private MeshAttributeIndicesEncodingData encodingData;
    private DracoMesh mesh;
    private PointsSequencer sequencer;

    public MeshAttributeIndicesEncodingObserver(TCornerTable cornerTable, DracoMesh mesh, PointsSequencer sequencer, MeshAttributeIndicesEncodingData encodingData) {
        this.encodingData = encodingData;
        this.mesh = mesh;
        this.attConnectivity = cornerTable;
        this.sequencer = sequencer;
    }

    public TCornerTable getCornerTable() {
        return this.attConnectivity;
    }

    public void onNewFaceVisited(int face) {
    }

    public void onNewVertexVisited(int vertex, int corner) {
        int pointId = this.mesh.readCorner(corner);
        this.sequencer.addPointId(pointId);
        this.encodingData.encodedAttributeValueIndexToCornerMap.add(corner);
        this.encodingData.vertexToEncodedAttributeValueIndexMap[vertex] = this.encodingData.numValues++;
    }
}

