/*
 * Decompiled with CFR 0.152.
 */
package dev.fileformat.drako;

import dev.fileformat.drako.Internal;
import dev.fileformat.drako.Span;

@Internal
abstract class IntSpan
extends Span {
    public static IntSpan wrap(int[] array) {
        return new ArraySpan(array, 0, array.length);
    }

    public static IntSpan wrap(int[] array, int offset, int length) {
        return new ArraySpan(array, offset, length);
    }

    public static IntSpan wrap(int[] array, int offset) {
        return new ArraySpan(array, offset, array.length - offset);
    }

    public static IntSpan wrap(byte[] array) {
        return new BytesSpan(array, 0, array.length / 4);
    }

    public static IntSpan wrap(byte[] array, int offset, int length) {
        return new BytesSpan(array, offset / 4, length / 4);
    }

    protected IntSpan(int offset, int length) {
        super(offset, length);
    }

    public int compareTo(IntSpan span) {
        int num = Math.min(this.size(), span.size());
        for (int i = 0; i < num; ++i) {
            int n = Integer.compare(this.get(i), span.get(i));
            if (n == 0) continue;
            return n;
        }
        return Integer.compare(this.size(), span.size());
    }

    public boolean equals(IntSpan span) {
        if (this.size() != span.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == span.get(i)) continue;
            return false;
        }
        return true;
    }

    public void copyTo(IntSpan span) {
        for (int i = 0; i < this.size(); ++i) {
            span.put(i, this.get(i));
        }
    }

    public void fill(int v) {
        for (int i = 0; i < this.size(); ++i) {
            this.put(i, v);
        }
    }

    public int[] toArray() {
        int[] ret = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            ret[i] = this.get(i);
        }
        return ret;
    }

    public abstract int get(int var1);

    public abstract void put(int var1, int var2);

    public abstract IntSpan slice(int var1, int var2);

    public IntSpan slice(int offset) {
        return this.slice(offset, this.length - offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < Math.min(10, this.length); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    private static final class BytesSpan
    extends IntSpan {
        private final byte[] array;

        public BytesSpan(byte[] array, int offset, int length) {
            super(offset, length);
            this.array = array;
        }

        @Override
        public int get(int idx) {
            this.rangeCheck(idx);
            int ptr = (idx + this.offset) * 4;
            return BytesSpan.getIntL(this.array, ptr);
        }

        @Override
        public void put(int idx, int value) {
            this.rangeCheck(idx);
            int ptr = (idx + this.offset) * 4;
            BytesSpan.putIntL(this.array, ptr, value);
        }

        @Override
        public IntSpan slice(int offset, int size) {
            return new BytesSpan(this.array, offset + this.offset, size);
        }
    }

    private static final class ArraySpan
    extends IntSpan {
        private final int[] array;

        public ArraySpan(int[] array, int offset, int length) {
            super(offset, length);
            this.array = array;
        }

        @Override
        public int get(int idx) {
            return this.array[idx + this.offset];
        }

        @Override
        public void put(int idx, int value) {
            this.rangeCheck(idx);
            this.array[idx + this.offset] = value;
        }

        @Override
        public IntSpan slice(int offset, int size) {
            return new ArraySpan(this.array, offset + this.offset, size);
        }
    }
}

